/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import uchicago.src.sim.network.DlReader;
import uchicago.src.sim.network.ExcelMatrixReader;
import uchicago.src.sim.network.NetUtilities;
import uchicago.src.sim.network.NetworkConstants;
import uchicago.src.sim.network.NetworkConvertor;
import uchicago.src.sim.network.NetworkMatrixReader;
import uchicago.src.sim.network.Node;
import uchicago.src.sim.network.RandomDensityNet;
import uchicago.src.sim.network.SquareLatticeNet;
import uchicago.src.sim.util.SimUtilities;

public class NetworkFactory
implements NetworkConstants {
    private NetworkFactory() {
    }

    public static List getNetwork(String string, int n, Class clazz, Class clazz2, int n2) {
        NetworkMatrixReader networkMatrixReader = null;
        if (n == 0) {
            networkMatrixReader = new DlReader(string);
        } else if (n == 1) {
            networkMatrixReader = new ExcelMatrixReader(string);
        } else {
            throw new IllegalArgumentException("Unsupported file format");
        }
        Vector vector = null;
        try {
            vector = networkMatrixReader.getMatrices(n2);
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error creating network from file", iOException);
            System.exit(0);
        }
        networkMatrixReader.close();
        return NetworkConvertor.matricesToNodes(vector, clazz, clazz2);
    }

    public static List getDLNetworkFromStream(InputStream inputStream, Class clazz, Class clazz2, int n) {
        DlReader dlReader = new DlReader(inputStream);
        Vector vector = null;
        try {
            vector = dlReader.getMatrices(n);
        }
        catch (IOException iOException) {
            SimUtilities.showError("Error creating network from file", iOException);
            System.exit(0);
        }
        dlReader.close();
        return NetworkConvertor.matricesToNodes(vector, clazz, clazz2);
    }

    public static List getNetwork(String string, int n, Class clazz, Class clazz2) {
        return NetworkFactory.getNetwork(string, n, clazz, clazz2, 2);
    }

    public static List createUnlinkedNetwork(int n, Class clazz) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        try {
            for (int i = 0; i < n; ++i) {
                Node node = (Node)clazz.newInstance();
                arrayList.add(node);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            SimUtilities.showError("Error creating node from " + clazz.getName(), illegalAccessException);
            System.exit(0);
        }
        catch (InstantiationException instantiationException) {
            SimUtilities.showError("Error creating node from " + clazz.getName(), instantiationException);
            System.exit(0);
        }
        return arrayList;
    }

    public static List createSquareLatticeNetwork(int n, int n2, boolean bl, int n3, Class clazz, Class clazz2) {
        SquareLatticeNet squareLatticeNet = new SquareLatticeNet(clazz, clazz2, n, n2, bl, n3);
        ArrayList arrayList = null;
        try {
            arrayList = squareLatticeNet.createSquareLatticeNet();
        }
        catch (IllegalAccessException illegalAccessException) {
            SimUtilities.showError("Error creating SquareLatticeNet", illegalAccessException);
            System.exit(0);
        }
        catch (InstantiationException instantiationException) {
            SimUtilities.showError("Error creating SquareLatticeNet", instantiationException);
            System.exit(0);
        }
        return arrayList;
    }

    public static List createRandomDensityNetwork(int n, double d, boolean bl, boolean bl2, Class clazz, Class clazz2) {
        RandomDensityNet randomDensityNet = new RandomDensityNet(clazz, clazz2, n, d, bl, bl2);
        ArrayList arrayList = null;
        try {
            arrayList = randomDensityNet.createRandomDensityNet();
        }
        catch (IllegalAccessException illegalAccessException) {
            SimUtilities.showError("Error creating RandomDensityNet", illegalAccessException);
            System.exit(0);
        }
        catch (InstantiationException instantiationException) {
            SimUtilities.showError("Error creating RandomDensityNet", instantiationException);
            System.exit(0);
        }
        return arrayList;
    }

    public static List createWattsStrogatzNetwork(int n, int n2, double d, Class clazz, Class clazz2) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(NetworkFactory.createSquareLatticeNetwork(n, 1, true, n2, clazz, clazz2));
        arrayList = new ArrayList(NetUtilities.randomRewireSymmetric(arrayList, d));
        return arrayList;
    }
}

