/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import logist.plan.Action;
import logist.plan.Plan;
import logist.task.Task;
import logist.topology.Topology;
import template.PD_Action;

public class New_Vehicle {
    private int capacity;
    private Topology.City initCity;
    private double costPerKm;
    public ArrayList<PD_Action> actions;
    private HashMap<Integer, Task> tasks;

    public New_Vehicle(Topology.City initCity, int capacity, double costPerKm) {
        this.initCity = initCity;
        this.capacity = capacity;
        this.costPerKm = costPerKm;
        this.actions = new ArrayList();
        this.tasks = new HashMap();
    }

    public double marginalCost(List<Task> tasks) {
        double cost0 = this.cost();
        int[] i_pickup = new int[tasks.size()];
        int[] i_deliver = new int[tasks.size()];
        int i = 0;
        for (Task task : tasks) {
            PD_Action pickup = new PD_Action(true, task.pickupCity, task.weight, task.id);
            i_pickup[i] = this.addAction(pickup, 0);
            PD_Action deliver = new PD_Action(false, task.deliveryCity, task.weight, task.id);
            i_deliver[i] = this.addAction(deliver, i_pickup[i] + 1);
            ++i;
        }
        double cost = this.cost();
        for (i = tasks.size() - 1; i >= 0; --i) {
            this.actions.remove(i_deliver[i]);
            this.actions.remove(i_pickup[i]);
        }
        return cost - cost0;
    }

    public double marginalCost(Task task) {
        double cost0 = this.cost();
        PD_Action pickup = new PD_Action(true, task.pickupCity, task.weight, task.id);
        int i_pickup = this.addAction(pickup, 0);
        PD_Action deliver = new PD_Action(false, task.deliveryCity, task.weight, task.id);
        int i_deliver = this.addAction(deliver, i_pickup + 1);
        double cost = this.cost();
        this.actions.remove(i_deliver);
        this.actions.remove(i_pickup);
        return cost - cost0;
    }

    public void addTask(Task task) {
        PD_Action pickup = new PD_Action(true, task.pickupCity, task.weight, task.id);
        int i_pickup = this.addAction(pickup, 0);
        PD_Action deliver = new PD_Action(false, task.deliveryCity, task.weight, task.id);
        this.addAction(deliver, i_pickup + 1);
        this.tasks.put(task.id, task);
    }

    private int addAction(PD_Action action, int i_min0) {
        int i_min = i_min0;
        double c_min = Double.MAX_VALUE;
        for (int i = i_min0; i <= this.actions.size(); ++i) {
            this.actions.add(i, action);
            if (this.isConsistent() && this.cost() < c_min) {
                i_min = i;
                c_min = this.cost();
            }
            this.actions.remove(i);
        }
        this.actions.add(i_min, action);
        return i_min;
    }

    private boolean isConsistent() {
        int c = 0;
        for (PD_Action a : this.actions) {
            if ((c += a.getWeight()) <= this.capacity) continue;
            return false;
        }
        return true;
    }

    private double cost() {
        double cost = 0.0;
        Topology.City c = this.initCity;
        for (PD_Action a : this.actions) {
            cost += c.distanceTo(a.getCity()) * this.costPerKm;
            c = a.getCity();
        }
        return cost;
    }

    public Plan getPlan() {
        Topology.City current = this.initCity;
        Plan plan = new Plan(current, new Action[0]);
        for (PD_Action a : this.actions) {
            for (Topology.City city : current.pathTo(a.getCity())) {
                plan.appendMove(city);
            }
            if (a.isPickup()) {
                plan.appendPickup(this.tasks.get(a.id));
            } else {
                plan.appendDelivery(this.tasks.get(a.id));
            }
            current = a.getCity();
        }
        return plan;
    }
}

