/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.util.ArrayList;
import java.util.List;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.Task;
import template.New_Vehicle;

public class New_Plan {
    private ArrayList<New_Vehicle> vehicles = new ArrayList();

    public New_Plan(List<Vehicle> vehicles) {
        for (int i = 0; i < vehicles.size(); ++i) {
            Vehicle vehicle = vehicles.get(i);
            this.vehicles.add(i, new New_Vehicle(vehicle.homeCity(), vehicle.capacity(), vehicle.costPerKm()));
        }
    }

    public void assignTask(Task task) {
        int vehicle_id = 0;
        double min_cost = 1.0E9;
        int id = 0;
        for (New_Vehicle vehicle : this.vehicles) {
            double cost = vehicle.marginalCost(task);
            if (cost < min_cost) {
                min_cost = cost;
                vehicle_id = id;
            }
            ++id;
        }
        this.vehicles.get(vehicle_id).addTask(task);
    }

    public double lowestMarginalCost(Task task) {
        double min_cost = 1.0E9;
        for (New_Vehicle vehicle : this.vehicles) {
            double cost = vehicle.marginalCost(task);
            if (!(cost < min_cost)) continue;
            min_cost = cost;
        }
        return min_cost;
    }

    public double averageLowestMarginalCost(List<Task> tasks) {
        double min_cost = this.vehicles.get(0).marginalCost(tasks);
        for (New_Vehicle v : this.vehicles) {
            double marginal_cost = v.marginalCost(tasks);
            if (!(marginal_cost < min_cost)) continue;
            min_cost = marginal_cost;
        }
        if (tasks.size() / this.vehicles.size() > 0) {
            double mean_marginal_cost = 0.0;
            for (int i = 0; i < this.vehicles.size(); ++i) {
                mean_marginal_cost += this.vehicles.get(i).marginalCost(tasks.subList(i * tasks.size() / this.vehicles.size(), (i + 1) * tasks.size() / this.vehicles.size()));
            }
            if (mean_marginal_cost < min_cost) {
                min_cost = mean_marginal_cost;
            }
        }
        return min_cost / (double)tasks.size();
    }

    public List<Plan> getPlans() {
        ArrayList<Plan> plans = new ArrayList<Plan>();
        for (New_Vehicle v : this.vehicles) {
            plans.add(v.getPlan());
        }
        return plans;
    }
}

