/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.messaging;

import epfl.lia.logist.config.Configuration;
import epfl.lia.logist.core.IService;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.messaging.Message;
import epfl.lia.logist.messaging.MessageBox;
import epfl.lia.logist.messaging.MessageHandler;
import epfl.lia.logist.tools.AID;
import epfl.lia.logist.tools.LogistGlobals;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDispatcher
implements IService {
    private HashMap<AID, MessageBox> mMessageBoxes = null;
    private static MessageDispatcher msSingleton = null;

    public MessageDispatcher() {
        if (msSingleton == null) {
            msSingleton = this;
        }
    }

    public void post(Message<?> m) {
        MessageBox mBox;
        if (m == null) {
            return;
        }
        if (m.getRecipientID() == AID.BROADCAST_ADDRESS) {
            this.postToEveryone(m);
        } else if (this.mMessageBoxes.containsKey(m.getRecipientID()) && (mBox = this.mMessageBoxes.get(m.getRecipientID())) != null) {
            mBox.store(m);
        }
    }

    protected void postToEveryone(Message<?> m) {
        for (MessageBox mBox : this.mMessageBoxes.values()) {
            mBox.store(m);
        }
    }

    public Message<?> retrieve(MessageHandler m) {
        MessageBox mBox = this.mMessageBoxes.get(m.getObjectID());
        if (mBox != null && !mBox.isEmpty()) {
            Message<?> mm = mBox.retrieve();
            return mm;
        }
        return null;
    }

    public boolean check(MessageHandler m) {
        if (this.mMessageBoxes == null) {
            return false;
        }
        MessageBox mBox = this.mMessageBoxes.get(m.getObjectID());
        if (mBox != null) {
            return !mBox.isEmpty();
        }
        return false;
    }

    public static MessageDispatcher getInstance() {
        return msSingleton;
    }

    public void register(MessageHandler m) {
        if (!this.mMessageBoxes.containsKey(m.getObjectID())) {
            this.mMessageBoxes.put(m.getObjectID(), new MessageBox());
        }
    }

    public boolean unregister(MessageHandler m) {
        return this.mMessageBoxes.remove(m.getObjectID()) != null;
    }

    public boolean unregister(AID mid) {
        return this.mMessageBoxes.remove(mid) != null;
    }

    @Override
    public void init() {
        if (this.mMessageBoxes == null) {
            this.mMessageBoxes = new HashMap();
        } else {
            this.mMessageBoxes.clear();
        }
        Runtime.getRuntime().gc();
    }

    @Override
    public void shutdown() {
        if (this.mMessageBoxes == null) {
            return;
        }
        for (MessageBox mb : this.mMessageBoxes.values()) {
            mb.trashAll();
        }
        this.mMessageBoxes.clear();
        this.mMessageBoxes = null;
        Runtime.getRuntime().gc();
    }

    @Override
    public void setup(Configuration cfg, LogistGlobals lg) {
    }

    @Override
    public void reset(int round) {
        LogManager.getInstance().log(LogManager.DEFAULT, LogSeverityEnum.LSV_WARNING, "Beginning of round " + round + ": " + "trashing all pending messages...");
        for (MessageBox mb : this.mMessageBoxes.values()) {
            mb.trashAll();
        }
    }

    public String toString() {
        return "Inter-object messaging service";
    }
}

