/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.config;

import epfl.lia.logist.agent.AgentDescriptor;
import epfl.lia.logist.agent.AgentsetDescriptor;
import epfl.lia.logist.agent.behavior.BehaviorDescriptor;
import epfl.lia.logist.config.Configuration;
import epfl.lia.logist.core.topology.CityDescriptor;
import epfl.lia.logist.core.topology.RouteDescriptor;
import epfl.lia.logist.core.topology.TopologyDescriptor;
import epfl.lia.logist.exception.ConfigurationParsingError;
import epfl.lia.logist.logging.LogDescriptor;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogsetDescriptor;
import epfl.lia.logist.task.ProbabilityDescriptor;
import epfl.lia.logist.task.TaskDescriptor;
import epfl.lia.logist.task.TaskDistributionDescriptor;
import epfl.lia.logist.task.TaskgenDescriptor;
import epfl.lia.logist.task.TasksetDescriptor;
import epfl.lia.logist.tools.Convert;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.jdom.Attribute;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationReader {
    private File mFile = null;
    private LogManager mLogMgr = null;
    private File mBaseDirectory = null;

    public ConfigurationReader(File cf) throws FileNotFoundException {
        this.mFile = cf;
        if (!cf.exists()) {
            throw new FileNotFoundException(cf.getAbsolutePath());
        }
        this.mBaseDirectory = cf.getParentFile();
        this.mLogMgr = LogManager.getInstance();
    }

    public Configuration load(String name) throws Exception {
        List configurationElements;
        Element configurationElement;
        Element rootElement = this.loadXMLRootFromDisk(this.mFile.getPath());
        if (rootElement == null) {
            throw new ConfigurationParsingError("The configuration file could not be loaded! Check file syntax !");
        }
        if (!rootElement.getName().equals("simulation")) {
            throw new ConfigurationParsingError("Malformed configuration file. Root element must be <simulation>.");
        }
        Attribute versionAttribute = rootElement.getAttribute("version");
        Attribute defaultAttribute = rootElement.getAttribute("default");
        if (versionAttribute == null) {
            throw new ConfigurationParsingError("The version attribute of the <simulation> tag is mandatory !");
        }
        String platformVersionStr = "1.0";
        if (!versionAttribute.getValue().equals(platformVersionStr)) {
            throw new ConfigurationParsingError("Wrong configuration file version. Should be " + platformVersionStr);
        }
        if (!(name != null && name.length() != 0 || defaultAttribute != null && defaultAttribute.getValue().length() != 0)) {
            throw new ConfigurationParsingError("You must specify aname for the configuration to load, or set the default attribute to a correct value !");
        }
        if (name == null || name.length() == 0) {
            name = defaultAttribute.getValue();
        }
        if ((configurationElement = this.findConfigurationByName(configurationElements = rootElement.getChildren("configuration"), name)) == null && name != null && name.length() != 0) {
            throw new ConfigurationParsingError("The configuration named '" + name + "' was not found !");
        }
        Configuration configuration = this.handleConfiguration(configurationElement);
        return configuration;
    }

    private Element findConfigurationByName(List configurationElements, String configurationName) {
        for (Element nextElement : configurationElements) {
            Attribute nameAttribute = nextElement.getAttribute("name");
            if (nameAttribute == null || nameAttribute.getValue().length() == 0 || !nameAttribute.getValue().equals(configurationName)) continue;
            return nextElement;
        }
        return null;
    }

    private Configuration handleConfiguration(Element configurationElement) throws ConfigurationParsingError {
        Configuration configurationObject = new Configuration();
        configurationElement = this.loadXMLExternal(configurationElement);
        Attribute nameAttribute = configurationElement.getAttribute("name");
        this.mLogMgr.info("New configuration found: '" + nameAttribute.getValue() + "'");
        configurationObject.Name = nameAttribute.getValue();
        configurationObject.Propset = this.handlePropertyset(configurationElement, true);
        configurationObject.Logs = this.handleLogset(configurationElement);
        configurationObject.Tasks = this.handleTaskset(configurationElement);
        configurationObject.Topology = this.handleToposet(configurationElement);
        configurationObject.Agents = this.handleAgentset(configurationElement);
        return configurationObject;
    }

    private LogsetDescriptor handleLogset(Element configurationElement) throws ConfigurationParsingError {
        Element logsetElement = this.getFirstElement(configurationElement, "logset", true);
        logsetElement = this.loadXMLExternal(logsetElement);
        assert (logsetElement != null);
        this.mLogMgr.info("Found a new logset: '" + logsetElement.getAttributeValue("name") + "'");
        LogsetDescriptor descriptor = new LogsetDescriptor();
        List logElements = logsetElement.getChildren("log");
        if (logElements != null && !logElements.isEmpty()) {
            descriptor.Logs = this.handleLogElements(logElements);
        }
        return descriptor;
    }

    private HashMap<String, LogDescriptor> handleLogElements(List logElements) throws ConfigurationParsingError {
        HashMap<String, LogDescriptor> logDescriptorTable = new HashMap<String, LogDescriptor>();
        for (Element logElement : logElements) {
            LogDescriptor logDescriptor = this.handleLogElement(logElement);
            if (logDescriptor == null) continue;
            if (!logDescriptorTable.containsKey(logDescriptor.ID)) {
                logDescriptorTable.put(logDescriptor.ID, logDescriptor);
                continue;
            }
            this.mLogMgr.warning("Log file '" + logDescriptor.ID + "' already exists! Preserving existing one !");
        }
        return logDescriptorTable;
    }

    private LogDescriptor handleLogElement(Element logElement) throws ConfigurationParsingError {
        LogDescriptor logDescriptor = new LogDescriptor();
        Properties logProperties = this.handlePropertysetElement(logElement);
        Attribute nameAttribute = logElement.getAttribute("name");
        if (nameAttribute == null || nameAttribute.getValue().length() == 0) {
            throw new ConfigurationParsingError("The name attribute is mandatory for log elements.");
        }
        logDescriptor.ID = nameAttribute.getValue();
        this.mLogMgr.info("Found a new log file: '" + logDescriptor.ID + "'");
        logDescriptor.DebugLevel = Convert.toString(logProperties.getProperty("debug-level"), "debug");
        logDescriptor.File = Convert.toString(logProperties.getProperty("file"), logDescriptor.ID);
        logDescriptor.Format = Convert.toString(logProperties.getProperty("format"), "raw");
        logDescriptor.FormatClass = logProperties.getProperty("class");
        if (logDescriptor.Format.equals("custom") && logDescriptor.FormatClass == null) {
            throw new ConfigurationParsingError("The class property is mandatory for custom log classes.");
        }
        logDescriptor.CacheSize = Convert.toInt(logProperties.getProperty("cache-size"), 1);
        logDescriptor.MaxEntries = Convert.toInt(logProperties.getProperty("max-entries"), -1);
        logDescriptor.ToStdout = Convert.toBoolean(logProperties.getProperty("stdout-dup"), false);
        return logDescriptor;
    }

    private TasksetDescriptor handleTaskset(Element configurationElement) throws ConfigurationParsingError {
        Element tasksetElement = this.getFirstElement(configurationElement, "taskset", true);
        tasksetElement = this.loadXMLExternal(tasksetElement);
        assert (tasksetElement != null);
        this.mLogMgr.info("Found a new taskset: '" + tasksetElement.getAttributeValue("name") + "'");
        TasksetDescriptor descriptor = new TasksetDescriptor();
        descriptor.TaskGeneratorDescriptor = this.handleTaskgenElement(tasksetElement);
        return descriptor;
    }

    private TaskgenDescriptor handleTaskgenElement(Element tasksetElement) throws ConfigurationParsingError {
        Element generatorElement = this.getFirstElement(tasksetElement, "generator", true);
        TaskgenDescriptor descriptor = this.handleGeneratorElement(generatorElement);
        return descriptor;
    }

    private TaskgenDescriptor handleGeneratorElement(Element generatorElement) throws ConfigurationParsingError {
        TaskgenDescriptor descriptor = new TaskgenDescriptor();
        descriptor.Props = this.handlePropertyset(generatorElement, true);
        if (descriptor.Props.getProperty("distribution") == null) {
            throw new ConfigurationParsingError("No task distribution was specified for the current task generator !");
        }
        List distributionElements = generatorElement.getChildren("distribution");
        if (distributionElements != null && distributionElements.size() > 0) {
            Hashtable<String, TaskDistributionDescriptor> distributionTable = this.handleDistributionElements(distributionElements);
            String distributionName = descriptor.Props.getProperty("distribution");
            descriptor.Distribution = distributionTable.get(distributionName);
            if (descriptor.Distribution == null) {
                throw new ConfigurationParsingError("The task distribution '" + distributionName + "' does not exist !");
            }
        } else {
            throw new ConfigurationParsingError("No task distribution could be found for current task generator!");
        }
        return descriptor;
    }

    private Hashtable<String, TaskDistributionDescriptor> handleDistributionElements(List distributionElements) throws ConfigurationParsingError {
        Hashtable<String, TaskDistributionDescriptor> distributionTable = new Hashtable<String, TaskDistributionDescriptor>();
        for (Element distributionElement : distributionElements) {
            TaskDistributionDescriptor descriptor = this.handleDistributionElement(distributionElement);
            assert (descriptor != null);
            distributionTable.put(descriptor.Name, descriptor);
        }
        return distributionTable;
    }

    private TaskDistributionDescriptor handleDistributionElement(Element distributionElement) throws ConfigurationParsingError {
        List functionElements;
        Element densityFunctionsElement;
        List probabilitiesElements;
        Element tasksElement;
        TaskDistributionDescriptor descriptor = new TaskDistributionDescriptor();
        Attribute nameAttribute = distributionElement.getAttribute("name");
        Attribute typeAttribute = distributionElement.getAttribute("type");
        if (nameAttribute == null) {
            throw new ConfigurationParsingError("The 'name' attribute is mandatory for <distribution> elements");
        }
        if (typeAttribute == null) {
            throw new ConfigurationParsingError("The 'type' attribute is mandatory for <distribution> elements");
        }
        descriptor.Name = nameAttribute.getValue();
        descriptor.Type = typeAttribute.getValue();
        descriptor.Props = this.handlePropertyset(distributionElement, true);
        if (typeAttribute.getValue().equals("discrete") && (tasksElement = distributionElement.getChild("tasks")) != null) {
            List taskElements = tasksElement.getChildren("task");
            descriptor.TaskDescriptorList = this.handleTaskElements(taskElements);
        }
        if ((probabilitiesElements = distributionElement.getChildren("probabilities")) != null && probabilitiesElements.size() > 0) {
            if (probabilitiesElements.size() > 1) {
                this.mLogMgr.warning("More than one <probabilities> element was found ! System will only consider the first!");
            }
            Element probabilitiesElement = (Element)probabilitiesElements.get(0);
            assert (probabilitiesElement != null);
            List probabilityElements = probabilitiesElement.getChildren("probability");
            if (probabilityElements != null && probabilityElements.size() > 0) {
                descriptor.ProbDescriptorList = this.handleProbabilityElements(probabilityElements);
            }
        }
        if ((densityFunctionsElement = distributionElement.getChild("density-functions")) != null && (functionElements = densityFunctionsElement.getChildren("function")) != null && functionElements.size() > 0) {
            descriptor.DensityFunctions = this.handleDensityFunctionElements(functionElements);
        }
        return descriptor;
    }

    private ArrayList<TaskDescriptor> handleTaskElements(List taskElements) throws ConfigurationParsingError {
        ArrayList<TaskDescriptor> descriptorList = new ArrayList<TaskDescriptor>();
        for (Element taskElement : taskElements) {
            TaskDescriptor descriptor = this.handleTaskElement(taskElement);
            assert (descriptor != null);
            descriptorList.add(descriptor);
        }
        return descriptorList;
    }

    private TaskDescriptor handleTaskElement(Element taskElement) throws ConfigurationParsingError {
        TaskDescriptor descriptor = new TaskDescriptor();
        try {
            if (taskElement == null) {
                throw new ConfigurationParsingError("A task node could not be found.");
            }
            if (taskElement.getAttribute("reward") != null) {
                descriptor.RewardPerKm = taskElement.getAttribute("reward").getDoubleValue();
            }
            if (taskElement.getAttribute("weight") != null) {
                descriptor.Weight = taskElement.getAttribute("weight").getDoubleValue();
            }
            if (taskElement.getAttribute("pickup") != null) {
                descriptor.PickupCity = taskElement.getAttributeValue("pickup");
            }
            if (taskElement.getAttribute("delivery") != null) {
                descriptor.DeliveryCity = taskElement.getAttributeValue("delivery");
            }
        }
        catch (Exception e) {
            this.mLogMgr.warning("One of the tasks could not be loaded !");
            this.mLogMgr.debug("Reward: " + taskElement.getAttribute("reward") + "\n" + "Weight: " + taskElement.getAttribute("weight") + "\n" + "Pickup: " + taskElement.getAttribute("pickup") + "\n" + "Delivery: " + taskElement.getAttribute("delivery") + "\n");
            throw new ConfigurationParsingError("Last task could not be loaded! One of the values may be wrong !");
        }
        this.mLogMgr.info("Found a new task from '" + descriptor.PickupCity + "' to '" + descriptor.DeliveryCity + "'");
        return descriptor;
    }

    private ArrayList<ProbabilityDescriptor> handleProbabilityElements(List probabilityElements) throws ConfigurationParsingError {
        ArrayList<ProbabilityDescriptor> descriptorList = new ArrayList<ProbabilityDescriptor>();
        for (Element probabilityElement : probabilityElements) {
            ProbabilityDescriptor descriptor = this.handleProbabilityElement(probabilityElement);
            assert (descriptor != null);
            descriptorList.add(descriptor);
        }
        return descriptorList;
    }

    private ProbabilityDescriptor handleProbabilityElement(Element probabilityElement) throws ConfigurationParsingError {
        ProbabilityDescriptor descriptor = new ProbabilityDescriptor();
        Attribute fromAttribute = probabilityElement.getAttribute("from");
        Attribute toAttribute = probabilityElement.getAttribute("to");
        Attribute taskAttribute = probabilityElement.getAttribute("task");
        Attribute rewardAttribute = probabilityElement.getAttribute("reward");
        if (fromAttribute == null) {
            throw new ConfigurationParsingError("The <probability> node must define the 'from' attribute !");
        }
        if (toAttribute == null) {
            throw new ConfigurationParsingError("The <probability> node must define the 'to' attribute !");
        }
        descriptor.From = fromAttribute.getValue();
        descriptor.To = toAttribute.getValue();
        try {
            descriptor.Task = taskAttribute != null ? Double.valueOf(taskAttribute.getDoubleValue()) : null;
            descriptor.Reward = rewardAttribute != null ? Double.valueOf(rewardAttribute.getDoubleValue()) : null;
        }
        catch (DataConversionException e) {
            throw new ConfigurationParsingError("Either the task probability or reward for probability pair going from '" + fromAttribute.getValue() + "' to '" + toAttribute.getValue() + "' has a bad format !");
        }
        return descriptor;
    }

    private HashMap<String, Properties> handleDensityFunctionElements(List functionElements) throws ConfigurationParsingError {
        HashMap<String, Properties> functionTable = new HashMap<String, Properties>();
        for (Element functionElement : functionElements) {
            Properties functionProperties = this.handleDensityFunctionElement(functionElement);
            if (functionProperties == null) continue;
            functionTable.put(functionProperties.getProperty("name"), functionProperties);
        }
        return functionTable;
    }

    private Properties handleDensityFunctionElement(Element functionElement) throws ConfigurationParsingError {
        Properties properties = this.handlePropertysetElement(functionElement);
        if (properties == null || properties.size() == 0) {
            throw new ConfigurationParsingError("Density function node does not define any property !");
        }
        Attribute nameAttribute = functionElement.getAttribute("name");
        if (nameAttribute == null) {
            throw new ConfigurationParsingError("Density function node must have a name attribute!");
        }
        Attribute typeAttribute = functionElement.getAttribute("type");
        if (typeAttribute == null) {
            String typeAttr = properties.getProperty("type");
            if (typeAttr == null) {
                throw new ConfigurationParsingError("Density function '" + nameAttribute.getValue() + "' must have " + "a type attribute!");
            }
        } else {
            properties.setProperty("type", typeAttribute.getValue());
        }
        properties.setProperty("name", nameAttribute.getValue());
        return properties;
    }

    private TopologyDescriptor handleToposet(Element configurationElement) throws ConfigurationParsingError {
        Element toposetElement = this.getFirstElement(configurationElement, "toposet", true);
        toposetElement = this.loadXMLExternal(toposetElement);
        assert (toposetElement != null);
        this.mLogMgr.info("Found a new toposet: '" + toposetElement.getAttributeValue("name") + "'");
        TopologyDescriptor descriptor = new TopologyDescriptor();
        descriptor.Props = this.handlePropertyset(toposetElement, false);
        descriptor.Cities = this.handleCityset(toposetElement);
        descriptor.Routes = this.handleRouteset(toposetElement);
        return descriptor;
    }

    private ArrayList<CityDescriptor> handleCityset(Element toposetElement) throws ConfigurationParsingError {
        Element citiesElement = this.getFirstElement(toposetElement, "cities", true);
        ArrayList<CityDescriptor> descriptorList = new ArrayList<CityDescriptor>();
        List cityElements = citiesElement.getChildren("city");
        for (Element cityElement : cityElements) {
            CityDescriptor descriptor = this.handleCityElement(cityElement);
            assert (descriptor != null);
            this.mLogMgr.info("New city found: '" + descriptor.Name + "'");
            descriptorList.add(descriptor);
        }
        return descriptorList;
    }

    private ArrayList<RouteDescriptor> handleRouteset(Element toposetElement) throws ConfigurationParsingError {
        Element routesElement = this.getFirstElement(toposetElement, "routes", true);
        ArrayList<RouteDescriptor> descriptorList = new ArrayList<RouteDescriptor>();
        List routeElements = routesElement.getChildren("route");
        for (Element routeElement : routeElements) {
            RouteDescriptor descriptor = this.handleRouteElement(routeElement);
            if (descriptor == null) continue;
            this.mLogMgr.info("Found new route from '" + descriptor.Source + "' to '" + descriptor.Destination + "'");
            descriptorList.add(descriptor);
        }
        return descriptorList;
    }

    private CityDescriptor handleCityElement(Element citiesElement) throws ConfigurationParsingError {
        CityDescriptor descriptor = new CityDescriptor();
        Attribute nameAttribute = citiesElement.getAttribute("name");
        Attribute xAttribute = citiesElement.getAttribute("x");
        Attribute yAttribute = citiesElement.getAttribute("y");
        if (nameAttribute == null || nameAttribute.getValue().length() == 0 || xAttribute == null || xAttribute.getValue().length() == 0 || yAttribute == null || yAttribute.getValue().length() == 0) {
            throw new ConfigurationParsingError("All attributes of a city element are mandatory.");
        }
        descriptor.Name = nameAttribute.getValue();
        try {
            descriptor.X = xAttribute.getIntValue();
        }
        catch (Exception e) {
            throw new ConfigurationParsingError("The X position of city " + descriptor.Name + " has a bad format !");
        }
        try {
            descriptor.Y = yAttribute.getIntValue();
        }
        catch (Exception e) {
            throw new ConfigurationParsingError("The Y position of city " + descriptor.Name + " has a bad format !");
        }
        return descriptor;
    }

    private RouteDescriptor handleRouteElement(Element routeElement) throws ConfigurationParsingError {
        RouteDescriptor descriptor = new RouteDescriptor();
        Attribute distanceAttribute = routeElement.getAttribute("distance");
        Attribute fromAttribute = routeElement.getAttribute("from");
        Attribute toAttribute = routeElement.getAttribute("to");
        if (distanceAttribute == null || distanceAttribute.getValue().length() == 0 || fromAttribute == null || fromAttribute.getValue().length() == 0 || toAttribute == null || toAttribute.getValue().length() == 0) {
            throw new ConfigurationParsingError("All attributes of a route are mandatory.");
        }
        descriptor.Source = fromAttribute.getValue();
        descriptor.Destination = toAttribute.getValue();
        try {
            descriptor.Distance = distanceAttribute.getDoubleValue();
        }
        catch (Exception e) {
            throw new ConfigurationParsingError("The distance attribute for route going from '" + descriptor.Source + "' to '" + descriptor.Destination + "' has a bad format !");
        }
        return descriptor;
    }

    private AgentsetDescriptor handleAgentset(Element configurationElement) throws ConfigurationParsingError {
        AgentsetDescriptor descriptor = new AgentsetDescriptor();
        Element agentsetElement = this.getFirstElement(configurationElement, "agentset", true);
        agentsetElement = this.loadXMLExternal(agentsetElement);
        String agentsetName = agentsetElement.getAttributeValue("name");
        this.mLogMgr.info("Found a new agentset: '" + agentsetName + "'");
        descriptor.Props = this.handlePropertyset(agentsetElement, false);
        List rootAgentElements = agentsetElement.getChildren("agent");
        if (rootAgentElements == null || rootAgentElements.size() == 0) {
            throw new ConfigurationParsingError("No root agent was found for agent set '" + agentsetName + "'.");
        }
        if (rootAgentElements.size() > 1) {
            this.mLogMgr.warning("More than one root agent was found for current agent set. System will only consider the first one.");
        }
        Element agentElement = (Element)rootAgentElements.get(0);
        descriptor.RootAgent = this.handleAgentElement(agentElement);
        return descriptor;
    }

    private ArrayList<AgentDescriptor> handleAgentElements(List agentElements) throws ConfigurationParsingError {
        ArrayList<AgentDescriptor> descriptorList = new ArrayList<AgentDescriptor>();
        for (Element agentElement : agentElements) {
            AgentDescriptor descriptor = this.handleAgentElement(agentElement);
            assert (descriptor != null);
            descriptorList.add(descriptor);
        }
        return descriptorList;
    }

    private AgentDescriptor handleAgentElement(Element agentElement) throws ConfigurationParsingError {
        Attribute nameAttribute = agentElement.getAttribute("name");
        if (nameAttribute == null) {
            throw new ConfigurationParsingError("The name attribute of the agent element is mandatory !");
        }
        String name = nameAttribute.getValue();
        this.mLogMgr.info("Found a new agent named '" + name + "' !");
        Element definitionElement = this.getFirstElement(agentElement, "definition", true);
        AgentDescriptor descriptor = this.handleAgentDefinitionElement(definitionElement, name);
        descriptor.Name = name;
        Element childrenElement = this.getFirstElement(agentElement, "children", false);
        if (childrenElement == null) {
            this.mLogMgr.info("Agent '" + descriptor.Name + "' has no children !");
        } else {
            List agentElements = childrenElement.getChildren("agent");
            if (agentElements != null && agentElements.size() > 0) {
                descriptor.Children = this.handleAgentElements(agentElements);
            } else {
                this.mLogMgr.info("Agent '" + descriptor.Name + "' has no children !");
            }
        }
        return descriptor;
    }

    private AgentDescriptor handleAgentDefinitionElement(Element definitionElement, String name) throws ConfigurationParsingError {
        AgentDescriptor descriptor = new AgentDescriptor();
        Properties properties = this.handlePropertyset(definitionElement, true);
        descriptor.Speed = Convert.toDouble(properties.getProperty("speed"), descriptor.Speed);
        descriptor.Capacity = Convert.toDouble(properties.getProperty("capacity"), descriptor.Capacity);
        descriptor.CostPerKM = Convert.toDouble(properties.getProperty("costperkm"), descriptor.CostPerKM);
        descriptor.AgentColor = Convert.toColor(properties.getProperty("color"), descriptor.AgentColor);
        descriptor.Home = Convert.toString(properties.getProperty("home"), descriptor.Home);
        descriptor.Active = Convert.toBoolean(properties.getProperty("active"), descriptor.Active);
        this.mLogMgr.debug("Agent '" + name + "' properties:");
        this.mLogMgr.debug("   --> speed: " + descriptor.Speed);
        this.mLogMgr.debug("   --> capacity: " + descriptor.Capacity);
        this.mLogMgr.debug("   --> costperkm: " + descriptor.CostPerKM);
        this.mLogMgr.debug("   --> color: " + descriptor.AgentColor);
        this.mLogMgr.debug("   --> home: " + descriptor.Home);
        descriptor.Type = properties.getProperty("type");
        if (descriptor.Type == null) {
            throw new ConfigurationParsingError("A type property must be defined for agent '" + name + "'!");
        }
        descriptor.ClassName = properties.getProperty("class");
        if (descriptor.ClassName == null && descriptor.Type.equals("custom")) {
            throw new ConfigurationParsingError("A class property must be defined for the custom agent '" + name + "'!");
        }
        descriptor.Behavior = properties.getProperty("behavior");
        if (descriptor.Behavior == null) {
            throw new ConfigurationParsingError("No behavior was defined for agent '" + name + "' !");
        }
        Element behaviorsetElement = definitionElement.getChild("behaviorset");
        if (behaviorsetElement == null) {
            throw new ConfigurationParsingError("No behaviorset was defined for agent '" + name + "'!");
        }
        List behaviorElements = behaviorsetElement.getChildren("behavior");
        if (behaviorElements != null && behaviorElements.size() > 0) {
            descriptor.Behaviors = this.handleBehaviorElements(behaviorElements);
        }
        return descriptor;
    }

    private ArrayList<BehaviorDescriptor> handleBehaviorElements(List behaviorElements) throws ConfigurationParsingError {
        ArrayList<BehaviorDescriptor> descriptorList = new ArrayList<BehaviorDescriptor>();
        for (Element behaviorElement : behaviorElements) {
            BehaviorDescriptor descriptor = this.handleBehaviorElement(behaviorElement);
            assert (descriptor != null);
            descriptorList.add(descriptor);
        }
        return descriptorList;
    }

    private BehaviorDescriptor handleBehaviorElement(Element behaviorElement) throws ConfigurationParsingError {
        BehaviorDescriptor descriptor = new BehaviorDescriptor();
        Attribute signalAttribute = behaviorElement.getAttribute("signal");
        if (signalAttribute == null) {
            throw new ConfigurationParsingError("The signal attribute of the behavior is mandatory.");
        }
        Attribute handlerAttribute = behaviorElement.getAttribute("handler");
        if (handlerAttribute == null) {
            throw new ConfigurationParsingError("The handler attribute of the behavior is mandatory.");
        }
        Attribute sharedAttribute = behaviorElement.getAttribute("shared");
        descriptor.Signal = signalAttribute.getValue();
        descriptor.Handler = handlerAttribute.getValue();
        descriptor.Shared = sharedAttribute == null ? "False" : sharedAttribute.getValue();
        return descriptor;
    }

    private Properties handlePropertyset(Element parentElement, boolean isMandatory) throws ConfigurationParsingError {
        Element propsetElement = this.getFirstElement(parentElement, "propset", isMandatory);
        return this.handlePropertysetElement(propsetElement);
    }

    public Properties handlePropertysetElement(Element propsetElement) throws ConfigurationParsingError {
        Properties properties = new Properties();
        List propertyElements = propsetElement.getChildren("property");
        for (Element propertyElement : propertyElements) {
            Attribute nameAttribute = propertyElement.getAttribute("name");
            if (nameAttribute == null) {
                throw new ConfigurationParsingError("Missing 'name' attribute in property.");
            }
            Attribute valueAttribute = propertyElement.getAttribute("value");
            if (valueAttribute == null) {
                throw new ConfigurationParsingError("Missing 'value' attribute in property.");
            }
            if (properties.containsKey(nameAttribute.getValue())) {
                this.mLogMgr.warning("Property '" + nameAttribute.getValue() + "' already exists. Overwriting.");
            }
            properties.setProperty(nameAttribute.getValue(), valueAttribute.getValue());
        }
        return properties;
    }

    private Element loadXMLRootFromDisk(String filename) throws Exception {
        FileInputStream stream = new FileInputStream(filename);
        SAXBuilder documentBuilder = new SAXBuilder();
        Document document = documentBuilder.build(new InputSource(stream));
        return document.getRootElement();
    }

    private Element loadXMLExternal(Element parentElement) throws ConfigurationParsingError {
        Element rootElement = null;
        Attribute nameAttribute = parentElement.getAttribute("name");
        Attribute fileAttribute = parentElement.getAttribute("file");
        if (fileAttribute == null) {
            return parentElement;
        }
        if (nameAttribute == null || nameAttribute.getValue().length() == 0) {
            throw new ConfigurationParsingError("The name attribute of the <" + parentElement.getName() + "> is mandatory !");
        }
        File xmlFile = new File(this.mBaseDirectory, fileAttribute.getValue());
        if (!xmlFile.exists()) {
            this.mLogMgr.error("The external filepath '" + xmlFile + "' was not found !");
            throw new ConfigurationParsingError("The external configurationfile '" + fileAttribute.getValue() + "' does not exist!");
        }
        try {
            rootElement = this.loadXMLRootFromDisk(xmlFile.getAbsolutePath());
        }
        catch (Exception e) {
            throw new ConfigurationParsingError("The external " + parentElement.getName() + " element could not be loaded. " + "XML data in this file is invalid. ( JDOM error: " + e + ")");
        }
        if (!rootElement.getName().equals(parentElement.getName())) {
            throw new ConfigurationParsingError("No root element '" + parentElement.getName() + "' was found in the external " + "file.");
        }
        Attribute externalNameAttribute = rootElement.getAttribute("name");
        if (externalNameAttribute == null) {
            throw new ConfigurationParsingError("The external '" + parentElement.getName() + "' " + "must define a " + "'name' attribute.");
        }
        if (!externalNameAttribute.getValue().equals(nameAttribute.getValue())) {
            throw new ConfigurationParsingError("The name attribute of the external element '" + parentElement.getName() + "' does " + "not match the name of the local element! ");
        }
        if (rootElement.getAttributes().size() > 1) {
            throw new ConfigurationParsingError("The external element '" + parentElement.getName() + "' *must* not define more than " + "one attribute !");
        }
        return rootElement;
    }

    private Element getFirstElement(Element parentElement, String elementName, boolean isElementMandatory) throws ConfigurationParsingError {
        List elementList = parentElement.getChildren(elementName);
        if (elementList == null || elementList.isEmpty()) {
            if (isElementMandatory) {
                throw new ConfigurationParsingError("No " + elementName + " element was found !");
            }
            return null;
        }
        if (elementList.size() > 1) {
            this.mLogMgr.warning("More than one <" + elementName + "> element " + "was found. System will only consider the first !");
        }
        Element singleElement = (Element)elementList.get(0);
        return singleElement;
    }
}

