/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.util;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import uchicago.src.reflector.IntrospectFrame;
import uchicago.src.reflector.IntrospectPanel;
import uchicago.src.sim.engine.AbstractGUIController;
import uchicago.src.sim.engine.CustomProbeable;
import uchicago.src.sim.gui.Named;
import uchicago.src.sim.util.BeanBowlUtils;
import uchicago.src.sim.util.IntroFrameAdapter;
import uchicago.src.sim.util.ProbeListener;
import uchicago.src.sim.util.SimUtilities;

public class ProbeUtilities {
    private static HashMap probePanelMap = new HashMap();
    private static IntrospectPanel modelPanel;
    private static ArrayList probedList;
    private static ArrayList listeners;
    private static int newWindowXOffset;
    private static int newWindowYOffset;

    public static void probe(final Object object) {
        IntrospectFrame introspectFrame;
        Object object2;
        if (probePanelMap.containsKey(object)) {
            IntrospectPanel introspectPanel = (IntrospectPanel)probePanelMap.get(object);
            ProbeUtilities.updateProbePanel(object);
            introspectPanel.grabFocus();
            return;
        }
        String string = "";
        if (object instanceof Named) {
            object2 = (Named)object;
            string = object2.getName();
        }
        if (object instanceof CustomProbeable) {
            object2 = (CustomProbeable)object;
            introspectFrame = new IntrospectFrame(object, string, object2.getProbedProperties(), AbstractGUIController.PROBE_ALPHA_ORDER);
        } else {
            introspectFrame = new IntrospectFrame(object, string, AbstractGUIController.PROBE_ALPHA_ORDER);
        }
        introspectFrame.addWindowListener(new IntroFrameAdapter(object, listeners));
        object2 = new Runnable(){

            public void run() {
                try {
                    ProbeUtilities.addProbe(object, introspectFrame);
                }
                catch (Exception exception) {
                    SimUtilities.showError("Probing error", exception);
                    exception.printStackTrace();
                    System.exit(0);
                }
            }
        };
        SwingUtilities.invokeLater((Runnable)object2);
    }

    public static List getProbedObjects() {
        return Collections.unmodifiableList(probedList);
    }

    public static void addModelProbePanel(IntrospectPanel introspectPanel) {
        modelPanel = introspectPanel;
    }

    public static void removeModelProbePanel() {
        modelPanel = null;
    }

    public static void updateModelProbePanel() {
        if (modelPanel == null) {
            throw new RuntimeException("ModelPanel is null");
        }
        modelPanel.reset();
    }

    public static void addProbePanel(Object object, IntrospectPanel introspectPanel) {
        probedList.add(object);
        probePanelMap.put(object, introspectPanel);
    }

    public static void removeProbePanel(Object object) {
        probedList.remove(object);
        probePanelMap.remove(object);
        BeanBowlUtils.remove(object);
    }

    public static void clearProbePanels() {
        modelPanel = null;
        probedList.clear();
        probePanelMap.clear();
        listeners.clear();
    }

    public static void updateProbePanel(Object object) {
        IntrospectPanel introspectPanel = (IntrospectPanel)probePanelMap.get(object);
        if (introspectPanel != null) {
            introspectPanel.reset();
        }
    }

    public static void updateProbePanels() {
        Iterator iterator = probePanelMap.values().iterator();
        while (iterator.hasNext()) {
            IntrospectPanel introspectPanel = (IntrospectPanel)iterator.next();
            introspectPanel.reset();
        }
    }

    public static void addProbeListener(ProbeListener probeListener) {
        listeners.add(probeListener);
    }

    private static void addProbe(Object object, IntrospectFrame introspectFrame) throws InvocationTargetException, IllegalAccessException, IntrospectionException {
        ProbeUtilities.addProbePanel(object, introspectFrame.display());
        introspectFrame.setLocation(newWindowXOffset, newWindowYOffset);
        ProbeUtilities.updateOffsets();
    }

    private static void updateOffsets() {
        newWindowXOffset += 10;
        if ((newWindowYOffset += 5) > 400) {
            newWindowYOffset = 0;
        }
        if (newWindowXOffset > 600) {
            newWindowXOffset = 0;
        }
    }

    public static void closeAllProbeWindows() {
        ArrayList arrayList = new ArrayList(probePanelMap.values());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            IntrospectFrame introspectFrame = (IntrospectFrame)((IntrospectPanel)iterator.next()).getTopLevelAncestor();
            introspectFrame.setVisible(false);
            introspectFrame.dispose();
        }
    }

    public static void closeProbeWindows(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            IntrospectFrame introspectFrame = ProbeUtilities.getObjectsFrame(iterator.next());
            if (introspectFrame == null) continue;
            introspectFrame.setVisible(false);
            introspectFrame.dispose();
        }
    }

    public static IntrospectFrame getObjectsFrame(Object object) {
        if (probePanelMap.containsKey(object)) {
            return (IntrospectFrame)((IntrospectPanel)probePanelMap.get(object)).getTopLevelAncestor();
        }
        return null;
    }

    static {
        probedList = new ArrayList();
        listeners = new ArrayList();
        newWindowXOffset = 0;
        newWindowYOffset = 0;
    }
}

