/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import uchicago.src.sim.parameter.DefaultParameterSetter;
import uchicago.src.sim.parameter.ParameterSetter;
import uchicago.src.sim.parameter.SingleSetParameterSetter;

public class ParameterSetterFactory {
    public static ParameterSetter createParameterSetter(String string) throws IOException {
        String string2;
        ParameterSetter parameterSetter = null;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = bufferedReader.readLine()) != null && string2.trim().length() == 0) {
        }
        bufferedReader.close();
        if (string2 == null) {
            parameterSetter = ParameterSetterFactory.createDefaultParameterSetter();
            parameterSetter.init(string);
        } else if ((string2 = string2.trim()).startsWith("#")) {
            String string3 = string2.substring(1).trim();
            parameterSetter = ParameterSetterFactory.createParameterSetterFromClassName(string3);
            parameterSetter.init(string);
        } else {
            parameterSetter = ParameterSetterFactory.createDefaultParameterSetter();
            parameterSetter.init(string);
        }
        return parameterSetter;
    }

    private static ParameterSetter createParameterSetterFromClassName(String string) throws IOException {
        Class<?> clazz = null;
        ParameterSetter parameterSetter = null;
        try {
            clazz = Class.forName(string);
            parameterSetter = (ParameterSetter)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IOException("Unable to create ParameterSetter from class " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Unable to create ParameterSetter from class " + string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Unable to create ParameterSetter from class " + string + ". Class not found.");
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Unable to create ParameterSetter from class " + string + ". " + string + " does implement ParameterSetter.");
        }
        return parameterSetter;
    }

    public static ParameterSetter createSingleSetParameterSetter(int n) {
        return new SingleSetParameterSetter(n);
    }

    public static ParameterSetter createDefaultParameterSetter() {
        return new DefaultParameterSetter();
    }
}

