/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Polygon;
import java.util.ArrayList;
import uchicago.src.sim.gui.Display2D;
import uchicago.src.sim.gui.DisplayConstants;
import uchicago.src.sim.gui.DisplayInfo;
import uchicago.src.sim.gui.Moveable;
import uchicago.src.sim.gui.Probeable;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.gui.ViewEvent;
import uchicago.src.sim.space.Discrete2DSpace;

public abstract class HexaDisplay2D
extends Display2D
implements Probeable {
    protected boolean view = true;
    protected boolean isFramed = true;
    protected Color frameColor = Color.yellow;
    protected static int xTrans;
    protected static int xTrans1q;
    protected static int yTrans;
    protected static int yTransHalf;
    protected static Polygon polyClip;
    protected Polygon polyDraw;

    public HexaDisplay2D(Discrete2DSpace discrete2DSpace) {
        super(discrete2DSpace);
        this.setHexagons();
    }

    protected void setHexagons() {
        xTrans1q = SimGraphics.getInstance() != null ? SimGraphics.getInstance().getCellWidthScale() / 4 : DisplayConstants.CELL_WIDTH / 4;
        if (xTrans1q < 1) {
            xTrans1q = 1;
        }
        xTrans = xTrans1q * 4;
        int n = SimGraphics.getInstance() != null ? SimGraphics.getInstance().getCellHeightScale() / 4 : DisplayConstants.CELL_HEIGHT / 4;
        if (n < 1) {
            n = 1;
        }
        yTransHalf = n * 2;
        yTrans = yTransHalf * 2;
        int[] nArray = new int[]{xTrans1q, 1, 1, xTrans1q, xTrans - xTrans1q, xTrans, xTrans, xTrans - xTrans1q};
        int[] nArray2 = new int[]{1, yTransHalf, yTransHalf + 1, yTrans, yTrans, yTransHalf, yTransHalf + 1, 1};
        polyClip = new Polygon(nArray, nArray2, 8);
        int[] nArray3 = new int[]{xTrans1q, 0, 0, xTrans1q, xTrans - xTrans1q, xTrans - 1, xTrans - 1, xTrans - xTrans1q};
        int[] nArray4 = new int[]{0, yTransHalf - 1, yTransHalf, yTrans - 1, yTrans - 1, yTransHalf - 1, yTransHalf, 0};
        this.polyDraw = new Polygon(nArray3, nArray4, 8);
    }

    public ArrayList getDisplayableInfo() {
        ArrayList<DisplayInfo> arrayList = new ArrayList<DisplayInfo>();
        arrayList.add(new DisplayInfo("", -1, this));
        return arrayList;
    }

    public void viewEventPerformed(ViewEvent viewEvent) {
        this.view = viewEvent.showView();
    }

    protected Dimension selectPolygon(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        Polygon polygon = null;
        if (n3 >= 0 && n4 >= 0) {
            polygon = new Polygon(this.polyDraw.xpoints, this.polyDraw.ypoints, this.polyDraw.npoints);
            int n8 = n3 % 2 != 0 ? n4 * yTrans : n4 * yTrans + yTransHalf;
            n7 = n3 * xTrans - n3 * xTrans1q;
            polygon.translate(n7, n8);
        }
        Polygon polygon2 = null;
        if (n5 < this.grid.getSizeX() && n6 < this.grid.getSizeY()) {
            polygon2 = new Polygon(this.polyDraw.xpoints, this.polyDraw.ypoints, this.polyDraw.npoints);
            n7 = n5 % 2 != 0 ? n6 * yTrans : n6 * yTrans + yTransHalf;
            int n9 = n5 * xTrans - n5 * xTrans1q;
            polygon2.translate(n9, n7);
        }
        if (polygon != null && polygon.contains(n, n2)) {
            return new Dimension(n3, n4);
        }
        if (polygon2 != null && polygon2.contains(n, n2)) {
            return new Dimension(n5, n6);
        }
        return null;
    }

    protected Dimension getCoordinates(int n, int n2) {
        int n3 = n / xTrans1q;
        int n4 = n3 % 6;
        int n5 = n2 / yTransHalf;
        switch (n4) {
            case 0: {
                int n6 = n3 / 3 - 1;
                int n7 = n2 / yTrans;
                int n8 = n6 + 1;
                int n9 = n5 % 2 == 0 ? n7 + 1 : n7;
                return this.selectPolygon(n, n2, n6, n7, n8, n9);
            }
            case 1: 
            case 2: {
                n5 = n2 - yTransHalf;
                if (n5 < 0) {
                    return null;
                }
                return new Dimension(n3 / 3, n5 / yTrans);
            }
            case 3: {
                int n10 = n3 / 3;
                int n11 = n2 / yTrans;
                int n12 = n10 - 1;
                int n13 = n5 % 2 == 0 ? n11 - 1 : n11;
                return this.selectPolygon(n, n2, n10, n11, n12, n13);
            }
            case 4: 
            case 5: {
                return new Dimension(n3 / 3, n2 / yTrans);
            }
        }
        return null;
    }

    public void setMoveableXY(Moveable moveable, int n, int n2) {
        Dimension dimension = this.getCoordinates(n, n2);
        if (dimension != null) {
            moveable.setX(dimension.width);
            moveable.setY(dimension.height);
        }
    }

    public Color getFrameColor() {
        return this.frameColor;
    }

    public void setFrameColor(Color color) {
        this.frameColor = color;
    }

    public boolean isFramed() {
        return this.isFramed;
    }

    public void setFramed(boolean bl) {
        this.isFramed = bl;
    }

    public Dimension getSize() {
        return new Dimension(this.grid.getSizeX() * (xTrans - xTrans1q) + xTrans1q, this.grid.getSizeY() * yTrans + yTransHalf);
    }
}

