/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcIterator;
import ilog.solver.IlcPIntAbstractVar;
import ilog.solver.IlcPIntToIntExpFunctionInterface;
import ilog.solver.kh;
import ilog.solver.xh;
import ilog.solver.ys;
import ilog.solver.zp;

class rl
extends zp {
    long oy;
    long py;
    long qy;
    long ry;
    int sy;
    int ty;

    rl(kh kh2, IlcPIntToIntExpFunctionInterface ilcPIntToIntExpFunctionInterface) {
        super(kh2, ilcPIntToIntExpFunctionInterface);
        this.getSolver();
        this.initOverflow();
    }

    protected final boolean isOverflowSafe() {
        long l2;
        long l3;
        this.computeInfoLong();
        IlcIterator ilcIterator = this.gq.getDomainPossibleIterator();
        while (ilcIterator.hasNext()) {
            int n2 = ilcIterator.nextValue();
            ys ys2 = this.eib.getValue(n2);
            if (!ys2.gr()) continue;
            return false;
        }
        long l4 = this.gq.getDomainPossibleSize() - this.gq.getDomainRequiredSize();
        return l4 * (l3 = (long)Math.max(Math.abs(this.sy), Math.abs(this.ty))) + (l2 = Math.max(Math.abs(this.oy), Math.abs(this.py))) <= 0x3FFFFFFFL;
    }

    protected final void computeInfoLong() {
        if (this.gq.getDomainPossibleSize() == 0) {
            this.oy = 0L;
            this.py = 0L;
            this.qy = 0L;
            this.ry = 0L;
            this.sy = 0;
            this.ty = 0;
            this.ljb = 0;
            this.mjb = 0;
            return;
        }
        long l2 = 0L;
        long l3 = 0L;
        if (this.gq.isBound()) {
            IlcIterator ilcIterator = this.gq.getDomainRequiredIterator();
            while (ilcIterator.hasNext()) {
                int n2 = ilcIterator.nextValue();
                ys ys2 = this.eib.getValue(n2);
                l2 += (long)ys2.getDomainMin();
                l3 += (long)ys2.getDomainMax();
            }
            this.oy = l2;
            this.py = l3;
            this.qy = l2;
            this.ry = l3;
            this.sy = 0;
            this.ty = 0;
            this.safeSetBoundsLong(l2, l3);
            return;
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = -2147483647;
        long l4 = 0L;
        long l5 = 0L;
        IlcIterator ilcIterator = this.gq.getDomainPossibleIterator();
        while (ilcIterator.hasNext()) {
            int n5 = ilcIterator.nextValue();
            ys ys3 = this.eib.getValue(n5);
            int n6 = ys3.getDomainMin();
            int n7 = ys3.getDomainMax();
            if (this.gq.isDomainRequired(n5)) {
                l2 += (long)n6;
                l3 += (long)n7;
            } else {
                if (n6 < 0) {
                    l4 += (long)n6;
                }
                if (n7 > 0) {
                    l5 += (long)n7;
                }
            }
            if (n6 < n3) {
                n3 = n6;
            }
            if (n7 <= n4) continue;
            n4 = n7;
        }
        this.oy = l2;
        this.py = l3;
        this.qy = l2 + l4;
        this.ry = l3 + l5;
        this.sy = n3;
        this.ty = n4;
    }

    protected void computeRangeLong() {
        IlcPIntAbstractVar ilcPIntAbstractVar = this.gq.getCardinality();
        int n2 = this.gq.getDomainRequiredSize();
        long l2 = ilcPIntAbstractVar.getDomainMin() - n2;
        long l3 = ilcPIntAbstractVar.getDomainMax() - n2;
        long l4 = this.sy < 0 ? (long)this.sy * l3 + this.oy : (long)this.sy * l2 + this.oy;
        long l5 = this.ty < 0 ? (long)this.ty * l2 + this.py : (long)this.ty * l3 + this.py;
        this.safeSetBoundsLong(Math.max(this.qy, l4), Math.min(this.ry, l5));
    }

    protected void computeRange() {
        int n2;
        int n3;
        this.getSolver();
        if (this.gr()) {
            this.computeRangeLong();
            return;
        }
        if (this.gq.getDomainPossibleSize() == 0) {
            this.oy = 0L;
            this.py = 0L;
            this.qy = 0L;
            this.ry = 0L;
            this.sy = 0;
            this.ty = 0;
            this.ljb = 0;
            this.mjb = 0;
            return;
        }
        int n4 = 0;
        int n5 = 0;
        if (this.gq.isBound()) {
            IlcIterator ilcIterator = this.gq.getDomainRequiredIterator();
            while (ilcIterator.hasNext()) {
                int n6 = ilcIterator.nextValue();
                ys ys2 = this.eib.getValue(n6);
                n4 += ys2.getDomainMin();
                n5 += ys2.getDomainMax();
            }
            this.oy = n4;
            this.py = n5;
            this.qy = n4;
            this.ry = n5;
            this.sy = 0;
            this.ty = 0;
            this.ljb = n4;
            this.mjb = n5;
            return;
        }
        int n7 = Integer.MAX_VALUE;
        int n8 = -2147483647;
        int n9 = 0;
        int n10 = 0;
        IlcIterator ilcIterator = this.gq.getDomainPossibleIterator();
        while (ilcIterator.hasNext()) {
            int n11 = ilcIterator.nextValue();
            ys ys3 = this.eib.getValue(n11);
            n3 = ys3.getDomainMin();
            n2 = ys3.getDomainMax();
            if (this.gq.isDomainRequired(n11)) {
                n4 += n3;
                n5 += n2;
            } else {
                if (n3 < 0) {
                    n9 += n3;
                }
                if (n2 > 0) {
                    n10 += n2;
                }
            }
            if (n3 < n7) {
                n7 = n3;
            }
            if (n2 <= n8) continue;
            n8 = n2;
        }
        this.oy = n4;
        this.py = n5;
        this.qy = n4 + n9;
        this.ry = n5 + n10;
        this.sy = n7;
        this.ty = n8;
        IlcPIntAbstractVar ilcPIntAbstractVar = this.gq.getCardinality();
        int n12 = this.gq.getDomainRequiredSize();
        n3 = ilcPIntAbstractVar.getDomainMin() - n12;
        n2 = ilcPIntAbstractVar.getDomainMax() - n12;
        n7 = n7 < 0 ? n7 * n2 + n4 : n7 * n3 + n4;
        n8 = n8 < 0 ? n8 * n3 + n5 : n8 * n2 + n5;
        this.ljb = Math.max((int)this.qy, n7);
        this.mjb = Math.min((int)this.ry, n8);
    }

    protected void setRangeInternal(int n2, int n3) {
        int n4;
        int n5;
        IlcIterator ilcIterator;
        this.getSolver();
        this.fq();
        this.getSolver();
        if (this.gr()) {
            this.setRangeInternalLong(n2, n3);
            return;
        }
        xh xh2 = this.gq.getDomainRequiredSet();
        xh xh3 = this.gq.getDomainPossibleSet();
        int n6 = this.getDomainMin();
        int n7 = this.getDomainMax();
        int n8 = (int)this.oy;
        int n9 = (int)this.py;
        int n10 = this.sy;
        int n11 = this.ty;
        int n12 = n3 - (int)this.qy;
        if (n12 < 0) {
            this.fail();
        }
        if (n3 < n7) {
            int n13;
            ilcIterator = xh3.getIterator();
            while (ilcIterator.hasNext()) {
                n5 = ilcIterator.nextValue();
                ys ys2 = this.eib.getValue(n5);
                n4 = ys2.getDomainMin();
                if (xh2.isInSet(n5)) {
                    ys2.setDomainMax(n4 + n12);
                    continue;
                }
                if (n4 > n12) {
                    this.gq.removeDomainPossible(n5);
                    continue;
                }
                if (-n4 <= n12) continue;
                this.gq.addDomainRequired(n5);
                ys2.setDomainMax(n4 + n12);
                n8 += n4;
            }
            n5 = xh2.getCardinal();
            if (n10 < 0) {
                int n14 = (n3 - n8 + n10 + 1) / n10;
                if (n14 > 0) {
                    this.gq.getCardinality().setDomainMin(n5 + n14);
                }
            } else if (n10 > 0 && (n13 = (n3 - n8) / n10) >= 0) {
                this.gq.getCardinality().setDomainMax(n5 + n13);
            }
        }
        if ((n12 = (int)this.ry - n2) < 0) {
            this.fail();
        }
        if (n2 > n6) {
            int n15;
            ilcIterator = xh3.getIterator();
            while (ilcIterator.hasNext()) {
                n5 = ilcIterator.nextValue();
                ys ys3 = this.eib.getValue(n5);
                n4 = ys3.getDomainMax();
                if (xh2.isInSet(n5)) {
                    ys3.setDomainMin(n4 - n12);
                    continue;
                }
                if (n4 > n12) {
                    this.gq.addDomainRequired(n5);
                    ys3.setDomainMin(n4 - n12);
                    n9 += n4;
                    continue;
                }
                if (-n4 <= n12) continue;
                this.gq.removeDomainPossible(n5);
            }
            n5 = xh2.getCardinal();
            if (n11 < 0) {
                int n16 = (n2 - n9) / n11;
                if (n16 >= 0) {
                    this.gq.getCardinality().setDomainMax(n5 + n16);
                }
            } else if (n11 > 0 && (n15 = (n2 - n9 + n11 - 1) / n11) > 0) {
                this.gq.getCardinality().setDomainMin(n5 + n15);
            }
        }
    }

    protected void setRangeInternalLong(long l2, long l3) {
        int n2;
        int n3;
        IlcIterator ilcIterator;
        xh xh2 = this.gq.getDomainRequiredSet();
        xh xh3 = this.gq.getDomainPossibleSet();
        int n4 = this.getDomainMin();
        int n5 = this.getDomainMax();
        long l4 = this.oy;
        long l5 = this.py;
        int n6 = this.sy;
        int n7 = this.ty;
        long l6 = l3 - this.qy;
        if (l6 < 0L) {
            this.fail();
        }
        if (l3 < (long)n5) {
            long l7;
            ilcIterator = xh3.getIterator();
            while (ilcIterator.hasNext()) {
                n3 = ilcIterator.nextValue();
                ys ys2 = this.eib.getValue(n3);
                n2 = ys2.getDomainMin();
                if (xh2.isInSet(n3)) {
                    ys2.setDomainMaxLong((long)n2 + l6);
                    continue;
                }
                if ((long)n2 > l6) {
                    this.gq.removeDomainPossible(n3);
                    continue;
                }
                if (-((long)n2) <= l6) continue;
                this.gq.addDomainRequired(n3);
                ys2.setDomainMaxLong((long)n2 + l6);
                l4 += (long)n2;
            }
            n3 = xh2.getCardinal();
            if (n6 < 0) {
                long l8 = (l3 - l4 + (long)n6 + 1L) / (long)n6;
                if (l8 > 0L) {
                    this.gq.getCardinality().setDomainMinLong((long)n3 + l8);
                }
            } else if (n6 > 0 && (l7 = (l3 - l4) / (long)n6) > 0L) {
                this.gq.getCardinality().setDomainMaxLong((long)n3 + l7);
            }
        }
        if ((l6 = this.ry - l2) < 0L) {
            this.fail();
        }
        if (l2 > (long)n4) {
            long l9;
            ilcIterator = xh3.getIterator();
            while (ilcIterator.hasNext()) {
                n3 = ilcIterator.nextValue();
                ys ys3 = this.eib.getValue(n3);
                n2 = ys3.getDomainMax();
                if (xh2.isInSet(n3)) {
                    ys3.setDomainMinLong((long)n2 - l6);
                    continue;
                }
                if ((long)n2 > l6) {
                    this.gq.addDomainRequired(n3);
                    ys3.setDomainMinLong((long)n2 - l6);
                    l5 += (long)n2;
                    continue;
                }
                if (-((long)n2) <= l6) continue;
                this.gq.removeDomainPossible(n3);
            }
            n3 = xh2.getCardinal();
            if (n7 < 0) {
                long l10 = (l2 - l5) / (long)n7;
                if (l10 > 0L) {
                    this.gq.getCardinality().setDomainMaxLong((long)n3 + l10);
                }
            } else if (n7 > 0 && (l9 = (l2 - l5 + (long)n7 - 1L) / (long)n7) > 0L) {
                this.gq.getCardinality().setDomainMinLong((long)n3 + l9);
            }
        }
    }

    protected boolean isInDomainInternal(int n2) {
        return true;
    }

    protected void removeValueInternal(int n2) {
    }

    protected void removeIntervalInternal(int n2, int n3) {
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IlcPSum(Set, IntExp F(x)):[");
        stringBuffer.append(this.getDomainMin());
        stringBuffer.append("..");
        stringBuffer.append(this.getDomainMax());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

