/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter.rpl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class JavaClass {
    private Class clazz;
    private String shortName;
    private Map readProps = new HashMap();
    private Map writeProps = new HashMap();
    private Map staticFields = new HashMap();

    public JavaClass(Class clazz) {
        this.clazz = clazz;
        this.shortName = clazz.getName();
        int n = this.shortName.lastIndexOf(".");
        if (n != -1) {
            this.shortName = this.shortName.substring(n + 1, this.shortName.length());
        }
        if ((n = this.shortName.lastIndexOf("$")) != -1) {
            this.shortName = this.shortName.substring(n + 1, this.shortName.length());
        }
        this.fillProperties();
        this.fillFields();
    }

    private void fillProperties() {
        Method[] methodArray = this.clazz.getMethods();
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            Method method = methodArray[i];
            String string2 = method.getName();
            if (string2.startsWith("set") && method.getParameterTypes().length == 1) {
                string = string2.substring(3);
                this.writeProps.put(string.toLowerCase(), method);
                continue;
            }
            if (string2.startsWith("get") && method.getParameterTypes().length == 0) {
                string = string2.substring(3);
                this.readProps.put(string.toLowerCase(), method);
                continue;
            }
            if (!string2.startsWith("is") || method.getParameterTypes().length != 0 || !method.getReturnType().equals(Boolean.TYPE)) continue;
            string = string2.substring(2);
            this.readProps.put(string.toLowerCase(), method);
        }
    }

    private void fillFields() {
        Field[] fieldArray = this.clazz.getFields();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Field field = fieldArray[i];
            if (!Modifier.isStatic(field.getModifiers())) continue;
            this.staticFields.put(field.getName(), field);
        }
    }

    public String getShortName() {
        return this.shortName;
    }

    public boolean hasStaticField(String string) {
        return this.staticFields.containsKey(string);
    }

    public Class getStaticFieldType(String string) {
        Field field = (Field)this.staticFields.get(string);
        if (field == null) {
            throw new NoSuchElementException("Class " + this.clazz.getName() + " does not contain field " + string);
        }
        return field.getType();
    }

    public Object getStaticFieldValue(String string) {
        Field field = (Field)this.staticFields.get(string);
        if (field == null) {
            throw new NoSuchElementException("Class " + this.clazz.getName() + " does not contain field " + string);
        }
        try {
            return field.get(null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return null;
    }
}

