/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import uchicago.src.guiUtils.Wizard;
import uchicago.src.sim.engine.Schedule;
import uchicago.src.sim.engine.SnapshotScheduler;
import uchicago.src.sim.gui.ProducerNamePair;
import uchicago.src.sim.util.SimUtilities;

public class SnapshotDialog
extends Wizard {
    private static final int FIRST_PANEL = 0;
    private static final int SECOND_PANEL = 1;
    private static final int CAPTURE_NONE = 2;
    private static final int CAPTURE_PAUSE = 3;
    private static final int CAPTURE_INTERVAL = 4;
    private int state = 0;
    private int capture = 2;
    private JPanel firstPanel = new JPanel(new BorderLayout());
    private JPanel secondPanel = new JPanel(new BorderLayout());
    private JComboBox displays;
    private JTextField fldName = new JTextField();
    private JButton btnBrowse = new JButton("Browse");
    private JRadioButton btnPauseAndEnd = new JRadioButton("At Pause and End");
    private JRadioButton btnInterval = new JRadioButton("At Every nth Tick");
    private JRadioButton btnNone = new JRadioButton("At Button Click");
    private JTextField fldInterval = new JTextField(3);
    private JLabel buttonLabel = new JLabel("", 2);
    private JFrame frame = null;
    private SnapshotScheduler snapshotScheduler;
    private int interval = 0;
    private String dispName = "";
    private static final String NONE_HELP = "<html><font color=black size=-1><b>Take snapshot whenever the 'Take X Snapshot' button on the Repast Actions panel is clicked where X is replaced by the DisplaySurface name. This will add a new button to the RePast Actions panel</b></font></html>";
    private static final String PAUSE_HELP = "<html><font color=black size=-1><b>Take snapshot whenever the simulation pauses, and ends.</b></font></html>";
    private static final String INTERVAL_HELP = "<html><font color=black size=-1><b>Take snapshot at the interval given in the text field below, e.g. every 100th tick.</b></font></html>";
    private Action captureAt = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton.getActionCommand().equals("none")) {
                SnapshotDialog.this.capture = 2;
                SnapshotDialog.this.fldInterval.setEnabled(false);
                SnapshotDialog.this.buttonLabel.setText(SnapshotDialog.NONE_HELP);
            } else if (jRadioButton.getActionCommand().equals("interval")) {
                SnapshotDialog.this.capture = 4;
                SnapshotDialog.this.fldInterval.setEnabled(true);
                SnapshotDialog.this.buttonLabel.setText(SnapshotDialog.INTERVAL_HELP);
            } else {
                SnapshotDialog.this.capture = 3;
                SnapshotDialog.this.buttonLabel.setText(SnapshotDialog.PAUSE_HELP);
                SnapshotDialog.this.fldInterval.setEnabled(false);
            }
        }
    };
    private Action next = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (SnapshotDialog.this.state == 0) {
                if (SnapshotDialog.this.fldName.getText().trim().length() == 0) {
                    SimUtilities.showMessage("You must provide a snapshot file name");
                    return;
                }
                SnapshotDialog.this.setTopPanel(SnapshotDialog.this.secondPanel);
                SnapshotDialog.this.state = 1;
                SnapshotDialog.this.btnNext.setText("Finished");
                SnapshotDialog.this.btnBack.setEnabled(true);
            } else {
                if (SnapshotDialog.this.capture == 4) {
                    String string = SnapshotDialog.this.fldInterval.getText().trim();
                    if (string.length() == 0) {
                        SimUtilities.showMessage("You must provide a numeric interval");
                        return;
                    }
                    try {
                        SnapshotDialog.this.interval = Integer.parseInt(string);
                        if (SnapshotDialog.this.interval <= 0) {
                            SimUtilities.showMessage("Interval must be a positive whole number");
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        SimUtilities.showMessage("Interval must be a positive whole number");
                        return;
                    }
                }
                SnapshotDialog.this.makeRetVal();
                SnapshotDialog.this.close();
            }
        }
    };
    private Action back = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            SnapshotDialog.this.btnBack.setEnabled(false);
            SnapshotDialog.this.setTopPanel(SnapshotDialog.this.firstPanel);
            SnapshotDialog.this.btnNext.setText("Next");
            SnapshotDialog.this.state = 0;
        }
    };

    public SnapshotDialog(Vector vector) {
        super(false);
        super.setTopPanel(this.firstPanel);
        this.guiInit(vector);
        this.btnBack.setEnabled(false);
        this.addListeners();
    }

    private void addListeners() {
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileDialog fileDialog = new FileDialog((Frame)SnapshotDialog.this.frame, "Snapshot File", 0);
                fileDialog.show();
                String string = fileDialog.getFile();
                if (string == null) {
                    return;
                }
                string = fileDialog.getDirectory() + string;
                fileDialog.dispose();
                SnapshotDialog.this.fldName.setText(string);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotDialog.this.cancel = true;
                SnapshotDialog.this.close();
            }
        });
        this.btnNext.addActionListener(this.next);
        this.btnBack.addActionListener(this.back);
        this.btnNone.setActionCommand("none");
        this.btnInterval.setActionCommand("interval");
        this.btnPauseAndEnd.setActionCommand("pause");
        this.btnNone.addActionListener(this.captureAt);
        this.btnPauseAndEnd.addActionListener(this.captureAt);
        this.btnInterval.addActionListener(this.captureAt);
    }

    public void display(JFrame jFrame, String string) {
        this.frame = jFrame;
        super.setSize(337, 286);
        super.display(jFrame, string, false);
    }

    private void guiInit(Vector vector) {
        super.guiInit();
        this.displays = new JComboBox(vector);
        JLabel jLabel = new JLabel();
        String string = "<html><font color=black size=-1><b>Enter a base file name for the snapshot, and choose a display surface as the source of the snapshot. RePast will append the tick count at which the snapshot was taken as well as the '.png' extension, creating a new file each time a snapshot is taken.</b></font></html>";
        jLabel.setText(string);
        this.firstPanel.add((Component)jLabel, "North");
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel("File Name: "), gridBagConstraints);
        gridBagConstraints.gridy = -1;
        jPanel.add((Component)new JLabel("Display: "), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.fldName, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.displays, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.btnBrowse, gridBagConstraints);
        this.firstPanel.add((Component)jPanel, "South");
        this.firstPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonLabel.setText(NONE_HELP);
        this.secondPanel.add((Component)this.buttonLabel, "North");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.btnNone, gridBagConstraints);
        gridBagConstraints.gridy = -1;
        jPanel2.add((Component)this.btnPauseAndEnd, gridBagConstraints);
        jPanel2.add((Component)this.btnInterval, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)this.fldInterval, gridBagConstraints);
        this.fldInterval.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.btnPauseAndEnd);
        buttonGroup.add(this.btnNone);
        buttonGroup.add(this.btnInterval);
        this.btnNone.setSelected(true);
        this.secondPanel.add((Component)jPanel2, "South");
        this.secondPanel.setBorder(BorderFactory.createTitledBorder("Take Snapshot"));
        Dimension dimension = this.btnBrowse.getPreferredSize();
        Dimension dimension2 = new Dimension(dimension.width, this.fldName.getPreferredSize().height);
        this.btnBrowse.setPreferredSize(dimension2);
    }

    private void makeRetVal() {
        String string = this.fldName.getText();
        ProducerNamePair producerNamePair = (ProducerNamePair)this.displays.getSelectedItem();
        this.snapshotScheduler = new SnapshotScheduler(string, producerNamePair.getProducer(), producerNamePair.getName());
        this.dispName = producerNamePair.getName();
    }

    public SnapshotScheduler scheduleSnapshot(Schedule schedule) {
        if (!this.cancel) {
            if (this.capture == 2) {
                this.snapshotScheduler.onButtonClick("Take " + this.dispName + " Snapshot");
                return this.snapshotScheduler;
            }
            if (this.capture == 3) {
                this.snapshotScheduler.scheduleAtPauseAndEnd(schedule);
            } else {
                this.snapshotScheduler.scheduleAtInterval(schedule, this.interval);
            }
        }
        return null;
    }
}

