/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.tools;

import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TimeoutBarrier<E> {
    private ArrayList<E> mRejectionList = new ArrayList();
    private Timer mInternalTimer = new Timer();
    private boolean mHasTimedOut = false;

    public void reset() {
        this.mRejectionList.clear();
        this.mHasTimedOut = false;
    }

    public void register(E object) {
        this.mRejectionList.add(object);
    }

    public void announce(E object) {
        if (this.mRejectionList.contains(object)) {
            this.mRejectionList.remove(object);
        }
    }

    public boolean blocked() {
        return this.mRejectionList.size() > 0;
    }

    public boolean timeout() {
        return this.mHasTimedOut;
    }

    public boolean isBlocked(E obj) {
        return this.mRejectionList.contains(obj);
    }

    public void start(long timeout) {
        this.mHasTimedOut = false;
        this.mInternalTimer.schedule((TimerTask)new BarrierTask(this), timeout);
    }

    public void setTimedOut() {
        this.mHasTimedOut = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BarrierTask
    extends TimerTask {
        protected TimeoutBarrier<E> barrier;

        public BarrierTask(TimeoutBarrier<E> e) {
            this.barrier = e;
        }

        @Override
        public void run() {
            this.barrier.setTimedOut();
        }
    }
}

