/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.core.view;

import epfl.lia.logist.agent.AgentDisplayable;
import epfl.lia.logist.core.topology.City;
import epfl.lia.logist.task.TaskManager;
import epfl.lia.logist.tools.LogistGlobals;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Iterator;
import uchicago.src.sim.gui.DisplayInfo;
import uchicago.src.sim.gui.Displayable;
import uchicago.src.sim.gui.SimGraphics;
import uchicago.src.sim.gui.ViewEvent;
import uchicago.src.sim.network.Edge;
import uchicago.src.sim.space.VectorSpace;

public class CustomNetworkDisplay
implements Displayable {
    private VectorSpace mAgentSpace = null;
    private VectorSpace mTopoSpace = null;
    private boolean mbAgents = true;
    private boolean mbCities = true;
    private boolean mbNames = true;
    private boolean mbRoutes = true;
    private boolean mbTasks = true;
    private LogistGlobals mGlobals = null;
    private TaskManager mTaskMgr = null;
    private Font mNameFont = null;

    public CustomNetworkDisplay(VectorSpace topo, VectorSpace vehicles, LogistGlobals lg) {
        this.mTopoSpace = topo;
        this.mAgentSpace = vehicles;
        this.mGlobals = lg;
        this.mTaskMgr = TaskManager.getInstance();
    }

    public void drawDisplay(SimGraphics arg0) {
        Graphics2D g = arg0.getGraphics();
        if (this.mGlobals.Antialias) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.mGlobals.TextAntialias) {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.mbRoutes) {
            this.drawRoutes(g);
        }
        if (this.mbCities) {
            this.drawCities(g);
        }
        if (this.mbNames) {
            this.drawNames(g);
        }
        if (this.mbAgents) {
            this.drawAgents(arg0);
        }
    }

    private void drawRoutes(Graphics2D g) {
        g.setPaint(this.mGlobals.RouteColor);
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(this.mGlobals.RouteSize));
        ArrayList cities = this.mTopoSpace.getMembers();
        for (City c : cities) {
            ArrayList outEdges = c.getOutEdges();
            for (Edge e : outEdges) {
                City c1 = (City)e.getFrom();
                City c2 = (City)e.getTo();
                g.drawLine(c1.getX(), c1.getY(), c2.getX(), c2.getY());
            }
        }
        g.setStroke(oldStroke);
    }

    private void drawAgents(SimGraphics g) {
        ArrayList agents = this.mAgentSpace.getMembers();
        Iterator itor = agents.iterator();
        while (itor.hasNext()) {
            ((AgentDisplayable)itor.next()).draw(g);
        }
    }

    private void drawCities(Graphics2D g) {
        ArrayList cityList = this.mTopoSpace.getMembers();
        Iterator itor = cityList.iterator();
        while (itor.hasNext()) {
            this.drawCity((City)((Object)itor.next()), g);
        }
    }

    private void drawCity(City c, Graphics2D g) {
        int x = c.getX();
        int y = c.getY();
        int radius = this.mGlobals.CityRadius;
        int diameter = 2 * this.mGlobals.CityRadius;
        g.setPaint(this.mGlobals.CityColor);
        g.fillOval(x - radius, y - radius, diameter, diameter);
        g.setPaint(this.mGlobals.CityPerimColor);
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(3.0f));
        g.drawOval(x - radius, y - radius, diameter, diameter);
        g.setStroke(oldStroke);
        if (this.mbTasks) {
            int xp = x + 10;
            int yp = y + 10;
            g.setPaint(this.mGlobals.TaskToDeliverColor);
            g.fillRect(xp, yp, 8, 8);
            g.setPaint(Color.orange);
            g.drawRect(xp, yp, 8, 8);
            g.setPaint(this.mGlobals.TaskToPickupColor);
            g.fillRect(x + 10, y + 20, 8, 8);
            g.setPaint(Color.orange);
            g.drawRect(x + 10, y + 20, 8, 8);
            g.setColor(this.mGlobals.Forecolor);
            int iTasks = this.mTaskMgr.getPickupTaskCount(c.getNodeLabel());
            g.drawString("x" + iTasks, x + 20, y + 17);
            iTasks = this.mTaskMgr.getDeliveredTaskCount(c.getNodeLabel());
            g.drawString("x" + iTasks, x + 20, y + 27);
        }
    }

    private void drawNames(Graphics2D g) {
        Font currentFont = g.getFont();
        if (this.mNameFont == null) {
            this.mNameFont = Font.getFont("Courier New-PLAIN-12");
        }
        g.setFont(this.mNameFont);
        g.setColor(this.mGlobals.CityNameColor);
        for (Object o : this.mTopoSpace.getMembers()) {
            City c = (City)((Object)o);
            g.drawString(c.getNodeLabel(), c.getX() + 5, c.getY() - 10);
        }
        g.setFont(currentFont);
    }

    public ArrayList getDisplayableInfo() {
        ArrayList<DisplayInfo> info = new ArrayList<DisplayInfo>();
        info.add(new DisplayInfo("Cities", 0, (Displayable)this));
        info.add(new DisplayInfo("Routes", 1, (Displayable)this));
        info.add(new DisplayInfo("Tasks", 2, (Displayable)this));
        info.add(new DisplayInfo("Names", 3, (Displayable)this));
        info.add(new DisplayInfo("Agents", 4, (Displayable)this));
        return info;
    }

    public ArrayList getObjectsAt(int x, int y) {
        ArrayList obj = new ArrayList();
        for (Object o : this.mTopoSpace.getMembers()) {
            obj.add(o);
        }
        return obj;
    }

    public Dimension getSize() {
        return new Dimension(this.mGlobals.WorldXSize, this.mGlobals.WorldYSize);
    }

    public void viewEventPerformed(ViewEvent arg0) {
        switch (arg0.getId()) {
            case 0: {
                this.mbCities = arg0.showView();
                break;
            }
            case 1: {
                this.mbRoutes = arg0.showView();
                break;
            }
            case 2: {
                this.mbTasks = arg0.showView();
                break;
            }
            case 3: {
                this.mbNames = arg0.showView();
                break;
            }
            case 4: {
                this.mbAgents = arg0.showView();
            }
        }
    }
}

