/*
 * Decompiled with CFR 0.152.
 */
package epfl.lia.logist.agent.state;

import epfl.lia.logist.agent.AgentManager;
import epfl.lia.logist.agent.AgentProfile;
import epfl.lia.logist.agent.AgentProperties;
import epfl.lia.logist.agent.AgentStateEnum;
import epfl.lia.logist.agent.plan.GDeliverAction;
import epfl.lia.logist.agent.plan.GMoveAction;
import epfl.lia.logist.agent.plan.GPickupAction;
import epfl.lia.logist.agent.plan.IGenericAction;
import epfl.lia.logist.agent.plan.Plan;
import epfl.lia.logist.agent.plan.PlanVerifier;
import epfl.lia.logist.core.topology.City;
import epfl.lia.logist.core.topology.Topology;
import epfl.lia.logist.logging.LogManager;
import epfl.lia.logist.logging.LogSeverityEnum;
import epfl.lia.logist.messaging.Message;
import epfl.lia.logist.messaging.MessageDispatcher;
import epfl.lia.logist.messaging.MessageHandler;
import epfl.lia.logist.messaging.MessageTypeEnum;
import epfl.lia.logist.messaging.action.Action;
import epfl.lia.logist.messaging.action.ActionTypeEnum;
import epfl.lia.logist.messaging.action.MoveAction;
import epfl.lia.logist.messaging.action.PickupAction;
import epfl.lia.logist.messaging.action.PlanAction;
import epfl.lia.logist.messaging.action.StrategyAction;
import epfl.lia.logist.messaging.signal.InCityObject;
import epfl.lia.logist.messaging.signal.InCitySignal;
import epfl.lia.logist.messaging.signal.InStateObject;
import epfl.lia.logist.messaging.signal.InStateSignal;
import epfl.lia.logist.messaging.signal.InitSignal;
import epfl.lia.logist.messaging.signal.KillSignal;
import epfl.lia.logist.messaging.signal.ResetSignal;
import epfl.lia.logist.messaging.signal.SetupSignal;
import epfl.lia.logist.messaging.signal.Signal;
import epfl.lia.logist.messaging.signal.TaskDeliveredSignal;
import epfl.lia.logist.messaging.signal.TaskRefusedSignal;
import epfl.lia.logist.task.Task;
import epfl.lia.logist.task.TaskManager;
import epfl.lia.logist.tools.AID;
import java.util.ArrayList;
import java.util.HashMap;
import uchicago.src.sim.network.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AgentState
extends MessageHandler {
    protected AgentStateEnum mState = AgentStateEnum.AS_NONE;
    protected AgentStateEnum mLastState = AgentStateEnum.AS_NONE;
    protected AgentStateEnum mPhase = AgentStateEnum.AS_PHASE1;
    protected AgentProfile mProfile = null;
    protected AgentState mParent = null;
    protected AgentManager mAgentMgr = null;
    protected AID mRecipientID = null;
    protected MessageDispatcher mDispatcher;
    protected boolean mAlive = true;
    protected int mCurrentRound = 1;
    private LogManager mLogMgr = null;

    protected AgentState(AgentProfile ap, AgentState as) {
        this.mProfile = ap;
        this.mParent = as;
        this.mDispatcher = MessageDispatcher.getInstance();
        this.mDispatcher.register(this);
        this.mAgentMgr = AgentManager.getInstance();
        this.mLogMgr = LogManager.getInstance();
    }

    public void setRecipient(AID r) {
        this.mRecipientID = r;
    }

    public void step() {
        Action<?> lAction = this.getNextAction();
        if (!this.mAlive) {
            return;
        }
        block0 : switch (this.mState) {
            case AS_INIT: {
                switch (this.mPhase) {
                    case AS_PHASE1: {
                        this.postInitSignal(this.mProfile.getProperties());
                        this.mPhase = AgentStateEnum.AS_PHASE2;
                        break;
                    }
                    case AS_PHASE2: {
                        if (lAction == null || lAction.getType() != ActionTypeEnum.AMT_READY) break block0;
                        this.mPhase = AgentStateEnum.AS_PHASE3;
                        this.mAgentMgr.getBarrier().announce(this.mObjectID);
                        break;
                    }
                    case AS_PHASE3: {
                        if (this.mAgentMgr.getBarrier().blocked() && !this.mAgentMgr.getBarrier().timeout()) break block0;
                        this.mPhase = AgentStateEnum.AS_PHASE1;
                        this.mState = AgentStateEnum.AS_SETUP;
                        if (!this.mAgentMgr.getBarrier().isBlocked(this.mObjectID)) break block0;
                        this.mAgentMgr.removeAgent(this.mProfile);
                    }
                }
                break;
            }
            case AS_RESET: {
                switch (this.mPhase) {
                    case AS_PHASE1: {
                        this.postResetSignal(this.mCurrentRound);
                        this.mPhase = AgentStateEnum.AS_PHASE2;
                        break;
                    }
                    case AS_PHASE2: {
                        if (lAction == null || lAction.getType() != ActionTypeEnum.AMT_READY) break block0;
                        this.mPhase = AgentStateEnum.AS_PHASE3;
                        this.mAgentMgr.getBarrier().announce(this.mObjectID);
                        break;
                    }
                    case AS_PHASE3: {
                        if (this.mAgentMgr.getBarrier().blocked() && !this.mAgentMgr.getBarrier().timeout()) break block0;
                        this.mPhase = AgentStateEnum.AS_PHASE1;
                        this.mState = AgentStateEnum.AS_SETUP;
                        if (!this.mAgentMgr.getBarrier().isBlocked(this.mObjectID)) break block0;
                        this.mAgentMgr.removeAgent(this.mProfile);
                    }
                }
                break;
            }
            case AS_KILL: {
                switch (this.mPhase) {
                    case AS_PHASE1: {
                        this.postKillSignal(0);
                        this.mState = AgentStateEnum.AS_KILL;
                        this.mPhase = AgentStateEnum.AS_PHASE2;
                        break;
                    }
                    case AS_PHASE2: {
                        if (lAction == null || lAction.getType() != ActionTypeEnum.AMT_READY) break block0;
                        this.mState = AgentStateEnum.AS_KILL;
                        this.mPhase = AgentStateEnum.AS_PHASE3;
                        this.mAgentMgr.getBarrier().announce(this.mObjectID);
                        break;
                    }
                    case AS_PHASE3: {
                        this.mAlive = false;
                    }
                }
                break;
            }
            case AS_WAIT: {
                if (lAction == null) {
                    return;
                }
                switch (lAction.getType()) {
                    case AMT_READY: {
                        if (this.mLastState != AgentStateEnum.AS_SETUP) break block0;
                        this.mState = AgentStateEnum.AS_IDLE;
                        break;
                    }
                    case AMT_MOVE: {
                        if (this.mLastState != AgentStateEnum.AS_IDLE) break block0;
                        String city = (String)((MoveAction)lAction).getMessage();
                        this.mProfile.setPlan(this.createMovePlan(city));
                        this.mState = this.mLastState;
                        break;
                    }
                    case AMT_PICKUP: {
                        Integer lTaskID = (Integer)((PickupAction)lAction).getMessage();
                        this.mProfile.setPlan(this.createPickupPlan(lTaskID));
                        this.mState = this.mLastState;
                        break;
                    }
                    case AMT_PLAN: {
                        System.out.println("Agent " + this.mProfile.getName() + " received plan...");
                        Plan plan = (Plan)((PlanAction)lAction).getMessage();
                        if (PlanVerifier.isValid(plan, this.mProfile)) {
                            this.mProfile.setPlan(plan);
                        } else {
                            this.mProfile.setPlan(null);
                        }
                        this.mState = this.mLastState;
                        break;
                    }
                    case AMT_STRATEGY: {
                        HashMap plans = (HashMap)((StrategyAction)lAction).getMessage();
                        this.applyStrategy(plans);
                        this.mState = this.mLastState;
                        break;
                    }
                    default: {
                        this.execute(lAction);
                        break;
                    }
                }
                break;
            }
            default: {
                this.execute(lAction);
            }
        }
    }

    private AgentProfile getProfileByName(String name) {
        for (AgentProfile ap : this.mProfile.getChildren()) {
            if (!ap.getName().equals(name)) continue;
            return ap;
        }
        return null;
    }

    public boolean planMeetsConditions(Plan p) {
        return true;
    }

    private void applyStrategy(HashMap<String, Plan> plans) {
        if (plans == null) {
            return;
        }
        for (String agentName : plans.keySet()) {
            Plan associatedPlan = plans.get(agentName);
            if (associatedPlan == null) continue;
            this.debug("Plan for [" + agentName + "] " + associatedPlan);
            AgentProfile profile = this.getProfileByName(agentName);
            System.out.println("Sending plan to agent '" + agentName + "'...");
            if (profile != null) {
                this.mDispatcher.post(new PlanAction(this.mObjectID, profile.getID(), plans.get(agentName)));
                continue;
            }
            this.warning("No plan for agent [" + agentName + "]");
        }
    }

    protected Plan createMovePlan(String target) {
        Topology topology = Topology.getInstance();
        City targetCity = topology.getCity(target);
        City currentCity = this.mProfile.getCurrentCity();
        if (!topology.neighbors(currentCity, targetCity)) {
            return null;
        }
        if (targetCity != null && !currentCity.match(targetCity)) {
            double distance = topology.getDistance(targetCity, currentCity);
            IGenericAction[] actionArray = new IGenericAction[]{new GMoveAction(targetCity, distance)};
            return new Plan(actionArray);
        }
        return null;
    }

    protected Plan createPickupPlan(Integer taskID) {
        TaskManager taskMgr = TaskManager.getInstance();
        Topology topology = Topology.getInstance();
        Task t = taskMgr.getTaskFromID(taskID);
        if (t == null) {
            return null;
        }
        City deliveryCity = topology.getCity(t.getDeliveryCity());
        if (deliveryCity == null) {
            return null;
        }
        ArrayList<IGenericAction> lActionList = new ArrayList<IGenericAction>();
        lActionList.add(new GPickupAction(t));
        City startCity = this.mProfile.getCurrentCity();
        City targetCity = deliveryCity;
        while (startCity != targetCity) {
            startCity = topology.moveOnShortestPath(startCity, targetCity);
            double distance = 0.0;
            try {
                distance = topology.getDistance(this.mProfile.getCurrentCity(), startCity);
            }
            catch (Exception exception) {
                // empty catch block
            }
            lActionList.add(new GMoveAction(startCity, distance));
        }
        lActionList.add(new GDeliverAction(t));
        return new Plan(lActionList);
    }

    public abstract void notifyTaskBatchCreation();

    public boolean isAlive() {
        return this.mAlive;
    }

    protected abstract void execute(Action<?> var1);

    public abstract void notifySignal(Signal<?> var1);

    public void setState(AgentStateEnum as) {
        this.mState = as;
        this.mPhase = AgentStateEnum.AS_PHASE1;
    }

    public void setRound(int round) {
        this.mCurrentRound = round;
    }

    protected void notifyParent(Action<?> action) {
    }

    protected Action<?> getNextAction() {
        Message<?> lNextMsg = null;
        while ((lNextMsg = this.mDispatcher.retrieve(this)) != null) {
            if (lNextMsg.getMsgType() != MessageTypeEnum.MGT_ACTION) continue;
            return (Action)lNextMsg;
        }
        return null;
    }

    public void postInitSignal(AgentProperties ap) {
        this.mDispatcher.post(new InitSignal(this.mObjectID, this.mRecipientID, ap));
    }

    public void postResetSignal(int round) {
        this.mDispatcher.post(new ResetSignal(this.mObjectID, this.mRecipientID, new Integer(round)));
    }

    public void postKillSignal(int reason) {
        this.mDispatcher.post(new KillSignal(this.mObjectID, this.mRecipientID, new Integer(reason)));
    }

    public void postSetupSignal(Object obj) {
        this.mDispatcher.post(new SetupSignal(this.mObjectID, this.mRecipientID, obj));
    }

    public void postTaskRefusedSignal(int tid) {
        this.mDispatcher.post(new TaskRefusedSignal(this.mObjectID, this.mRecipientID, tid));
    }

    public void postTaskDeliveredSignal(int tid) {
        this.mDispatcher.post(new TaskDeliveredSignal(this.mObjectID, this.mRecipientID, tid));
    }

    public void postInCitySignal(InCityObject obj) {
        this.mDispatcher.post(new InCitySignal(this.mObjectID, this.mRecipientID, obj));
    }

    public void postInStateSignal(InStateObject obj) {
        this.mDispatcher.post(new InStateSignal(this.mObjectID, this.mRecipientID, obj));
    }

    public void debug(String msg) {
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_DEBUG, msg);
    }

    public void info(String msg) {
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_INFO, msg);
    }

    public void warning(String msg) {
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_WARNING, msg);
    }

    public void error(String msg) {
        this.mLogMgr.log(LogManager.DEFAULT, LogSeverityEnum.LSV_ERROR, msg);
    }

    protected InStateObject createInStateObject() {
        Topology topo = Topology.getInstance();
        TaskManager taskMgr = TaskManager.getInstance();
        InStateObject iso = new InStateObject();
        iso.CurrentCity = this.mProfile.getCurrentCity();
        iso.Graph = topo;
        iso.Tasks = new HashMap();
        for (City c : topo.getCities().values()) {
            ArrayList<Task> taskList = new ArrayList<Task>();
            ArrayList<Task> originalTaskList = taskMgr.getPickupTasklist(c.getNodeLabel());
            for (Task t : originalTaskList) {
                taskList.add(t.clone());
            }
            iso.Tasks.put(c, taskList);
        }
        iso.AssignedTasks = new ArrayList();
        ArrayList<Task> allocatedTaskList = taskMgr.getAllocatedTasklist(this.mObjectID);
        if (allocatedTaskList != null) {
            for (Task t : allocatedTaskList) {
                if (t == null) continue;
                iso.AssignedTasks.add(t.clone());
            }
        }
        iso.Vehicles = new ArrayList();
        for (AgentProfile ap : this.mProfile.getChildren()) {
            iso.Vehicles.add(ap.getProperties());
        }
        return iso;
    }

    /*
     * Unable to fully structure code
     */
    protected InCityObject createInCityObject(boolean oneTask) {
        block4: {
            currentCity = this.mProfile.getCurrentCity();
            lObj = new InCityObject();
            lObj.Name = currentCity.getNodeLabel();
            lObj.Neighbors = new ArrayList<E>();
            lObj.Tasks = new ArrayList<E>();
            lAvailableDestinations = Topology.getInstance().getDestinations(currentCity);
            for (? c : lAvailableDestinations) {
                lObj.Neighbors.add(((Node)c).getNodeLabel());
            }
            lItor = TaskManager.getInstance().getPickupTasklist(currentCity.getNodeLabel()).iterator();
            if (!oneTask) ** GOTO lbl19
            if (!lItor.hasNext()) break block4;
            lObj.Tasks.add(lItor.next().getDescriptor());
            break block4;
lbl-1000:
            // 1 sources

            {
                lObj.Tasks.add(lItor.next().getDescriptor());
lbl19:
                // 2 sources

                ** while (lItor.hasNext())
            }
        }
        return lObj;
    }
}

