/*
 * Decompiled with CFR 0.152.
 */
package ilog.concert.model;

import ilog.concert.IloCPModeler;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloDomain;
import ilog.concert.IloException;
import ilog.concert.IloFloatDomain;
import ilog.concert.model.IlcDomain;

public class IlcFloatDomain
extends IlcDomain
implements IloFloatDomain {
    private double tm = Double.NEGATIVE_INFINITY;
    private double um = Double.POSITIVE_INFINITY;

    public double getDiameter() {
        return this.um - this.tm;
    }

    public double getLB() {
        return this.tm;
    }

    public void setLB(double d2) {
        this.tm = d2;
    }

    public double getUB() {
        return this.um;
    }

    public void setUB(double d2) {
        this.um = d2;
    }

    public boolean includes(IloDomain iloDomain) throws IloException {
        IloFloatDomain iloFloatDomain = (IloFloatDomain)iloDomain;
        return this.tm <= iloFloatDomain.getLB() && iloFloatDomain.getUB() <= this.um;
    }

    public IlcFloatDomain(double d2, double d3) throws IloException {
        if (d2 > d3) {
            throw new IloException("Declare invalid floating interval domain.");
        }
        this.tm = d2;
        this.um = d3;
    }

    public String printType() {
        return "float";
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(this.tm);
        if (this.tm != this.um) {
            stringBuffer.append("..");
            stringBuffer.append(this.um);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        return iloCPModeler.floatDomain(this.tm, this.um);
    }
}

