/*
 * Decompiled with CFR 0.152.
 */
package TrialAgent;

import TrialAgent.Action;
import TrialAgent.CentralizedPlan;
import TrialAgent.MyVehicle;
import TrialAgent.PDP;
import TrialAgent.PDPlan;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import logist.LogistSettings;
import logist.agent.Agent;
import logist.behavior.AuctionBehavior;
import logist.config.Parsers;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.Task;
import logist.task.TaskDistribution;
import logist.task.TaskSet;
import logist.topology.Topology;

public class TrialAgent
implements AuctionBehavior {
    private Topology topology;
    private TaskDistribution distribution;
    private Agent agent;
    double[][] propobality;
    private List<Topology.City> allCities;
    private int num_vehicles;
    private double biggest_capacity;
    double[][] probabilityGoodTask;
    private PDPlan ownPlan;
    private double ownCost;
    private double ownNewCost;
    private List<MyVehicle> ownVehicles;
    private List<Topology.City> ownVehicleCities;
    private PDPlan opponentPlan;
    private double opponentCost;
    private double opponentNewCost;
    private List<MyVehicle> opponentVehicles;
    double opponentRatio = 0.8;
    double myMarginBidRatio = 0.9;
    int accumulation_rounds = 5;
    double estimate_bid_ratio = 1.0;
    static final double oppRatioUpper = 0.9;
    static final double oppRatioLower = 0.8;
    static final double myRatioUpper = 0.95;
    static final double myRatioLower = 0.75;
    private double bidOppMin = Double.MAX_VALUE;
    private double bidAboutPositionMin = 0.9;
    private double bidAboutPositionMax = 1.1;
    private long allowedTime = 40000L;
    private int tasksWon;
    private int tasksLost;
    private int round = 0;

    public void setup(Topology topology, TaskDistribution distribution, Agent agent) {
        this.topology = topology;
        this.distribution = distribution;
        this.agent = agent;
        LogistSettings ls = null;
        try {
            ls = Parsers.parseSettings((String)("config" + File.separator + "settings_auction.xml"));
        }
        catch (Exception exc) {
            System.out.println("There was a problem loading the configuration file.");
        }
        this.allowedTime = ls.get(LogistSettings.TimeoutKey.PLAN);
        List vehicles = agent.vehicles();
        this.num_vehicles = vehicles.size();
        this.ownVehicles = new ArrayList<MyVehicle>(this.num_vehicles);
        this.allCities = topology.cities();
        this.ownVehicleCities = new ArrayList<Topology.City>();
        this.biggest_capacity = 0.0;
        for (Vehicle vehicle : vehicles) {
            MyVehicle myVehicle = new MyVehicle(vehicle);
            this.ownVehicles.add(myVehicle);
            this.ownVehicleCities.add(vehicle.homeCity());
            this.biggest_capacity = Math.max(this.biggest_capacity, (double)vehicle.capacity());
        }
        this.ownPlan = new PDPlan(this.ownVehicles);
        this.opponentVehicles = new ArrayList<MyVehicle>(this.num_vehicles);
        for (Vehicle vehicle : vehicles) {
            int randomNum;
            Topology.City randomCity;
            Random random = new Random();
            while (this.ownVehicleCities.contains(randomCity = this.allCities.get(randomNum = random.nextInt(this.allCities.size())))) {
            }
            MyVehicle oppVehicle = new MyVehicle(null, randomCity, vehicle.capacity(), vehicle.costPerKm());
            this.opponentVehicles.add(oppVehicle);
        }
        this.opponentPlan = new PDPlan(this.opponentVehicles);
        this.initProbabilityGoodTask();
        for (Object row : (Object)this.probabilityGoodTask) {
            System.out.println(Arrays.toString((double[])row));
        }
    }

    public void auctionResult(Task previous, int winner, Long[] bids) {
        long startTime = System.currentTimeMillis();
        double myBid = bids[this.agent.id()].longValue();
        double oppBid = bids[1 - this.agent.id()].longValue();
        double ownMarginalCost = this.ownNewCost - this.ownCost;
        double opponentMarginalCost = this.opponentNewCost - this.opponentCost;
        System.out.println("[TRIAL] Our Bid vs. Opponent:  " + myBid + " vs. " + oppBid);
        System.out.println("[TRIAL] Our Costs vs. Opponent:  " + ownMarginalCost + " vs. " + opponentMarginalCost);
        if (opponentMarginalCost != 0.0) {
            double new_bid_ratio = oppBid / opponentMarginalCost;
            this.estimate_bid_ratio = 0.3 * new_bid_ratio + 0.7 * this.estimate_bid_ratio;
            System.out.println("[TRIAL] new estimate bid ratio " + this.estimate_bid_ratio);
        }
        if (winner == this.agent.id()) {
            ++this.tasksWon;
            this.ownCost = this.ownNewCost;
            this.ownPlan.updatePlan();
            this.ownPlan.SLSAlgorithm(100, this.allowedTime - 100L, startTime);
        } else {
            ++this.tasksLost;
            this.opponentCost = this.opponentNewCost;
            this.opponentPlan.updatePlan();
            this.opponentPlan.SLSAlgorithm(100, this.allowedTime - 100L, startTime);
        }
        if (oppBid < this.bidOppMin && oppBid > 0.0) {
            this.bidOppMin = oppBid;
        }
        double increment = 0.03;
        if (winner == this.agent.id()) {
            this.myMarginBidRatio = Math.min(0.95, this.myMarginBidRatio + increment);
            this.opponentRatio = Math.min(0.9, this.opponentRatio + increment);
        } else {
            this.opponentCost = this.opponentNewCost;
            this.opponentPlan.updatePlan();
            this.myMarginBidRatio = Math.max(0.75, this.myMarginBidRatio - increment);
            this.opponentRatio = Math.max(0.8, this.opponentRatio - increment);
        }
        if (this.round == 1) {
            Topology.City predictCity = null;
            double costDiff = Double.MAX_VALUE;
            for (Topology.City city : this.allCities) {
                double diff;
                if (this.ownVehicleCities.contains(city) || !((diff = Math.abs((city.distanceTo(previous.pickupCity) + previous.pickupCity.distanceTo(previous.deliveryCity)) * this.opponentVehicles.get(0).getCostPerKm() - oppBid)) < costDiff)) continue;
                costDiff = diff;
                predictCity = city;
            }
            this.opponentVehicles.get(0).setInitCity(predictCity);
            System.out.println("City: " + predictCity);
        }
    }

    public Long askPrice(Task task) {
        double proposedBid;
        if (this.ownPlan.getBiggestVehicle().getCapacity() < task.weight) {
            return null;
        }
        this.ownNewCost = this.ownPlan.solveWithNewTask(task).cost();
        this.opponentNewCost = this.opponentPlan.solveWithNewTask(task).cost();
        double ownMarginalCost = this.ownNewCost - this.ownCost;
        double opponentMarginalCost = this.opponentNewCost - this.opponentCost;
        int current_round = this.tasksLost + this.tasksWon;
        if (current_round < this.accumulation_rounds) {
            double max_discount = 0.6;
            double valueTask = this.probabilityGoodTask[task.pickupCity.id][task.deliveryCity.id];
            double normalizedDiscount = 0.5 + 0.5 * (1.0 - valueTask);
            double effectiveDiscount = max_discount * normalizedDiscount;
            System.out.println("[TRAIL] marginal cost " + ownMarginalCost + " disocunt " + max_discount + " normalized value task " + normalizedDiscount);
            proposedBid = ownMarginalCost * effectiveDiscount;
            if (proposedBid <= 0.0) {
                System.out.println("[TRIAL] proposed bid too low, previous value: " + proposedBid);
                proposedBid = opponentMarginalCost * 0.5;
            }
        } else {
            double opponentAdjustedCosts = opponentMarginalCost * this.estimate_bid_ratio;
            proposedBid = opponentAdjustedCosts * this.opponentRatio;
            if (proposedBid < this.myMarginBidRatio * ownMarginalCost) {
                System.out.println("[TRIAL] less than own marginal, previous bid: " + proposedBid);
                proposedBid = this.myMarginBidRatio * ownMarginalCost;
            }
            if (proposedBid < this.bidOppMin) {
                System.out.println("[TRIAL] own marginal is zero, previous bid " + proposedBid);
                proposedBid = this.bidOppMin;
            }
        }
        System.out.println("[TRIAL] proposedBid " + proposedBid);
        return (long)Math.floor(proposedBid);
    }

    public List<Plan> plan(List<Vehicle> vehicles, TaskSet tasks) {
        CentralizedPlan selectedPlan;
        long startTime = System.currentTimeMillis();
        System.out.println("Agent " + this.agent.id() + " has tasks " + tasks);
        System.out.println(tasks.size());
        PDPlan pdplan = new PDPlan(this.ownVehicles);
        pdplan.solveWithTaskSet(tasks);
        ArrayList<Plan> plans = new ArrayList<Plan>();
        if (System.currentTimeMillis() - startTime > 100L) {
            System.out.println("time left:" + (System.currentTimeMillis() - startTime));
            PDP pdpAlg = new PDP(this.ownVehicles, tasks);
            pdpAlg.SLSAlgorithmWithInitPlan(this.allowedTime, pdplan.getBestPlan(), startTime);
            selectedPlan = pdplan.getBestPlan().cost() < pdpAlg.getBestPlan().cost() ? pdplan.getBestPlan() : pdpAlg.getBestPlan();
        } else {
            selectedPlan = pdplan.getBestPlan();
        }
        System.out.println(this.ownPlan.getBestPlan().cost() + "VS" + selectedPlan.cost());
        selectedPlan.printPlan();
        for (MyVehicle vehicle : this.ownVehicles) {
            plans.add(this.makePlan(vehicle, selectedPlan.getVehicleActions().get(vehicle)));
        }
        while (plans.size() < vehicles.size()) {
            plans.add(Plan.EMPTY);
        }
        return plans;
    }

    private Plan makePlan(MyVehicle vehicle, LinkedList<Action> linkedList) {
        Topology.City currentCity = vehicle.getInitCity();
        Plan plan = new Plan(currentCity, new logist.plan.Action[0]);
        for (Action action : linkedList) {
            Topology.City nextCity;
            if (action.type == Action.Type.PICKUP) {
                nextCity = action.currentTask.pickupCity;
                for (Topology.City city : currentCity.pathTo(nextCity)) {
                    plan.appendMove(city);
                }
                currentCity = nextCity;
                plan.appendPickup(action.currentTask);
                continue;
            }
            nextCity = action.currentTask.deliveryCity;
            for (Topology.City city : currentCity.pathTo(nextCity)) {
                plan.appendMove(city);
            }
            currentCity = nextCity;
            plan.appendDelivery(action.currentTask);
        }
        return plan;
    }

    private void initPro() {
        int max = 0;
        int min = Integer.MAX_VALUE;
        int[][] cityEdge = new int[this.topology.size()][this.topology.size()];
        for (Topology.City city1 : this.topology.cities()) {
            for (Topology.City city2 : this.topology.cities()) {
                cityEdge[city1.id][city2.id] = city1.neighbors().size() * city2.neighbors().size();
                if (cityEdge[city1.id][city2.id] > max) {
                    max = cityEdge[city1.id][city2.id];
                }
                if (cityEdge[city1.id][city2.id] >= min) continue;
                min = cityEdge[city1.id][city2.id];
            }
        }
        double ratio = (this.bidAboutPositionMax - this.bidAboutPositionMin) / (double)(max - min);
        for (Topology.City city1 : this.topology.cities()) {
            for (Topology.City city2 : this.topology.cities()) {
                this.propobality[city1.id][city2.id] = (double)(cityEdge[city1.id][city2.id] - min) * ratio + this.bidAboutPositionMin;
                System.out.println(this.propobality[city1.id][city2.id]);
            }
        }
    }

    private Plan makePlan(MyVehicle vehicle, LinkedList<Action> linkedList, TaskSet tasks) {
        Topology.City currentCity = vehicle.getInitCity();
        Plan plan = new Plan(currentCity, new logist.plan.Action[0]);
        HashMap<Integer, Task> taskMap = new HashMap<Integer, Task>();
        for (Task task : tasks) {
            taskMap.put(task.id, task);
        }
        for (Action action : linkedList) {
            Task selectedTask;
            Topology.City nextCity;
            System.out.println(action.currentTask.id);
            if (action.type == Action.Type.PICKUP) {
                nextCity = action.currentTask.pickupCity;
                for (Topology.City city : currentCity.pathTo(nextCity)) {
                    plan.appendMove(city);
                }
                currentCity = nextCity;
                selectedTask = (Task)taskMap.get(action.currentTask.id);
                plan.appendPickup(selectedTask);
                continue;
            }
            nextCity = action.currentTask.deliveryCity;
            for (Topology.City city : currentCity.pathTo(nextCity)) {
                plan.appendMove(city);
            }
            currentCity = nextCity;
            selectedTask = (Task)taskMap.get(action.currentTask.id);
            plan.appendDelivery(selectedTask);
        }
        return plan;
    }

    private void initProbabilityGoodTask() {
        this.probabilityGoodTask = new double[this.topology.size()][this.topology.size()];
        double totalDuration = 0.0;
        double maxDuration = 0.0;
        double[] connectivity = new double[this.topology.size()];
        for (Topology.City city1 : this.topology.cities()) {
            for (Topology.City city2 : this.topology.cities()) {
                double prob = this.distribution.probability(city1, city2);
                for (Topology.City interCity : city1.pathTo(city2)) {
                    int n = interCity.id;
                    connectivity[n] = connectivity[n] + prob;
                }
            }
        }
        double max = 0.0;
        double min = Double.MAX_VALUE;
        for (Topology.City city1 : this.topology.cities()) {
            for (Topology.City city2 : this.topology.cities()) {
                double prob = this.distribution.probability(city1, city2);
                double cumSum = 0.0;
                for (Topology.City interCity : city1.pathTo(city2)) {
                    cumSum += connectivity[interCity.id];
                }
                this.probabilityGoodTask[city1.id][city2.id] = cumSum;
                if (max < cumSum) {
                    max = cumSum;
                    continue;
                }
                if (!(min > cumSum)) continue;
                min = cumSum;
            }
        }
        for (Topology.City city1 : this.topology.cities()) {
            for (Topology.City city2 : this.topology.cities()) {
                this.probabilityGoodTask[city1.id][city2.id] = (this.probabilityGoodTask[city1.id][city2.id] - min) / (max - min);
            }
        }
    }
}

