/*
 * Decompiled with CFR 0.152.
 */
package TrialAgent;

import TrialAgent.Action;
import TrialAgent.MyVehicle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import logist.task.Task;
import logist.task.TaskSet;

public class CentralizedPlan
implements Cloneable {
    private HashMap<MyVehicle, LinkedList<Action>> vehicleActions = new HashMap();

    public HashMap<MyVehicle, LinkedList<Action>> getVehicleActions() {
        return this.vehicleActions;
    }

    public void setVehicleActions(HashMap<MyVehicle, LinkedList<Action>> vehicleActions) {
        this.vehicleActions = vehicleActions;
    }

    public void removeTask(Task t) {
        for (MyVehicle v : this.vehicleActions.keySet()) {
            this.removeActionFormMyVehicle(v, new Action(Action.Type.PICKUP, t));
            this.removeActionFormMyVehicle(v, new Action(Action.Type.DELIVERY, t));
        }
    }

    public void removeActionFormMyVehicle(MyVehicle v1, Action action) {
        LinkedList<Action> actionList = this.vehicleActions.get(v1);
        actionList.remove(action);
        this.vehicleActions.put(v1, actionList);
    }

    public List<CentralizedPlan> insertTask(Task task) {
        ArrayList<CentralizedPlan> planList = new ArrayList<CentralizedPlan>();
        for (Map.Entry<MyVehicle, LinkedList<Action>> entry : this.vehicleActions.entrySet()) {
            LinkedList<Action> actionList = entry.getValue();
            Action pickupAction = new Action(Action.Type.PICKUP, task);
            Action deliverAction = new Action(Action.Type.DELIVERY, task);
            MyVehicle MyVehicle2 = entry.getKey();
            for (int pos1 = 0; pos1 <= actionList.size(); ++pos1) {
                for (int pos2 = pos1 + 1; pos2 <= actionList.size() + 1; ++pos2) {
                    CentralizedPlan copyPlan = null;
                    try {
                        copyPlan = (CentralizedPlan)this.clone();
                    }
                    catch (CloneNotSupportedException e) {
                        e.printStackTrace();
                    }
                    LinkedList copyActionList = (LinkedList)actionList.clone();
                    copyActionList.add(pos1, pickupAction);
                    copyActionList.add(pos2, deliverAction);
                    copyPlan.vehicleActions.put(MyVehicle2, copyActionList);
                    if (copyPlan.violateConstraint()) continue;
                    planList.add(copyPlan);
                }
            }
        }
        return planList;
    }

    public double cost() {
        double cost = 0.0;
        for (Map.Entry<MyVehicle, LinkedList<Action>> entry : this.vehicleActions.entrySet()) {
            MyVehicle MyVehicle2 = entry.getKey();
            LinkedList<Action> actionList = entry.getValue();
            if (actionList.size() <= 0) continue;
            Task startTask = actionList.get(0).getCurrentTask();
            double des = MyVehicle2.getInitCity().distanceTo(startTask.pickupCity);
            for (int i = 0; i < actionList.size() - 1; ++i) {
                Action preAction = actionList.get(i);
                Action postAction = actionList.get(i + 1);
                if (preAction.type == Action.Type.PICKUP && postAction.type == Action.Type.PICKUP) {
                    des += preAction.currentTask.pickupCity.distanceTo(postAction.currentTask.pickupCity);
                    continue;
                }
                if (preAction.type == Action.Type.DELIVERY && postAction.type == Action.Type.PICKUP) {
                    des += preAction.currentTask.deliveryCity.distanceTo(postAction.currentTask.pickupCity);
                    continue;
                }
                if (preAction.type == Action.Type.PICKUP && postAction.type == Action.Type.DELIVERY) {
                    des += preAction.currentTask.pickupCity.distanceTo(postAction.currentTask.deliveryCity);
                    continue;
                }
                des += preAction.currentTask.deliveryCity.distanceTo(postAction.currentTask.deliveryCity);
            }
            cost += des * MyVehicle2.getCostPerKm();
        }
        return cost;
    }

    protected Object clone() throws CloneNotSupportedException {
        CentralizedPlan o = null;
        try {
            o = (CentralizedPlan)super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println(e.toString());
        }
        o.vehicleActions = new HashMap();
        for (MyVehicle key : this.vehicleActions.keySet()) {
            o.vehicleActions.put(key, (LinkedList)this.vehicleActions.get(key).clone());
        }
        return o;
    }

    public String toString() {
        Object output = "";
        for (Map.Entry<MyVehicle, LinkedList<Action>> entry : this.vehicleActions.entrySet()) {
            output = (String)output + entry.getKey().getVehicle().name() + " " + entry.getValue() + "\n";
        }
        return "CentralizedPlan:MyVehicleActions=" + (String)output;
    }

    public boolean violateConstraint() {
        boolean isViolate = false;
        for (Map.Entry<MyVehicle, LinkedList<Action>> entry : this.vehicleActions.entrySet()) {
            MyVehicle MyVehicle2 = entry.getKey();
            int capacity = MyVehicle2.getCapacity();
            LinkedList<Action> actionList = entry.getValue();
            if (actionList.size() > 0) {
                int tmpWeight = 0;
                for (int i = 0; i < actionList.size(); ++i) {
                    tmpWeight = actionList.get((int)i).type == Action.Type.PICKUP ? (tmpWeight += actionList.get((int)i).currentTask.weight) : (tmpWeight -= actionList.get((int)i).currentTask.weight);
                    if (tmpWeight <= capacity) continue;
                    isViolate = true;
                    break;
                }
            }
            if (!isViolate) continue;
            break;
        }
        return isViolate;
    }

    public int getTaskNum() {
        int taskNum = 0;
        for (Map.Entry<MyVehicle, LinkedList<Action>> entry : this.vehicleActions.entrySet()) {
            taskNum += entry.getValue().size();
        }
        return taskNum;
    }

    public void printPlan() {
        for (Map.Entry<MyVehicle, LinkedList<Action>> entry : this.vehicleActions.entrySet()) {
            System.out.println(entry.getKey().getVehicle().name() + " " + entry.getValue());
        }
    }

    public void removeTask(TaskSet tasks) {
        HashMap<Integer, Task> taskMap = new HashMap<Integer, Task>();
        for (Task task : tasks) {
            taskMap.put(task.id, task);
        }
        for (Map.Entry<MyVehicle, LinkedList<Action>> entry : this.vehicleActions.entrySet()) {
            LinkedList<Action> actionList = entry.getValue();
            for (int i = actionList.size() - 1; i > 0; --i) {
                if (taskMap.containsKey(actionList.get((int)i).currentTask.id)) continue;
                actionList.remove(i);
            }
        }
    }
}

