/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import logist.plan.Action;
import logist.plan.Plan;
import logist.task.Task;
import logist.topology.Topology;
import template.Candidate;
import template.PD_Action;
import template.Vehicle2;

public class PlanHelper {
    private List<Vehicle2> vehicles;
    private Random random;
    private long timeout;
    private double p;

    public PlanHelper(List<Vehicle2> vehicles, long timeout) {
        this.vehicles = vehicles;
        long seed = -9019554669489983951L;
        this.random = new Random(seed);
        this.timeout = timeout;
        this.p = 0.25;
    }

    public boolean canCarryTask(Task task) {
        for (Vehicle2 vehicle : this.vehicles) {
            if (vehicle.getVehicle().capacity() < task.weight) continue;
            return true;
        }
        return false;
    }

    public Candidate computePlan(Candidate candidate, double timeout_frac) {
        long time_start = System.currentTimeMillis();
        Candidate newCandidate = new Candidate(candidate);
        boolean noTasks = true;
        for (List<Task> taskList : newCandidate.taskLists) {
            if (taskList.isEmpty()) continue;
            noTasks = false;
            break;
        }
        if (noTasks) {
            return newCandidate;
        }
        while ((double)(System.currentTimeMillis() - time_start) < timeout_frac * (double)this.timeout) {
            Candidate oldCandidate = newCandidate;
            List<Candidate> candidateList = oldCandidate.ChooseNeighbours(this.random);
            newCandidate = this.LocalChoice(candidateList, oldCandidate);
        }
        return newCandidate;
    }

    public Candidate LocalChoice(List<Candidate> candidateList, Candidate candidate) {
        if ((double)this.random.nextFloat() < this.p) {
            return candidate;
        }
        int bestCostIndex = 0;
        double bestCost = candidateList.get((int)bestCostIndex).cost;
        for (int candidateIndex = 1; candidateIndex < candidateList.size(); ++candidateIndex) {
            if (!(candidateList.get((int)candidateIndex).cost < bestCost)) continue;
            bestCostIndex = candidateIndex;
            bestCost = candidateList.get((int)bestCostIndex).cost;
        }
        return candidateList.get(bestCostIndex);
    }

    public List<Plan> planFromSolution(Candidate candidate) {
        ArrayList<Plan> planList = new ArrayList<Plan>();
        for (int vehicleIndex = 0; vehicleIndex < candidate.vehicles.size(); ++vehicleIndex) {
            Vehicle2 vehicle = candidate.vehicles.get(vehicleIndex);
            List<PD_Action> plan = candidate.plans.get(vehicleIndex);
            Topology.City currentCity = vehicle.getCurrentCity();
            Plan vechiclePlan = new Plan(currentCity, new Action[0]);
            for (PD_Action act : plan) {
                Task task = act.task;
                Topology.City nextCity = act.is_pickup ? task.pickupCity : task.deliveryCity;
                for (Topology.City move_city : currentCity.pathTo(nextCity)) {
                    vechiclePlan.appendMove(move_city);
                }
                if (act.is_pickup) {
                    vechiclePlan.appendPickup(task);
                } else {
                    vechiclePlan.appendDelivery(task);
                }
                currentCity = nextCity;
            }
            planList.add(vechiclePlan);
        }
        return planList;
    }
}

