/*
 * Decompiled with CFR 0.152.
 */
package template;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import logist.plan.Plan;
import logist.simulation.Vehicle;
import logist.task.Task;
import logist.topology.Topology;
import template.Candidate;
import template.EncodedCandidate;
import template.PlanHelper;
import template.Vehicle2;

public class AgentState {
    private int wonTasks;
    private EncodedCandidate currentEncodedCandidate;
    private EncodedCandidate potentialNextEncodedCandidate;
    private Candidate candidate;
    private PlanHelper planHelper;
    private double currentCost;
    private double potentialNextCost;
    private long totalBid;
    private long lowestBid;

    public AgentState(List<Vehicle> vehicleList, long timeout, boolean randomizeVehicles, List<Topology.City> cities, HashSet<Topology.City> occupiedCities) {
        Random random = new Random();
        ArrayList<Vehicle2> randomizedVehicles = new ArrayList<Vehicle2>();
        if (cities.size() < 4) {
            randomizeVehicles = false;
        }
        if (randomizeVehicles) {
            for (Vehicle vehicle : vehicleList) {
                Topology.City city = cities.get(random.nextInt(cities.size()));
                while (occupiedCities.contains(city)) {
                    city = cities.get(random.nextInt(cities.size()));
                }
                Vehicle2 newVehicle = new Vehicle2(city, vehicle);
                randomizedVehicles.add(newVehicle);
                occupiedCities.add(city);
            }
        }
        ArrayList<Vehicle2> vehicleList2 = new ArrayList<Vehicle2>();
        for (int i = 0; i < vehicleList.size(); ++i) {
            vehicleList2.add(new Vehicle2(vehicleList.get(i).homeCity(), vehicleList.get(i)));
        }
        this.wonTasks = 0;
        this.candidate = new Candidate(randomizeVehicles ? randomizedVehicles : vehicleList2);
        this.planHelper = new PlanHelper(randomizeVehicles ? randomizedVehicles : vehicleList2, timeout);
        this.totalBid = 0L;
        this.lowestBid = 0L;
    }

    public AgentState(AgentState agentState) {
        this.wonTasks = agentState.getWonTasks();
        this.currentEncodedCandidate = agentState.getCurrentEncodedCandidate();
        this.potentialNextEncodedCandidate = agentState.getPotentialNextEncodedCandidate();
        this.candidate = agentState.getCandidate();
        this.planHelper = agentState.getPlanHelper();
        this.currentCost = agentState.getCurrentCost();
        this.potentialNextCost = agentState.getPotentialNextCost();
        this.totalBid = agentState.getTotalBid();
        this.lowestBid = agentState.getLowestBid();
    }

    public long getLowestBid() {
        return this.lowestBid;
    }

    public long getProfit() {
        return this.getTotalBid() - Math.round(this.candidate.cost);
    }

    public double getCost() {
        return this.currentCost;
    }

    public long getTotalBid() {
        return this.totalBid;
    }

    public double getPotentialNextCost() {
        return this.potentialNextCost;
    }

    public double getCurrentCost() {
        return this.currentCost;
    }

    public PlanHelper getPlanHelper() {
        return this.planHelper;
    }

    public Candidate getCandidate() {
        return this.candidate;
    }

    public EncodedCandidate getPotentialNextEncodedCandidate() {
        return this.potentialNextEncodedCandidate;
    }

    public EncodedCandidate getCurrentEncodedCandidate() {
        return this.currentEncodedCandidate;
    }

    public int getWonTasks() {
        return this.wonTasks;
    }

    public void setLowestBid(long bid) {
        this.lowestBid = bid;
    }

    public void updateCandidate(Task task, Long bid) {
        ++this.wonTasks;
        this.candidate.addTask(task);
        this.candidate = this.potentialNextEncodedCandidate.getCandidate(this.candidate);
        this.currentEncodedCandidate = new EncodedCandidate(this.potentialNextEncodedCandidate);
        this.currentCost = this.potentialNextCost;
        this.totalBid += bid.longValue();
    }

    public double computeMarginalCostMultipleTasks(Task currentTask, List<Task> tasks, double timeout_frac) {
        Candidate futureCandidate = new Candidate(this.candidate);
        for (Task task : tasks) {
            futureCandidate.addTask(task);
        }
        futureCandidate = this.planHelper.computePlan(futureCandidate, timeout_frac * 3.0 / 4.0);
        futureCandidate.updateCost();
        double loseCost = futureCandidate.cost;
        futureCandidate.addTask(currentTask);
        futureCandidate = this.planHelper.computePlan(futureCandidate, timeout_frac * 1.0 / 4.0);
        futureCandidate.updateCost();
        return futureCandidate.cost - loseCost;
    }

    public double calculateMarginalCost(Task task, double timeout_frac) {
        this.calculateNextPotentialCandidate(task, timeout_frac);
        return this.potentialNextCost - this.currentCost;
    }

    public void calculateNextPotentialCandidate(Task task, double timeout_frac) {
        Candidate potentialNextCandidate = new Candidate(this.candidate);
        potentialNextCandidate.addTask(task);
        potentialNextCandidate = this.planHelper.computePlan(potentialNextCandidate, timeout_frac);
        potentialNextCandidate.updateCost();
        this.potentialNextCost = potentialNextCandidate.cost;
        this.potentialNextEncodedCandidate = new EncodedCandidate(potentialNextCandidate);
    }

    public List<Plan> getPlan() {
        if (this.currentEncodedCandidate == null) {
            return this.planHelper.planFromSolution(this.candidate);
        }
        Candidate finalCandidate = this.currentEncodedCandidate.getCandidate(this.candidate);
        return this.planHelper.planFromSolution(finalCandidate);
    }

    public String toString() {
        return "Cities " + this.candidate.vehicles.stream().map(v -> v.getCurrentCity().name).collect(Collectors.joining(", "));
    }
}

