/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.parameter.rpl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.parameter.rpl.RPLParameter;
import uchicago.src.sim.util.RepastException;

public abstract class AbstractRPLParameter
implements RPLParameter {
    protected String name;
    protected List childParams = new ArrayList();
    protected List childConsts = new ArrayList();
    protected Method setMethod = null;
    protected Method getMethod = null;
    protected Class type;
    protected int curIndex = 0;
    private String[] modelParamNames = new String[0];
    protected NumberConvertor convertor = null;
    private static Map convertors = new HashMap();

    public AbstractRPLParameter(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void addChildParameter(RPLParameter rPLParameter) {
        this.childParams.add(rPLParameter);
    }

    public void addChildConstant(RPLParameter rPLParameter) {
        this.childConsts.add(rPLParameter);
    }

    public void setModelParameter(SimModel simModel) throws RepastException {
        if (this.setMethod == null) {
            this.initWithModel(simModel);
        }
        this.invokeSet(simModel);
        int n = this.childConsts.size();
        for (int i = 0; i < n; ++i) {
            RPLParameter rPLParameter = (RPLParameter)this.childConsts.get(i);
            rPLParameter.setModelParameter(simModel);
        }
        if (this.childParams.size() > 0) {
            RPLParameter rPLParameter = (RPLParameter)this.childParams.get(this.curIndex);
            rPLParameter.setModelParameter(simModel);
        }
    }

    protected abstract void invokeSet(SimModel var1) throws RepastException;

    public Iterator constantIterator() {
        return this.childConsts.iterator();
    }

    public Iterator parameterIterator() {
        return this.childParams.iterator();
    }

    private void initWithModel(SimModel simModel) throws RepastException {
        this.setupParamArray(simModel);
        this.createMethods(simModel);
        Class<?> clazz = this.setMethod.getParameterTypes()[0];
        String string = "Type expected by model's parameter set method (" + clazz.getName() + ") and type of '" + this.name + "' parameter (" + this.type + ") are not compatible";
        if (this.type.equals(Double.TYPE)) {
            this.convertor = (NumberConvertor)convertors.get(clazz);
            if (this.convertor == null) {
                throw new RepastException(string);
            }
        } else if (!this.type.equals(clazz)) {
            throw new RepastException(string);
        }
    }

    private void setupParamArray(SimModel simModel) {
        String[] stringArray = simModel.getInitParam();
        this.modelParamNames = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, this.modelParamNames, 0, stringArray.length);
        this.modelParamNames[stringArray.length] = "rngSeed";
    }

    private void createMethods(SimModel simModel) throws RepastException {
        boolean bl = false;
        for (int i = 0; i < this.modelParamNames.length; ++i) {
            if (!this.name.equalsIgnoreCase(this.modelParamNames[i])) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw new RepastException("Parameter '" + this.name + "' is not named as a parameter in model's getInitParams");
        }
        Method[] methodArray = simModel.getClass().getMethods();
        int n = methodArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            Method method = methodArray[i];
            String string2 = method.getName();
            if (string2.startsWith("set") && method.getParameterTypes().length == 1) {
                string = string2.substring(3);
                if (!string.equalsIgnoreCase(this.name)) continue;
                this.setMethod = method;
                continue;
            }
            if (string2.startsWith("get") && method.getParameterTypes().length == 0) {
                string = string2.substring(3);
                if (!string.equalsIgnoreCase(this.name)) continue;
                this.getMethod = method;
                continue;
            }
            if (!string2.startsWith("is") || method.getParameterTypes().length != 0 || !method.getReturnType().equals(Boolean.TYPE) || !(string = string2.substring(2)).equalsIgnoreCase(this.name)) continue;
            this.getMethod = method;
        }
        if (this.setMethod == null) {
            throw new RepastException("Set method for parameter '" + this.name + "' not found in model");
        }
    }

    public Object getValue(SimModel simModel) throws RepastException {
        if (this.setMethod == null) {
            this.initWithModel(simModel);
        }
        return this.getValue();
    }

    protected abstract Object getValue();

    static {
        convertors.put(Double.TYPE, new DoubleToDouble());
        convertors.put(Integer.TYPE, new DoubleToInt());
        convertors.put(Long.TYPE, new DoubleToLong());
        convertors.put(Float.TYPE, new DoubleToFloat());
    }

    static class DoubleToDouble
    implements NumberConvertor {
        DoubleToDouble() {
        }

        public Object convert(double d) {
            return new Double(d);
        }

        public Object convert(Double d) {
            return d;
        }
    }

    static class DoubleToLong
    implements NumberConvertor {
        DoubleToLong() {
        }

        public Object convert(double d) {
            return new Long((long)d);
        }

        public Object convert(Double d) {
            return new Long(d.longValue());
        }
    }

    static class DoubleToFloat
    implements NumberConvertor {
        DoubleToFloat() {
        }

        public Object convert(double d) {
            return new Float((float)d);
        }

        public Object convert(Double d) {
            return new Float(d.floatValue());
        }
    }

    static class DoubleToInt
    implements NumberConvertor {
        DoubleToInt() {
        }

        public Object convert(double d) {
            return new Integer((int)d);
        }

        public Object convert(Double d) {
            return new Integer(d.intValue());
        }
    }

    static interface NumberConvertor {
        public Object convert(double var1);

        public Object convert(Double var1);
    }
}

