/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import java.util.List;
import uchicago.src.collection.ByteMatrix2D;
import uchicago.src.sim.network.AbstractAdjacencyMatrix;

public class AdjacencyByteMatrix
extends AbstractAdjacencyMatrix {
    private ByteMatrix2D matrix;

    public AdjacencyByteMatrix(int n, int n2) {
        this.matrix = new ByteMatrix2D(n, n2);
    }

    public AdjacencyByteMatrix(List list) {
        this.matrix = new ByteMatrix2D(list.size(), list.size());
        this.labels = list;
    }

    public AdjacencyByteMatrix(byte[][] byArray) {
        this.matrix = new ByteMatrix2D(byArray);
    }

    public AdjacencyByteMatrix(ByteMatrix2D byteMatrix2D) {
        this.matrix = byteMatrix2D;
    }

    public void setMatrix(DenseDoubleMatrix2D denseDoubleMatrix2D) {
        int n = denseDoubleMatrix2D.rows();
        int n2 = denseDoubleMatrix2D.columns();
        this.matrix = new ByteMatrix2D(n, n2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.matrix.set(i, j, (byte)denseDoubleMatrix2D.getQuick(i, j));
            }
        }
    }

    public void setMatrix(byte[][] byArray) {
        this.matrix = new ByteMatrix2D(byArray);
    }

    public DenseDoubleMatrix1D getRow(int n) {
        return this.matrix.getRow(n);
    }

    public double getDensity() {
        double d = this.matrix.zSum();
        return d / (double)this.matrix.rows() * (double)(this.matrix.rows() - 1);
    }

    public double getAvgDegree() {
        double d = 0.0;
        for (int i = 0; i < this.matrix.rows(); ++i) {
            for (int j = 0; j < this.matrix.columns(); ++j) {
                d += (double)this.matrix.get(i, j);
            }
        }
        return d / (double)this.matrix.rows();
    }

    public void set(int n, int n2, byte by) {
        this.matrix.set(n, n2, by);
    }

    public void set(int n, int n2, double d) {
        this.matrix.set(n, n2, (byte)d);
    }

    public double get(int n, int n2) {
        return this.matrix.get(n, n2);
    }

    public int rows() {
        return this.matrix.rows();
    }

    public int columns() {
        return this.matrix.columns();
    }

    public String matrixToString() {
        String string = this.matrix.toString();
        int n = string.indexOf("\n");
        return string.substring(n + 1, string.length());
    }

    public String toString() {
        String string = "Matrix Name: " + this.matrixLabel + "\n";
        string = string + "Matrix Labels: ";
        for (int i = 0; i < this.labels.size(); ++i) {
            string = i == 0 ? string + (String)this.labels.get(i) : string + ", " + (String)this.labels.get(i);
        }
        string = string + "\nComment: " + this.comment;
        return string + "\nAvg Degree: " + this.getAvgDegree() + "\n" + this.matrix.toString();
    }
}

