/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.engine.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import uchicago.src.guiUtils.Wizard;
import uchicago.src.sim.engine.MovieScheduler;
import uchicago.src.sim.engine.Schedule;
import uchicago.src.sim.gui.ProducerNamePair;
import uchicago.src.sim.util.SimUtilities;

public class MakeMovieDialog
extends Wizard {
    private static final int FIRST_PANEL = 0;
    private static final int SECOND_PANEL = 1;
    private static final int CAPTURE_EVERY = 2;
    private static final int CAPTURE_PAUSE = 3;
    private static final int CAPTURE_INTERVAL = 4;
    private static final String EVERY_HELP = "<html><font color=black size=-1><b>Captures the displayed image as a movie frame every iteration of the simulation.</b></font></html>";
    private static final String PAUSE_HELP = "<html><font color=black size=-1><b>Captures the displayed image as movie frame at a pause in or at the end of a simulation run.</b></font></html>";
    private static final String INTERVAL_HELP = "<html><font color=black size=-1><b>Captures the displayed image as movie frame at the interval specified in the field below, e.g. every 10th iteration of the simulation.</b></font></html>";
    private int state = 0;
    private int capture = 2;
    private JPanel firstPanel = new JPanel(new BorderLayout());
    private JPanel secondPanel = new JPanel(new BorderLayout());
    private JComboBox displays;
    private JTextField fldName = new JTextField();
    private JButton btnBrowse = new JButton("Browse");
    private JRadioButton btnPauseAndEnd = new JRadioButton("At Pause and End");
    private JRadioButton btnEveryTick = new JRadioButton("At Every Tick", true);
    private JRadioButton btnInterval = new JRadioButton("At Every nth Tick");
    private JTextField fldInterval = new JTextField(3);
    private JLabel buttonHelp = new JLabel();
    private JFrame frame = null;
    private MovieScheduler movieScheduler;
    private int interval = 0;
    private Action captureAt = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
            if (jRadioButton.getActionCommand().equals("every")) {
                MakeMovieDialog.this.capture = 2;
                MakeMovieDialog.this.fldInterval.setEnabled(false);
                MakeMovieDialog.this.buttonHelp.setText(MakeMovieDialog.EVERY_HELP);
            } else if (jRadioButton.getActionCommand().equals("interval")) {
                MakeMovieDialog.this.capture = 4;
                MakeMovieDialog.this.buttonHelp.setText(MakeMovieDialog.INTERVAL_HELP);
                MakeMovieDialog.this.fldInterval.setEnabled(true);
            } else {
                MakeMovieDialog.this.capture = 3;
                MakeMovieDialog.this.buttonHelp.setText(MakeMovieDialog.PAUSE_HELP);
                MakeMovieDialog.this.fldInterval.setEnabled(false);
            }
        }
    };
    private Action next = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (MakeMovieDialog.this.state == 0) {
                if (MakeMovieDialog.this.fldName.getText().trim().length() == 0) {
                    SimUtilities.showMessage("You must provide a movie file name");
                    return;
                }
                MakeMovieDialog.this.setTopPanel(MakeMovieDialog.this.secondPanel);
                MakeMovieDialog.this.state = 1;
                MakeMovieDialog.this.btnNext.setText("Finished");
                MakeMovieDialog.this.btnBack.setEnabled(true);
            } else {
                if (MakeMovieDialog.this.capture == 4) {
                    String string = MakeMovieDialog.this.fldInterval.getText().trim();
                    if (string.length() == 0) {
                        SimUtilities.showMessage("You must provide a numeric interval");
                        return;
                    }
                    try {
                        MakeMovieDialog.this.interval = Integer.parseInt(string);
                        if (MakeMovieDialog.this.interval <= 0) {
                            SimUtilities.showMessage("Interval must be a positive whole number");
                            return;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        SimUtilities.showMessage("Interval must be a positive whole number");
                        return;
                    }
                }
                MakeMovieDialog.this.makeRetVal();
                MakeMovieDialog.this.close();
            }
        }
    };
    private Action back = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            MakeMovieDialog.this.btnBack.setEnabled(false);
            MakeMovieDialog.this.setTopPanel(MakeMovieDialog.this.firstPanel);
            MakeMovieDialog.this.btnNext.setText("Next");
            MakeMovieDialog.this.state = 0;
        }
    };

    public MakeMovieDialog(Vector vector) {
        super(false);
        super.setTopPanel(this.firstPanel);
        this.guiInit(vector);
        this.btnBack.setEnabled(false);
        this.addListeners();
    }

    private void addListeners() {
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileDialog fileDialog = new FileDialog((Frame)MakeMovieDialog.this.frame, "Movie File", 0);
                fileDialog.show();
                String string = fileDialog.getFile();
                if (string == null) {
                    return;
                }
                string = fileDialog.getDirectory() + string;
                fileDialog.dispose();
                MakeMovieDialog.this.fldName.setText(string);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MakeMovieDialog.this.cancel = true;
                MakeMovieDialog.this.close();
            }
        });
        this.btnNext.addActionListener(this.next);
        this.btnBack.addActionListener(this.back);
        this.btnEveryTick.setActionCommand("every");
        this.btnInterval.setActionCommand("interval");
        this.btnPauseAndEnd.setActionCommand("pause");
        this.btnEveryTick.addActionListener(this.captureAt);
        this.btnPauseAndEnd.addActionListener(this.captureAt);
        this.btnInterval.addActionListener(this.captureAt);
    }

    public void display(JFrame jFrame, String string) {
        this.frame = jFrame;
        super.setSize(337, 254);
        super.display(jFrame, string, false);
    }

    private void guiInit(Vector vector) {
        super.guiInit();
        this.displays = new JComboBox(vector);
        String string = "<html><font color=black size=-1><b>Enter a file name as the name of the movie, and choose a DisplaySurface as the source for the movie. Repast will append the '.mov' extension to the file name.</b></font></html>";
        JLabel jLabel = new JLabel(string);
        this.firstPanel.add((Component)jLabel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)new JLabel("File Name: "), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel("Display: "), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)this.fldName, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.displays, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.btnBrowse, gridBagConstraints);
        this.firstPanel.add((Component)jPanel, "South");
        this.firstPanel.setBorder(BorderFactory.createEtchedBorder());
        this.buttonHelp.setText(EVERY_HELP);
        this.secondPanel.add((Component)this.buttonHelp, "North");
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel2.add((Component)this.btnPauseAndEnd, gridBagConstraints);
        gridBagConstraints.gridy = -1;
        jPanel2.add((Component)this.btnEveryTick, gridBagConstraints);
        jPanel2.add((Component)this.btnInterval, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 1;
        jPanel2.add((Component)this.fldInterval, gridBagConstraints);
        this.fldInterval.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.btnPauseAndEnd);
        buttonGroup.add(this.btnEveryTick);
        buttonGroup.add(this.btnInterval);
        this.btnEveryTick.setEnabled(true);
        this.secondPanel.add((Component)jPanel2, "South");
        this.secondPanel.setBorder(BorderFactory.createTitledBorder("Capture Frame"));
    }

    private void makeRetVal() {
        String string = this.fldName.getText();
        ProducerNamePair producerNamePair = (ProducerNamePair)this.displays.getSelectedItem();
        this.movieScheduler = new MovieScheduler(string, producerNamePair.getProducer());
    }

    public void scheduleMovie(Schedule schedule) {
        if (!this.cancel) {
            if (this.capture == 2) {
                this.movieScheduler.scheduleAtEveryTick(schedule);
            } else if (this.capture == 3) {
                this.movieScheduler.scheduleAtPauseAndEnd(schedule);
            } else {
                this.movieScheduler.scheduleAtInterval(schedule, this.interval);
            }
        }
    }
}

