/*
 * Decompiled with CFR 0.152.
 */
package anl.repast.gis.data.dbf;

import anl.repast.gis.data.dbf.JDBFException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class JDBField {
    private String name = null;
    private char type = '\u0000';
    private int length = 0;
    private int decimalCount = 0;
    private DecimalFormatSymbols DFS = new DecimalFormatSymbols();

    public JDBField(String string, char c, int n, int n2) throws JDBFException {
        if (string.length() > 10) {
            throw new JDBFException("The field name is more than 10 characters long: " + string);
        }
        if (c != 'C' && c != 'N' && c != 'L' && c != 'D' && c != 'F') {
            throw new JDBFException("The field type is not a valid. Got: " + c);
        }
        if (n < 1) {
            throw new JDBFException("The field length should be a positive integer. Got: " + n);
        }
        if (c == 'C' && n >= 254) {
            throw new JDBFException("The field length should be less than 254 characters for character fields. Got: " + n);
        }
        if (c == 'L' && n != 1) {
            throw new JDBFException("The field length should be 1 characater for logical fields. Got: " + n);
        }
        if (c == 'D' && n != 8) {
            throw new JDBFException("The field length should be 8 characaters for date fields. Got: " + n);
        }
        if (c == 'F' && n >= 21) {
            throw new JDBFException("The field length should be less than 21 digits for floating point fields. Got: " + n);
        }
        if (n2 < 0) {
            throw new JDBFException("The field decimal count should not be a negative integer. Got: " + n2);
        }
        if ((c == 'C' || c == 'L' || c == 'D') && n2 != 0) {
            throw new JDBFException("The field decimal count should be 0 for character, logical, and date fields. Got: " + n2);
        }
        if (n2 > n - 1) {
            throw new JDBFException("The field decimal count should be less than the length - 1. Got: " + n2);
        }
        this.name = string;
        this.type = c;
        this.length = n;
        this.decimalCount = n2;
        this.DFS.setDecimalSeparator('.');
    }

    public String getName() {
        return this.name;
    }

    public char getType() {
        return this.type;
    }

    public int getLength() {
        return this.length;
    }

    public int getDecimalCount() {
        return this.decimalCount;
    }

    public String format(Object object) throws JDBFException {
        if (this.type == 'N' || this.type == 'F') {
            if (object == null) {
                object = new Double(0.0);
            }
            if (object instanceof Number) {
                Number number = (Number)object;
                StringBuffer stringBuffer = new StringBuffer(this.getLength());
                for (int i = 0; i < this.getLength(); ++i) {
                    stringBuffer.append("#");
                }
                if (this.getDecimalCount() > 0) {
                    stringBuffer.setCharAt(this.getLength() - this.getDecimalCount() - 1, '.');
                }
                DecimalFormat decimalFormat = new DecimalFormat(stringBuffer.toString(), this.DFS);
                String string = decimalFormat.format(number);
                int n = this.getLength() - string.length();
                if (n < 0) {
                    throw new JDBFException("Value " + number + " cannot fit in pattern: '" + stringBuffer + "'.");
                }
                StringBuffer stringBuffer2 = new StringBuffer(n);
                for (int i = 0; i < n; ++i) {
                    stringBuffer2.append(" ");
                }
                return stringBuffer2 + string;
            }
            throw new JDBFException("Expected a Number, got " + object.getClass() + ".");
        }
        if (this.type == 'C') {
            if (object == null) {
                object = "";
            }
            if (object instanceof String) {
                String string = (String)object;
                if (string.length() > this.getLength()) {
                    throw new JDBFException("'" + object + "' is longer than " + this.getLength() + " characters.");
                }
                StringBuffer stringBuffer = new StringBuffer(this.getLength() - string.length());
                for (int i = 0; i < this.getLength() - string.length(); ++i) {
                    stringBuffer.append(' ');
                }
                return string + stringBuffer;
            }
            throw new JDBFException("Expected a String, got " + object.getClass() + ".");
        }
        if (this.type == 'L') {
            if (object == null) {
                object = new Boolean(false);
            }
            if (object instanceof Boolean) {
                Boolean bl = (Boolean)object;
                return bl != false ? "Y" : "N";
            }
            throw new JDBFException("Expected a Boolean, got " + object.getClass() + ".");
        }
        if (this.type == 'D') {
            if (object == null) {
                object = new Date();
            }
            if (object instanceof Date) {
                Date date = (Date)object;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                return simpleDateFormat.format(date);
            }
            throw new JDBFException("Expected a Date, got " + object.getClass() + ".");
        }
        throw new JDBFException("Unrecognized JDBFField type: " + this.type);
    }

    public Object parse(String string) throws JDBFException {
        string = string.trim();
        if (this.type == 'N' || this.type == 'F') {
            if (string.equals("")) {
                string = "0";
            }
            try {
                if (this.getDecimalCount() == 0) {
                    return new Long(string);
                }
                return new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new JDBFException(numberFormatException);
            }
        }
        if (this.type == 'C') {
            return string;
        }
        if (this.type == 'L') {
            if (string.equals("Y") || string.equals("y") || string.equals("T") || string.equals("t")) {
                return new Boolean(true);
            }
            if (string.equals("N") || string.equals("n") || string.equals("F") || string.equals("f")) {
                return new Boolean(false);
            }
            throw new JDBFException("Unrecognized value for logical field: " + string);
        }
        if (this.type == 'D') {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            try {
                if ("".equals(string)) {
                    return null;
                }
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                return null;
            }
        }
        throw new JDBFException("Unrecognized JDBFField type: " + this.type);
    }

    public String toString() {
        return this.name;
    }
}

