/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntExpr;
import ilog.concert.IloNumExpr;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcIntExpr;
import ilog.solver.IlcNumExpr;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.nm;
import ilog.solver.ys;

class kab
extends IlcConstraint {
    protected IlcNumExpr _var;
    protected double[] _values;
    protected IlcIntExpr _index;

    public kab(IloNumExpr iloNumExpr, double[] dArray, IloIntExpr iloIntExpr) {
        this._var = (IlcNumExpr)iloNumExpr;
        this._values = dArray;
        this._index = (IlcIntExpr)iloIntExpr;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        nm nm2 = this._var.getPNumExp(ilcSolver);
        ys ys2 = this._index.getPIntExp(ilcSolver);
        return new xz(nm2, this._values, ys2);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("element(");
        stringBuffer.append(this._var);
        stringBuffer.append(", ");
        stringBuffer.append(this._index);
        stringBuffer.append(", [");
        String string = "";
        int n2 = 0;
        while (n2 < this._values.length) {
            stringBuffer.append(string);
            string = ", ";
            stringBuffer.append(this._values[n2]);
            ++n2;
        }
        stringBuffer.append("])");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.element((IloNumExpr)iloCopyManager.getCopy(this._var), (IloIntExpr)iloCopyManager.getCopy(this._index), this._values);
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._var.needCopy(check);
        this._index.needCopy(check);
    }

    static final class xz
    extends IlcPPropagator {
        protected final nm _var;
        protected final double[] _values;
        protected final ys _index;

        public xz(nm nm2, double[] dArray, ys ys2) {
            this._var = nm2;
            nm2.kn();
            this._values = dArray;
            this._index = ys2;
            ys2.kn();
        }

        public void post() {
            this._var.whenRange(new nbb());
            this._index.whenDomain(new us());
        }

        public void propagate() {
            this._index.setDomainRange(0, this._values.length - 1);
            double d2 = Double.MAX_VALUE;
            double d3 = -1.7976931348623157E308;
            int n2 = 0;
            while (n2 < this._values.length) {
                if (this._values[n2] < d2) {
                    d2 = this._values[n2];
                }
                if (this._values[n2] > d3) {
                    d3 = this._values[n2];
                }
                ++n2;
            }
            this._var.setDomainRange(d2, d3);
            this.by();
            this.dy();
        }

        private void by() {
            double d2 = this._var.getDomainUB();
            double d3 = this._var.getDomainLB();
            int n2 = this._index.getDomainMin();
            int n3 = this._index.getDomainMax();
            int n4 = n2;
            while (n4 <= n3) {
                double d4 = this._values[n4];
                if (this._index.isInDomain(n4)) {
                    if (d4 > d3) {
                        d3 = d4;
                    }
                    if (d4 < d2) {
                        d2 = d4;
                    }
                }
                ++n4;
            }
            this._var.setDomainRange(d2, d3);
        }

        private void dy() {
            int n2 = this._index.getDomainMin();
            int n3 = this._index.getDomainMax();
            int n4 = n2;
            while (n4 <= n3) {
                if (this._index.isInDomain(n4) && !this._var.isInDomain(this._values[n4])) {
                    this._index.removeDomainValue(n4);
                }
                ++n4;
            }
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("element(");
            stringBuffer.append(this._var);
            stringBuffer.append(", ");
            stringBuffer.append(this._index);
            stringBuffer.append(", [");
            String string = "";
            int n2 = 0;
            while (n2 < this._values.length) {
                stringBuffer.append(string);
                string = ", ";
                stringBuffer.append(this._values[n2]);
                ++n2;
            }
            stringBuffer.append("])");
            return stringBuffer.toString();
        }

        class us
        extends IlcDemon {
            us() {
            }

            public void propagate() {
                xz.this.by();
            }
        }

        class nbb
        extends IlcDemon {
            nbb() {
            }

            public void propagate() {
                xz.this.dy();
            }
        }
    }
}

