/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntExpr;
import ilog.concert.IloIntLinExprTerm;
import ilog.concert.IloIntNodeTerm;
import ilog.concert.IloIntScalProd;
import ilog.concert.IloIntVar;
import ilog.concert.IloLinearIntExpr;
import ilog.concert.IloLinearIntExprIterator;
import ilog.solver.IlcIntExpr;
import ilog.solver.IlcIntVar;
import ilog.solver.IlcPIntAbstractVar;
import ilog.solver.IlcSolver;
import ilog.solver.os;
import ilog.solver.ys;
import java.util.ArrayList;

public class IlcIntScalProd
extends IlcIntExpr
implements IloIntScalProd {
    protected int _constant = 0;
    protected ArrayList _linearpart = new ArrayList();
    protected ArrayList _nodes = new ArrayList();
    private boolean qab = true;

    public void clear() throws IloException {
        this._constant = 0;
        this._linearpart.clear();
        this._nodes.clear();
        this.qab = true;
    }

    IlcIntScalProd() {
    }

    IlcIntScalProd(int n2) {
        this();
        this._constant = n2;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        Object object;
        Object object2;
        int n2 = this._linearpart.size() + this._nodes.size();
        if (n2 == 1) {
            LinearTermIterator linearTermIterator = this.linearTermIterator();
            if (linearTermIterator.hasNext()) {
                IloIntLinExprTerm iloIntLinExprTerm = (IloIntLinExprTerm)linearTermIterator.next();
                IlcIntVar ilcIntVar = (IlcIntVar)iloIntLinExprTerm.getVar();
                ys ys2 = ilcIntVar.getPIntExp(ilcSolver);
                return ys2.multiply(iloIntLinExprTerm.getCoef()).add(this._constant);
            }
            NodeIterator nodeIterator = this.nodeIterator();
            IloIntNodeTerm iloIntNodeTerm = (IloIntNodeTerm)nodeIterator.next();
            IlcIntExpr ilcIntExpr = (IlcIntExpr)iloIntNodeTerm.getExp();
            ys ys3 = ilcIntExpr.getPIntExp(ilcSolver);
            ys ys4 = ys3.multiply(iloIntNodeTerm.getCoef()).add(this._constant);
            return ys4;
        }
        ys[] ysArray = new ys[n2];
        int n3 = 0;
        int n4 = 0;
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            IlcIntVar ilcIntVar;
            object2 = (IloIntLinExprTerm)linearTermIterator.next();
            int n5 = ((IloIntLinExprTerm)object2).getCoef();
            if (n5 > 0) {
                ilcIntVar = (IlcIntVar)((IloIntLinExprTerm)object2).getVar();
                object = ilcIntVar.getPIntExp(ilcSolver);
                ysArray[n3++] = ((ys)object).multiply(n5);
                continue;
            }
            if (n5 >= 0) continue;
            ilcIntVar = (IlcIntVar)((IloIntLinExprTerm)object2).getVar();
            object = ilcIntVar.getPIntExp(ilcSolver);
            ysArray[n2 - 1 - n4++] = ((ys)object).multiply(-n5);
        }
        object2 = this.nodeIterator();
        while (((NodeIterator)object2).hasNext()) {
            ys ys5;
            IloIntNodeTerm iloIntNodeTerm = (IloIntNodeTerm)((NodeIterator)object2).next();
            int n6 = iloIntNodeTerm.getCoef();
            if (n6 > 0) {
                object = (IlcIntExpr)iloIntNodeTerm.getExp();
                ys5 = ((IlcIntExpr)object).getPIntExp(ilcSolver);
                ysArray[n3++] = ys5.multiply(n6);
                continue;
            }
            if (n6 >= 0) continue;
            object = (IlcIntExpr)iloIntNodeTerm.getExp();
            ys5 = ((IlcIntExpr)object).getPIntExp(ilcSolver);
            ysArray[n2 - 1 - n4++] = ys5.multiply(-n6);
        }
        ys ys6 = null;
        if (n3 > 0) {
            ys6 = ys.sum(ysArray, 0, n3);
            if (n4 > 0) {
                ys6 = ys6.substract(ys.sum(ysArray, n2 - n4, n2));
                if (this._constant != 0) {
                    ys6 = ys6.add(this._constant);
                }
            } else if (this._constant != 0) {
                ys6 = ys6.add(this._constant);
            }
        } else if (n4 > 0) {
            ys6 = ys.sum(ysArray, n2 - n4, n2).negate();
            if (this._constant != 0) {
                ys6 = ys6.add(this._constant);
            }
        } else {
            ys6 = IlcPIntAbstractVar.intConst(ilcSolver, this._constant);
        }
        return ys6;
    }

    public void addTo(int n2, IloIntExpr iloIntExpr) {
        IlcIntExpr ilcIntExpr = (IlcIntExpr)iloIntExpr;
        if (ilcIntExpr instanceof IlcIntVar) {
            IlcIntVar ilcIntVar = (IlcIntVar)ilcIntExpr;
            this._linearpart.add(new IloIntLinExprTerm(n2, ilcIntVar));
            this.qab = false;
        } else if (!ilcIntExpr.shouldHaveDomain() && ilcIntExpr instanceof IlcIntScalProd) {
            Object object;
            IlcIntScalProd ilcIntScalProd = (IlcIntScalProd)ilcIntExpr;
            this._constant += ilcIntScalProd._constant * n2;
            LinearTermIterator linearTermIterator = ilcIntScalProd.linearTermIterator();
            while (linearTermIterator.hasNext()) {
                object = (IloIntLinExprTerm)linearTermIterator.next();
                this._linearpart.add(new IloIntLinExprTerm(((IloIntLinExprTerm)object).getCoef() * n2, ((IloIntLinExprTerm)object).getVar()));
                this.qab = false;
            }
            if (ilcIntScalProd._nodes.size() != 0) {
                object = ilcIntScalProd.nodeIterator();
                while (((NodeIterator)object).hasNext()) {
                    IloIntNodeTerm iloIntNodeTerm = (IloIntNodeTerm)((NodeIterator)object).next();
                    if (n2 == 1) {
                        this._nodes.add(iloIntNodeTerm);
                        continue;
                    }
                    this._nodes.add(new IloIntNodeTerm(iloIntNodeTerm.getCoef() * n2, iloIntNodeTerm.getExp()));
                }
            }
        } else {
            this._nodes.add(new IloIntNodeTerm(n2, ilcIntExpr));
        }
    }

    public void addTo(int n2) {
        this._constant += n2;
    }

    public IlcIntScalProd times(int n2) {
        Object object;
        this._constant *= n2;
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            object = (IloIntLinExprTerm)linearTermIterator.next();
            ((IloIntLinExprTerm)object).setCoef(((IloIntLinExprTerm)object).getCoef() * n2);
        }
        if (this._nodes.size() != 0) {
            object = this.nodeIterator();
            while (((NodeIterator)object).hasNext()) {
                IloIntNodeTerm iloIntNodeTerm = (IloIntNodeTerm)((NodeIterator)object).next();
                iloIntNodeTerm.setCoef(iloIntNodeTerm.getCoef() * n2);
            }
        }
        return this;
    }

    public void setCoef(IlcIntVar ilcIntVar, int n2) {
        this.normalize();
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            IloIntLinExprTerm iloIntLinExprTerm = (IloIntLinExprTerm)linearTermIterator.next();
            if (iloIntLinExprTerm.getVar() != ilcIntVar) continue;
            iloIntLinExprTerm.setCoef(n2);
            return;
        }
        this.addTo(n2, ilcIntVar);
    }

    public LinearTermIterator linearTermIterator() {
        return new LinearTermIterator();
    }

    public NodeIterator nodeIterator() {
        return new NodeIterator();
    }

    public String toString() {
        Object object;
        if (!(this._extracted instanceof os)) {
            return this._extracted.toString();
        }
        StringBuffer stringBuffer = new StringBuffer("( ");
        boolean bl2 = true;
        if (this._constant != 0) {
            stringBuffer.append(this._constant);
            stringBuffer.append(" ");
            bl2 = false;
        }
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            object = (IloIntLinExprTerm)linearTermIterator.next();
            if (((IloIntLinExprTerm)object).getCoef() >= 0) {
                if (!bl2) {
                    stringBuffer.append("+ ");
                }
                bl2 = false;
                if (((IloIntLinExprTerm)object).getCoef() != 1) {
                    stringBuffer.append(((IloIntLinExprTerm)object).getCoef());
                    stringBuffer.append("*");
                }
                stringBuffer.append(((IloIntLinExprTerm)object).getVar().toString());
                stringBuffer.append(" ");
                continue;
            }
            if (((IloIntLinExprTerm)object).getCoef() > 0) continue;
            if (!bl2) {
                stringBuffer.append("- ");
            }
            bl2 = false;
            if (((IloIntLinExprTerm)object).getCoef() != -1) {
                stringBuffer.append(-((IloIntLinExprTerm)object).getCoef());
                stringBuffer.append("*");
            }
            stringBuffer.append(((IloIntLinExprTerm)object).getVar().toString());
            stringBuffer.append(" ");
        }
        object = this.nodeIterator();
        while (((NodeIterator)object).hasNext()) {
            IloIntNodeTerm iloIntNodeTerm = (IloIntNodeTerm)((NodeIterator)object).next();
            IlcIntExpr ilcIntExpr = (IlcIntExpr)iloIntNodeTerm.getExp();
            if (!bl2) {
                stringBuffer.append("+ ");
            }
            bl2 = false;
            if (iloIntNodeTerm.getCoef() != 1) {
                stringBuffer.append(iloIntNodeTerm.getCoef());
                stringBuffer.append("*");
            }
            stringBuffer.append("( ");
            stringBuffer.append(ilcIntExpr.toString());
            stringBuffer.append(") ");
        }
        if (bl2 && this._constant == 0) {
            stringBuffer.append(this._constant);
        }
        stringBuffer.append(") ");
        return stringBuffer.toString();
    }

    public int getLinearSize() {
        return this._linearpart.size();
    }

    public void normalize() {
        if (this._linearpart.size() != 0 && !this.qab) {
            IlcIntVar ilcIntVar;
            IloIntLinExprTerm iloIntLinExprTerm;
            ArrayList<IloIntLinExprTerm> arrayList = new ArrayList<IloIntLinExprTerm>();
            LinearTermIterator linearTermIterator = this.linearTermIterator();
            while (linearTermIterator.hasNext()) {
                iloIntLinExprTerm = (IloIntLinExprTerm)linearTermIterator.next();
                ilcIntVar = (IlcIntVar)iloIntLinExprTerm.getVar();
                int n2 = iloIntLinExprTerm.getCoef();
                if (ilcIntVar.pwb != -1) {
                    IloIntLinExprTerm iloIntLinExprTerm2 = (IloIntLinExprTerm)arrayList.get(ilcIntVar.pwb);
                    iloIntLinExprTerm2.setCoef(iloIntLinExprTerm2.getCoef() + n2);
                    continue;
                }
                ilcIntVar.pwb = arrayList.size();
                arrayList.add(new IloIntLinExprTerm(n2, ilcIntVar));
            }
            this._linearpart = arrayList;
            linearTermIterator = this.linearTermIterator();
            while (linearTermIterator.hasNext()) {
                iloIntLinExprTerm = (IloIntLinExprTerm)linearTermIterator.next();
                ilcIntVar = (IlcIntVar)iloIntLinExprTerm.getVar();
                ilcIntVar.pwb = -1;
            }
        }
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        Object object;
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloIntScalProd iloIntScalProd = iloCPModeler.scalProd(this._constant);
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            object = (IloIntLinExprTerm)linearTermIterator.next();
            iloIntScalProd.addTo(((IloIntLinExprTerm)object).getCoef(), (IloIntExpr)iloCopyManager.getCopy(((IloIntLinExprTerm)object).getVar()));
        }
        object = this.nodeIterator();
        while (((NodeIterator)object).hasNext()) {
            IloIntNodeTerm iloIntNodeTerm = (IloIntNodeTerm)((NodeIterator)object).next();
            iloIntScalProd.addTo(iloIntNodeTerm.getCoef(), (IloIntExpr)iloCopyManager.getCopy(iloIntNodeTerm.getExp()));
        }
        return iloIntScalProd;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        Object object;
        LinearTermIterator linearTermIterator = this.linearTermIterator();
        while (linearTermIterator.hasNext()) {
            object = (IloIntLinExprTerm)linearTermIterator.next();
            ((IloIntLinExprTerm)object).getVar().needCopy(check);
        }
        object = this.nodeIterator();
        while (((NodeIterator)object).hasNext()) {
            IloIntNodeTerm iloIntNodeTerm = (IloIntNodeTerm)((NodeIterator)object).next();
            iloIntNodeTerm.getExp().needCopy(check);
        }
    }

    public void addTerm(int n2, IloIntVar iloIntVar) throws IloException {
        this.addTo(n2, iloIntVar);
    }

    public void addTerm(IloIntVar iloIntVar, int n2) throws IloException {
        this.addTerm(n2, iloIntVar);
    }

    public void addTerms(int[] nArray, IloIntVar[] iloIntVarArray, int n2, int n3) throws IloException {
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.addTerm(nArray[n4], iloIntVarArray[n4]);
            ++n4;
        }
    }

    public void addTerms(IloIntVar[] iloIntVarArray, int[] nArray, int n2, int n3) throws IloException {
        this.addTerms(nArray, iloIntVarArray, n2, n3);
    }

    public void addTerms(int[] nArray, IloIntVar[] iloIntVarArray) throws IloException {
        this.addTerms(nArray, iloIntVarArray, 0, nArray.length);
    }

    public void addTerms(IloIntVar[] iloIntVarArray, int[] nArray) throws IloException {
        this.addTerms(nArray, iloIntVarArray);
    }

    public void add(IloLinearIntExpr iloLinearIntExpr) throws IloException {
        IloLinearIntExprIterator iloLinearIntExprIterator = iloLinearIntExpr.linearIterator();
        while (iloLinearIntExprIterator.hasNext()) {
            this.addTerm(iloLinearIntExprIterator.nextIntVar(), iloLinearIntExprIterator.getValue());
        }
    }

    public int getConstant() throws IloException {
        return this._constant;
    }

    public void setConstant(int n2) throws IloException {
        this._constant = n2;
    }

    public void remove(IloIntVar iloIntVar) throws IloException {
        this.setCoef((IlcIntVar)iloIntVar, 0);
    }

    public void remove(IloIntVar[] iloIntVarArray, int n2, int n3) throws IloException {
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.remove(iloIntVarArray[n4]);
            ++n4;
        }
    }

    public void remove(IloIntVar[] iloIntVarArray) throws IloException {
        this.remove(iloIntVarArray, 0, iloIntVarArray.length);
    }

    public IloLinearIntExprIterator linearIterator() {
        return new Iterator();
    }

    public class Iterator
    implements IloLinearIntExprIterator {
        int es = 0;

        protected Iterator() {
        }

        public Object getCurrent() {
            return IlcIntScalProd.this._linearpart.get(this.es);
        }

        public boolean MoveNext() {
            return ++this.es < IlcIntScalProd.this._linearpart.size();
        }

        public void Reset() {
            this.es = 0;
        }

        public boolean hasNext() {
            return this.es < IlcIntScalProd.this._linearpart.size();
        }

        public IloIntVar nextIntVar() {
            return ((IloIntLinExprTerm)IlcIntScalProd.this._linearpart.get(this.es++)).getVar();
        }

        public void setIntVar(IloIntVar iloIntVar) {
            ((IloIntLinExprTerm)IlcIntScalProd.this._linearpart.get(this.es - 1)).setVar(iloIntVar);
        }

        public Object next() {
            return this.nextIntVar();
        }

        public int getValue() {
            return ((IloIntLinExprTerm)IlcIntScalProd.this._linearpart.get(this.es - 1)).getCoef();
        }

        public void setValue(int n2) {
            ((IloIntLinExprTerm)IlcIntScalProd.this._linearpart.get(this.es - 1)).setCoef(n2);
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public class NodeIterator
    implements java.util.Iterator {
        int lo = 0;

        protected NodeIterator() {
        }

        public boolean hasNext() {
            return this.lo < IlcIntScalProd.this._nodes.size();
        }

        public Object next() {
            return (IloIntNodeTerm)IlcIntScalProd.this._nodes.get(this.lo++);
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }

    public class LinearTermIterator
    implements java.util.Iterator {
        int ih = 0;

        protected LinearTermIterator() {
        }

        public boolean hasNext() {
            return this.ih < IlcIntScalProd.this._linearpart.size();
        }

        public Object next() {
            return (IloIntLinExprTerm)IlcIntScalProd.this._linearpart.get(this.ih++);
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

