/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JOptionPane;
import ptolemy.plot.CmdLineArgException;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotBox;
import ptolemy.plot.PlotFrame;

public class PlotApplication
extends PlotFrame {
    protected static boolean _test = false;

    public PlotApplication() throws Exception {
        this((String[])null);
    }

    public PlotApplication(PlotBox plotBox, String[] stringArray) throws Exception {
        super("PlotApplication", plotBox);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this._parseArgs(stringArray);
        if (stringArray == null || stringArray.length == 0) {
            this.samplePlot();
        }
        ((Component)this).setVisible(true);
    }

    public PlotApplication(String[] stringArray) throws Exception {
        this(new Plot(), stringArray);
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "PlotApplication class\nBy: Edward A. Lee, eal@eecs.berkeley.edu and Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 3.1, Build: $Id: PlotApplication.java,v 1.23 1999/08/19 12:01:51 eal Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n\nCopyright (c) 1997-1999, The Regents of the University of California.", "About Ptolemy Plot", 1);
    }

    protected void _close() {
        System.exit(0);
    }

    protected void _help() {
        JOptionPane.showMessageDialog(this, "PlotApplication is a standalone plot  application.\n  File formats understood: Ptplot ASCII.\n  Left mouse button: Zooming.\n\n" + this._usage(), "About Ptolemy Plot", 1);
    }

    protected int _parseArgs(String[] stringArray) throws CmdLineArgException, FileNotFoundException, IOException {
        int n = 0;
        String string = "Ptolemy plot";
        int n2 = 500;
        int n3 = 300;
        while (stringArray != null && n < stringArray.length) {
            String string2;
            if ((string2 = stringArray[n++]).equals("-height")) {
                if (n > stringArray.length - 1) {
                    throw new CmdLineArgException(this._usage());
                }
                n3 = Integer.valueOf(stringArray[n++]);
                continue;
            }
            if (string2.equals("-help")) {
                System.out.println(this._usage());
                System.exit(0);
                continue;
            }
            if (string2.equals("-test")) {
                _test = true;
                continue;
            }
            if (string2.equals("-version")) {
                System.out.println("Version 3.1, Build $Id: PlotApplication.java,v 1.23 1999/08/19 12:01:51 eal Exp $");
                System.exit(0);
                continue;
            }
            if (string2.equals("-width")) {
                if (n > stringArray.length - 1) {
                    throw new CmdLineArgException("-width requires an integer argument");
                }
                n2 = Integer.valueOf(stringArray[n++]);
                continue;
            }
            if (string2.equals("")) continue;
            if (!string2.startsWith("-")) {
                InputStream inputStream;
                URL uRL;
                Serializable serializable;
                try {
                    serializable = new URL(null, string2);
                    uRL = serializable;
                    inputStream = ((URL)serializable).openStream();
                }
                catch (MalformedURLException malformedURLException) {
                    serializable = new File(string2);
                    inputStream = new FileInputStream((File)serializable);
                    File file = new File(((File)serializable).getAbsolutePath());
                    String string3 = String.valueOf(file.getParent()) + File.separator;
                    uRL = new URL("file", null, string3);
                    this._filename = string2;
                }
                this._read(uRL, inputStream);
                continue;
            }
            throw new CmdLineArgException("Unrecognized option: " + string2);
        }
        ((Component)this).setSize(n2, n3);
        this.setTitle(string);
        int n4 = n;
        return n4;
    }

    protected String _usage() {
        String[][] stringArrayArray = new String[][]{{"-height", "<pixels>"}, {"-width", "<pixels>"}};
        String[] stringArray = new String[]{"-help", "-test", "-version"};
        String string = "Usage: ptplot [ options ] [file ...]\n\nOptions that take values:\n";
        int n = 0;
        while (n < stringArrayArray.length) {
            string = String.valueOf(string) + " " + stringArrayArray[n][0] + " " + stringArrayArray[n][1] + "\n";
            ++n;
        }
        string = String.valueOf(string) + "\nBoolean flags:\n";
        n = 0;
        while (n < stringArray.length) {
            string = String.valueOf(string) + " " + stringArray[n];
            ++n;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            PlotApplication plotApplication = new PlotApplication(new Plot(), stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
        }
        if (_test) {
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            System.exit(0);
        }
    }
}

