/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import ptolemy.gui.PanelDialog;
import ptolemy.gui.Query;
import ptolemy.plot.EditablePlot;
import ptolemy.plot.PlotApplication;
import ptolemy.plot.plotml.PlotMLApplication;

public class EditablePlotMLApplication
extends PlotMLApplication {
    public EditablePlotMLApplication() throws Exception {
        this((String[])null);
    }

    public EditablePlotMLApplication(EditablePlot editablePlot, String[] stringArray) throws Exception {
        super(editablePlot, stringArray);
        editablePlot.setEditable(-1);
        MenuItem menuItem = new MenuItem("Edit Dataset");
        SelectListener selectListener = new SelectListener();
        menuItem.addActionListener(selectListener);
        this._editMenu.add(menuItem);
    }

    public EditablePlotMLApplication(String[] stringArray) throws Exception {
        this(new EditablePlot(), stringArray);
    }

    protected void _about() {
        JOptionPane.showMessageDialog(this, "EditablePlotMLApplication class\nBy: Edward A. Lee, eal@eecs.berkeley.edu and Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 3.1, Build: $Id: EditablePlotMLApplication.java,v 1.8 1999/08/20 02:15:42 cxh Exp $\n\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n\nCopyright (c) 1997-1999, The Regents of the University of California.", "About Ptolemy Plot", 1);
    }

    protected void _help() {
        JOptionPane.showMessageDialog(this, "EditablePlotMLApplication is a standalone plot  application.\n  File formats understood: PlotML and Ptplot ASCII.\n  Left mouse button: Zooming.\n  Right mouse button: Editing data (use edit menu to select a dataset).\n\n" + this._usage(), "About Ptolemy Plot", 1);
    }

    protected void _selectDataset() {
        Query query = new Query();
        int n = ((EditablePlot)this.plot).getNumDataSets();
        String[] stringArray = new String[n + 1];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2 + 1] = this.plot.getLegend(n2);
            if (stringArray[n2 + 1] == null) {
                stringArray[n2 + 1] = String.valueOf(n2);
            }
            ++n2;
        }
        stringArray[0] = "none";
        query.setTextWidth(20);
        query.addChoice("choice", "Choose a data set, then drag the right mouse button", stringArray, stringArray[0]);
        PanelDialog panelDialog = new PanelDialog((Frame)this, "Select dataset", (JPanel)query);
        String string = panelDialog.buttonPressed();
        if (string.equals("OK")) {
            int n3 = query.intValue("choice");
            if (n3 > 0) {
                ((EditablePlot)this.plot).setEditable(n3 - 1);
            } else {
                ((EditablePlot)this.plot).setEditable(-1);
            }
        }
    }

    public static void main(String[] stringArray) {
        try {
            EditablePlotMLApplication editablePlotMLApplication = new EditablePlotMLApplication(new EditablePlot(), stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
        }
        if (PlotApplication._test) {
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            System.exit(0);
        }
    }

    class SelectListener
    implements ActionListener {
        SelectListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditablePlotMLApplication.this._selectDataset();
        }
    }
}

