/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.compat;

import java.awt.Component;
import java.awt.Point;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.StringTokenizer;
import ptolemy.plot.CmdLineArgException;
import ptolemy.plot.Message;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotApplication;
import ptolemy.plot.compat.PxgraphParser;

public class PxgraphApplication
extends PlotApplication {
    private PxgraphParser _parser;

    public PxgraphApplication() throws Exception {
        this((String[])null);
    }

    public PxgraphApplication(Plot plot, String[] stringArray) throws Exception {
        super(plot, stringArray);
    }

    public PxgraphApplication(String[] stringArray) throws Exception {
        this(new Plot(), stringArray);
    }

    protected void _about() {
        Message message = new Message("               pxgraph\n        A Java Plotting Tool\n\nBy: Edward A. Lee, eal@eecs.berkeley.edu and\n    Christopher Hylands, cxh@eecs.berkeley.edu\nVersion 3.1, Build: $Id: PxgraphApplication.java,v 1.8 1999/08/19 01:42:15 cxh Exp $\n\nFor help, type 'pxgraph -help', or see \nthe class documentation in the plot.pxgraph package.\nFor more information, see\nhttp://ptolemy.eecs.berkeley.edu/java/ptplot\n");
        message.setTitle("About pxgraph");
        message.pack();
        message.show();
    }

    protected int _parseArgs(String[] stringArray) throws CmdLineArgException, FileNotFoundException, IOException {
        int n = 0;
        String string = "Ptolemy plot, pxgraph version";
        int n2 = 400;
        int n3 = 300;
        while (stringArray != null && n < stringArray.length) {
            String string2;
            if ((string2 = stringArray[n++]).equals("-help")) {
                System.out.println(this._usage());
                System.exit(0);
                continue;
            }
            if (string2.equals("-test")) {
                PlotApplication._test = true;
                continue;
            }
            if (string2.equals("-t")) {
                string = stringArray[n++];
                continue;
            }
            if (string2.equals("-v") || string2.equals("-version")) {
                System.out.println("Version 3.1, Build $Id: PxgraphApplication.java,v 1.8 1999/08/19 01:42:15 cxh Exp $");
                System.exit(0);
                continue;
            }
            if (!string2.startsWith("=")) continue;
            int n4 = 1;
            int n5 = 1;
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(1, string2.length()), "=x-+");
            if (stringTokenizer.hasMoreTokens()) {
                n2 = Integer.valueOf(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                n3 = Integer.valueOf(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                n4 = Integer.valueOf(stringTokenizer.nextToken());
                bl = true;
            }
            if (stringTokenizer.hasMoreTokens()) {
                n5 = Integer.valueOf(stringTokenizer.nextToken());
                bl = true;
            }
            if (!bl) continue;
            ((Component)this).setLocation(new Point(n4 + 1, n5 + 1));
        }
        ((Component)this).setSize(n2, n3);
        this.setTitle(string);
        int n6 = n++;
        if (this._parser == null) {
            this._parser = new PxgraphParser((Plot)this.plot);
        }
        this._parser.parseArgs(stringArray);
        return n6;
    }

    protected void _read(URL uRL, InputStream inputStream) throws IOException {
        this._parser.read(inputStream);
    }

    protected String _usage() {
        String[][] stringArrayArray = new String[][]{{"-bd", "<color>", "Border", "White", "(Unsupported)"}, {"-bg", "<color>", "BackGround", "White", ""}, {"-brb", "<base>", "BarBase", "0", "(Unsupported)"}, {"-brw", "<width>", "BarWidth", "1", ""}, {"-bw", "<size>", "BorderSize", "1", "(Unsupported)"}, {"-fg", "<color>", "Foreground", "Black", ""}, {"-gw", "<pixels>", "GridStyle", "1", "(Unsupported)"}, {"-lf", "<fontname>", "LabelFont", "helvetica-12", ""}, {"-lw", "<width>", "LineWidth", "0", "(Unsupported)"}, {"-lx", "<xl,xh>", "XLowLimit, XHighLimit", "0", ""}, {"-ly", "<yl,yh>", "YLowLimit, YHighLimit", "0", ""}, {"-o", "<output filename>", "", "/tmp/t.ps", ""}, {"-t", "<title>", "TitleText", "An X Graph", ""}, {"-tf", "<fontname>", "TitleFont", "helvetica-b-14", ""}, {"-x", "<unitName>", "XUnitText", "X", ""}, {"-y", "<unitName>", "YUnitText", "Y", ""}, {"-zg", "<color>", "ZeroColor", "Black", "(Unsupported)"}, {"-zw", "<width>", "ZeroWidth", "0", "(Unsupported)"}};
        String[][] stringArrayArray2 = new String[][]{{"-bar", "BarGraph", ""}, {"-bb", "BoundBox", "(Ignored)"}, {"-bigendian", "", ""}, {"-littleendian", "", ""}, {"-binary", "Binary", ""}, {"-impulses", "Impulses", ""}, {"-help", "", ""}, {"-lnx", "XLog", ""}, {"-lny", "YLog", ""}, {"-m", "Markers", ""}, {"-M", "StyleMarkers", ""}, {"-nl", "NoLines", ""}, {"-p", "PixelMarkers", ""}, {"-P", "LargePixel", ""}, {"-rv", "ReverseVideo", ""}, {"-test", "Test", ""}, {"-tk", "Ticks", ""}, {"-v", "Version", ""}, {"-version", "Version", ""}};
        String string = "Usage: ptplot [ options ] [=WxH+X+Y] [file ...]\n\n options that take values as second args:\n";
        int n = 0;
        while (n < stringArrayArray.length) {
            string = String.valueOf(string) + " " + stringArrayArray[n][0] + " " + stringArrayArray[n][1] + " " + stringArrayArray[n][4] + "\n";
            ++n;
        }
        string = String.valueOf(string) + "\nBoolean flags:\n";
        n = 0;
        while (n < stringArrayArray2.length) {
            string = String.valueOf(string) + " " + stringArrayArray2[n][0] + " " + stringArrayArray2[n][2] + "\n";
            ++n;
        }
        string = String.valueOf(string) + "\nThe following pxgraph features are not supported:\n * Directives in pxgraph input files\n * Xresources\n";
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            PxgraphApplication pxgraphApplication = new PxgraphApplication(new Plot(), stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (PlotApplication._test) {
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {}
            System.exit(0);
        }
    }

    public void write(OutputStream outputStream, String string) {
        this.plot.write(outputStream, string);
    }
}

