/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.network;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import uchicago.src.sim.analysis.BlockFileWriter;
import uchicago.src.sim.analysis.DataFileHeader;
import uchicago.src.sim.analysis.DataFileWriter;
import uchicago.src.sim.analysis.ExcelFileWriter;
import uchicago.src.sim.engine.SimModel;
import uchicago.src.sim.network.ASCIIFormatter;
import uchicago.src.sim.network.AdjacencyMatrix;
import uchicago.src.sim.network.DlFormatter;
import uchicago.src.sim.network.ExcelFormatter;
import uchicago.src.sim.network.NetworkConstants;
import uchicago.src.sim.network.NetworkConvertor;
import uchicago.src.sim.network.NetworkMatrixFormatter;

public class NetworkRecorder
implements NetworkConstants {
    private NetworkMatrixFormatter formatter;
    private String fileName;
    private ArrayList dataList = new ArrayList(7);
    private BlockFileWriter writer = null;
    private DataFileHeader dfHeader;

    public NetworkRecorder(int n, String string, SimModel simModel) {
        this.fileName = string;
        this.dfHeader = simModel == null ? new DataFileHeader() : new DataFileHeader(simModel);
        if (n == 0) {
            this.formatter = new DlFormatter();
            this.writer = new DataFileWriter(this.fileName, this.dfHeader);
        } else if (n == 1) {
            this.formatter = new ExcelFormatter();
            this.writer = new ExcelFileWriter(this.fileName, this.dfHeader);
        } else if (n == 3) {
            this.formatter = new ASCIIFormatter();
            this.writer = new DataFileWriter(this.fileName, this.dfHeader);
        } else {
            throw new IllegalArgumentException("Illegal file type");
        }
    }

    public void record(List list) {
        this.record(list, "");
    }

    public void record(List list, int n) {
        this.record(list, "", n);
    }

    public void record(List list, String string) {
        this.record(list, string, 2);
    }

    public void record(List list, String string, int n) {
        Vector vector = NetworkConvertor.nodesToMatrices(list, n);
        MatrixData matrixData = new MatrixData();
        matrixData.comment = string;
        for (int i = 0; i < vector.size(); ++i) {
            AdjacencyMatrix adjacencyMatrix = (AdjacencyMatrix)vector.get(i);
            if (!matrixData.matrixLabels.contains(adjacencyMatrix.getMatrixLabel())) {
                matrixData.matrixLabels.add(adjacencyMatrix.getMatrixLabel());
            }
            matrixData.matrices.add(adjacencyMatrix);
        }
        this.dataList.add(matrixData);
    }

    public void write() {
        for (int i = 0; i < this.dataList.size(); ++i) {
            MatrixData matrixData = (MatrixData)this.dataList.get(i);
            this.formatter.format(matrixData.matrixLabels, matrixData.matrices, matrixData.comment);
            String string = this.formatter.getHeader();
            this.writer.setBlockHeader(string);
            Vector vector = this.formatter.getMatrices();
            for (int j = 0; j < vector.size(); ++j) {
                this.writer.writeToFile(vector.get(j));
            }
        }
        this.dataList.clear();
    }

    public class MatrixData {
        Vector matrices = new Vector();
        Vector matrixLabels = new Vector();
        String comment = "";
    }
}

