/*
 * Decompiled with CFR 0.152.
 */
package uchicago.src.sim.analysis.plot;

import java.awt.Color;
import java.awt.Graphics;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Vector;
import ptolemy.plot.EPSGraphics;
import ptolemy.plot.PlotPoint;
import uchicago.src.sim.analysis.plot.RepastPlotBox;
import uchicago.src.sim.analysis.plot.ZoomListener;

public class RepastPlot
extends RepastPlotBox {
    protected int _currentdataset = -1;
    protected Vector _points = new Vector();
    protected int _marks;
    protected boolean _painted = false;
    private int _pointsPersistence = 0;
    private boolean _bars = false;
    private double _barwidth = 0.5;
    private double _baroffset = 0.05;
    private boolean _connected = true;
    private boolean _impulses = false;
    private int _maxdataset = -1;
    private boolean _reusedatasets = false;
    private boolean _firstinset = true;
    private boolean _sawfirstdataset = false;
    private int _radius = 3;
    private int _diameter = 6;
    private Vector _prevx = new Vector();
    private Vector _prevy = new Vector();
    private static final int _ERRORBAR_LEG_LENGTH = 5;
    private boolean _xyInvalid = false;
    private boolean _showing = false;
    private Vector _formats = new Vector();
    private boolean drawOnPlotPoint = true;

    public RepastPlot(ZoomListener zoomListener) {
        super(zoomListener);
    }

    public void addLegend(int n, String string) {
        this._checkDatasetIndex(n);
        super.addLegend(n, string);
    }

    public void addLegend(int n, String string, Color color) {
        this._checkDatasetIndex(n);
        super.addLegend(n, string, color);
    }

    public void addLegend(int n, String string, int n2) {
        this._checkDatasetIndex(n);
        super.addLegend(n, string, n2);
    }

    public void addLegend(int n, String string, Color color, int n2) {
        this._checkDatasetIndex(n);
        super.addLegend(n, string, color, n2);
    }

    public synchronized void addPoint(int n, double d, double d2, boolean bl) {
        if (this._xlog) {
            if (d <= 0.0) {
                System.err.println("Can't plot non-positive X values when the logarithmic X axis value is specified: " + d);
                return;
            }
            d = Math.log(d) * _LOG10SCALE;
        }
        if (this._ylog) {
            if (d2 <= 0.0) {
                System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: " + d2);
                return;
            }
            d2 = Math.log(d2) * _LOG10SCALE;
        }
        this._addPoint(n, d, d2, 0.0, 0.0, bl, false);
    }

    public synchronized void addPointWithErrorBars(int n, double d, double d2, double d3, double d4, boolean bl) {
        if (this._xlog) {
            if (d <= 0.0) {
                System.err.println("Can't plot non-positive X values when the logarithmic X axis value is specified: " + d);
                return;
            }
            d = Math.log(d) * _LOG10SCALE;
        }
        if (this._ylog) {
            if (d2 <= 0.0 || d3 <= 0.0 || d4 <= 0.0) {
                System.err.println("Can't plot non-positive Y values when the logarithmic Y axis value is specified: " + d2);
                return;
            }
            d2 = Math.log(d2) * _LOG10SCALE;
            d3 = Math.log(d3) * _LOG10SCALE;
            d4 = Math.log(d4) * _LOG10SCALE;
        }
        this._addPoint(n, d, d2, d3, d4, bl, true);
    }

    public synchronized void clear(boolean bl) {
        super.clear(bl);
        this._currentdataset = -1;
        this._points = new Vector();
        this._prevx = new Vector();
        this._prevy = new Vector();
        this._painted = false;
        this._maxdataset = -1;
        this._firstinset = true;
        this._sawfirstdataset = false;
        this._xyInvalid = false;
        this._showing = false;
        if (bl) {
            this._formats = new Vector();
            this._marks = 0;
            this._pointsPersistence = 0;
            this._bars = false;
            this._barwidth = 0.5;
            this._baroffset = 0.05;
            this._connected = true;
            this._impulses = false;
            this._reusedatasets = false;
        }
    }

    public synchronized void clear(int n) {
        this._checkDatasetIndex(n);
        Vector vector = (Vector)this._points.elementAt(n);
        vector.clear();
        this.repaint();
    }

    public synchronized void erasePoint(int n, int n2) {
        PlotPoint plotPoint;
        Vector vector;
        this._checkDatasetIndex(n);
        if (this.isShowing()) {
            this._erasePoint(this.getGraphics(), n, n2);
        }
        if ((vector = (Vector)this._points.elementAt(n)) != null && (plotPoint = (PlotPoint)vector.elementAt(n2)) != null) {
            if (plotPoint.x == this._xBottom || plotPoint.x == this._xTop || plotPoint.y == this._yBottom || plotPoint.y == this._yTop) {
                this._xyInvalid = true;
            }
            vector.removeElementAt(n2);
        }
    }

    public synchronized void fillPlot() {
        if (this._xyInvalid) {
            this._xBottom = Double.MAX_VALUE;
            this._xTop = -4.9E-324;
            this._yBottom = Double.MAX_VALUE;
            this._yTop = -4.9E-324;
            for (int i = 0; i < this._points.size(); ++i) {
                Vector vector = (Vector)this._points.elementAt(i);
                for (int j = 0; j < vector.size(); ++j) {
                    PlotPoint plotPoint = (PlotPoint)vector.elementAt(j);
                    if (plotPoint.x < this._xBottom) {
                        this._xBottom = plotPoint.x;
                    }
                    if (plotPoint.x > this._xTop) {
                        this._xTop = plotPoint.x;
                    }
                    if (plotPoint.y < this._yBottom) {
                        this._yBottom = plotPoint.y;
                    }
                    if (!(plotPoint.y > this._yTop)) continue;
                    this._yTop = plotPoint.y;
                }
            }
            if (this._bars) {
                this._xTop += (double)(this._points.size() - 2) * this._baroffset + this._barwidth;
            }
        }
        this._xyInvalid = false;
        if (this._bars) {
            if (this._yBottom > 0.0) {
                this._yBottom = 0.0;
            }
            if (this._yTop < 0.0) {
                this._yTop = 0.0;
            }
        }
        super.fillPlot();
    }

    public boolean getConnected() {
        return this._connected;
    }

    public boolean getImpulses() {
        return this._impulses;
    }

    public String getMarksStyle() {
        if (this._marks == 0) {
            return "none";
        }
        if (this._marks == 1) {
            return "points";
        }
        if (this._marks == 2) {
            return "dots";
        }
        return "various";
    }

    public int getMaxDataSets() {
        return Integer.MAX_VALUE;
    }

    public int getNumDataSets() {
        return this._points.size();
    }

    public void parseFile(String string, URL uRL) {
        this._firstinset = true;
        this._sawfirstdataset = false;
        super.parseFile(string, uRL);
    }

    public void read(InputStream inputStream) throws IOException {
        super.read(inputStream);
        this._firstinset = true;
        this._sawfirstdataset = false;
    }

    public void samplePlot() {
        this.clear(true);
        this.setTitle("Sample plot");
        this.setYRange(-4.0, 4.0);
        this.setXRange(0.0, 100.0);
        this.setXLabel("time");
        this.setYLabel("value");
        this.addYTick("-PI", -Math.PI);
        this.addYTick("-PI/2", -1.5707963267948966);
        this.addYTick("0", 0.0);
        this.addYTick("PI/2", 1.5707963267948966);
        this.addYTick("PI", Math.PI);
        this.setMarksStyle("none");
        this.setImpulses(true);
        boolean bl = true;
        for (int i = 0; i <= 100; ++i) {
            this.addPoint(0, i, 5.0 * Math.cos(Math.PI * (double)i / 20.0), !bl);
            this.addPoint(1, i, 4.5 * Math.cos(Math.PI * (double)i / 25.0), !bl);
            this.addPoint(2, i, 4.0 * Math.cos(Math.PI * (double)i / 30.0), !bl);
            this.addPoint(3, i, 3.5 * Math.cos(Math.PI * (double)i / 35.0), !bl);
            this.addPoint(4, i, 3.0 * Math.cos(Math.PI * (double)i / 40.0), !bl);
            this.addPoint(5, i, 2.5 * Math.cos(Math.PI * (double)i / 45.0), !bl);
            this.addPoint(6, i, 2.0 * Math.cos(Math.PI * (double)i / 50.0), !bl);
            this.addPoint(7, i, 1.5 * Math.cos(Math.PI * (double)i / 55.0), !bl);
            this.addPoint(8, i, 1.0 * Math.cos(Math.PI * (double)i / 60.0), !bl);
            this.addPoint(9, i, 0.5 * Math.cos(Math.PI * (double)i / 65.0), !bl);
            bl = false;
        }
        this.repaint();
    }

    public void setBars(boolean bl) {
        this._bars = bl;
    }

    public void setBars(double d, double d2) {
        this._barwidth = d;
        this._baroffset = d2;
        this._bars = true;
    }

    public void setConnected(boolean bl) {
        this._connected = bl;
    }

    public void setConnected(boolean bl, int n) {
        this._checkDatasetIndex(n);
        Format format = (Format)this._formats.elementAt(n);
        format.connected = bl;
        format.connectedUseDefault = false;
    }

    public void setImpulses(boolean bl) {
        this._impulses = bl;
    }

    public void setImpulses(boolean bl, int n) {
        this._checkDatasetIndex(n);
        Format format = (Format)this._formats.elementAt(n);
        format.impulses = bl;
        format.impulsesUseDefault = false;
    }

    public void setMarksStyle(String string) {
        if (string.equalsIgnoreCase("none")) {
            this._marks = 0;
        } else if (string.equalsIgnoreCase("points")) {
            this._marks = 1;
        } else if (string.equalsIgnoreCase("dots")) {
            this._marks = 2;
        } else if (string.equalsIgnoreCase("various")) {
            this._marks = 3;
        }
    }

    public void setMarksStyle(String string, int n) {
        this._checkDatasetIndex(n);
        Format format = (Format)this._formats.elementAt(n);
        if (string.equalsIgnoreCase("none")) {
            format.marks = 0;
        } else if (string.equalsIgnoreCase("points")) {
            format.marks = 1;
        } else if (string.equalsIgnoreCase("dots")) {
            format.marks = 2;
        } else if (string.equalsIgnoreCase("various")) {
            format.marks = 3;
        }
        format.marksUseDefault = false;
    }

    public void setNumSets(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Number of data sets (" + n + ") must be greater than 0.");
        }
        this._currentdataset = -1;
        this._points.removeAllElements();
        this._formats.removeAllElements();
        this._prevx.removeAllElements();
        this._prevy.removeAllElements();
        for (int i = 0; i < n; ++i) {
            this._points.addElement(new Vector());
            this._formats.addElement(new Format());
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
        }
    }

    public void setPointsPersistence(int n) {
        this._pointsPersistence = n;
    }

    public void setReuseDatasets(boolean bl) {
        this._reusedatasets = bl;
    }

    public void setSweepsPersistence(int n) {
    }

    protected void _checkDatasetIndex(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Plot._checkDatasetIndex: Cannot give a negative number for the data set index.");
        }
        while (n >= this._points.size()) {
            this._points.addElement(new Vector());
            this._formats.addElement(new Format());
            this._prevx.addElement(new Long(0L));
            this._prevy.addElement(new Long(0L));
        }
    }

    protected void _drawBar(Graphics graphics, int n, long l, long l2, boolean bl) {
        if (bl) {
            if (l2 < (long)this._uly) {
                l2 = this._uly;
            }
            if (l2 > (long)this._lry) {
                l2 = this._lry;
            }
        }
        if (l2 <= (long)this._lry && l <= (long)this._lrx && l >= (long)this._ulx) {
            long l3;
            int n2 = (int)((double)l - this._barwidth * this._xscale / 2.0 + (double)n * this._baroffset * this._xscale);
            int n3 = (int)((double)n2 + this._barwidth * this._xscale);
            if (n2 < this._ulx) {
                n2 = this._ulx;
            }
            if (n3 > this._lrx) {
                n3 = this._lrx;
            }
            if (n2 >= n3) {
                n3 = n2 + 1;
            }
            if ((long)this._lry < (l3 = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale))) {
                l3 = this._lry;
            }
            if ((long)this._uly > l3) {
                l3 = this._uly;
            }
            if (this._yMin >= 0.0 || l2 <= l3) {
                graphics.fillRect(n2, (int)l2, n3 - n2, (int)(l3 - l2));
            } else {
                graphics.fillRect(n2, (int)l3, n3 - n2, (int)(l2 - l3));
            }
        }
    }

    protected void _drawErrorBar(Graphics graphics, int n, long l, long l2, long l3, boolean bl) {
        this._drawLine(graphics, n, l - 5L, l3, l + 5L, l3, bl);
        this._drawLine(graphics, n, l, l2, l, l3, bl);
        this._drawLine(graphics, n, l - 5L, l2, l + 5L, l2, bl);
    }

    protected void _drawImpulse(Graphics graphics, long l, long l2, boolean bl) {
        if (bl) {
            if (l2 < (long)this._uly) {
                l2 = this._uly;
            }
            if (l2 > (long)this._lry) {
                l2 = this._lry;
            }
        }
        if (l2 <= (long)this._lry && l <= (long)this._lrx && l >= (long)this._ulx) {
            double d = (long)this._lry - (long)((0.0 - this._yMin) * this._yscale);
            if ((double)this._lry < d) {
                d = this._lry;
            }
            if ((double)this._uly > d) {
                d = this._uly;
            }
            graphics.drawLine((int)l, (int)l2, (int)l, (int)d);
        }
    }

    protected void _drawLine(Graphics graphics, int n, long l, long l2, long l3, long l4, boolean bl) {
        if (bl) {
            if (!(l3 <= (long)this._ulx && l <= (long)this._ulx || l3 >= (long)this._lrx && l >= (long)this._lrx || l4 <= (long)this._uly && l2 <= (long)this._uly || l4 >= (long)this._lry && l2 >= (long)this._lry)) {
                if (l != l3) {
                    if (l3 < (long)this._ulx) {
                        l4 = (int)(l4 + (l2 - l4) * ((long)this._ulx - l3) / (l - l3));
                        l3 = this._ulx;
                    } else if (l3 > (long)this._lrx) {
                        l4 = (int)(l4 + (l2 - l4) * ((long)this._lrx - l3) / (l - l3));
                        l3 = this._lrx;
                    }
                }
                if (l2 != l4) {
                    if (l4 < (long)this._uly) {
                        l3 = (int)(l3 + (l - l3) * ((long)this._uly - l4) / (l2 - l4));
                        l4 = this._uly;
                    } else if (l4 > (long)this._lry) {
                        l3 = (int)(l3 + (l - l3) * ((long)this._lry - l4) / (l2 - l4));
                        l4 = this._lry;
                    }
                }
                if (l != l3) {
                    if (l < (long)this._ulx) {
                        l2 = (int)(l2 + (l4 - l2) * ((long)this._ulx - l) / (l3 - l));
                        l = this._ulx;
                    } else if (l > (long)this._lrx) {
                        l2 = (int)(l2 + (l4 - l2) * ((long)this._lrx - l) / (l3 - l));
                        l = this._lrx;
                    }
                }
                if (l2 != l4) {
                    if (l2 < (long)this._uly) {
                        l = (int)(l + (l3 - l) * ((long)this._uly - l2) / (l4 - l2));
                        l2 = this._uly;
                    } else if (l2 > (long)this._lry) {
                        l = (int)(l + (l3 - l) * ((long)this._lry - l2) / (l4 - l2));
                        l2 = this._lry;
                    }
                }
            }
            if (l3 >= (long)this._ulx && l3 <= (long)this._lrx && l4 >= (long)this._uly && l4 <= (long)this._lry && l >= (long)this._ulx && l <= (long)this._lrx && l2 >= (long)this._uly && l2 <= (long)this._lry) {
                graphics.drawLine((int)l, (int)l2, (int)l3, (int)l4);
            }
        } else {
            graphics.drawLine((int)l, (int)l2, (int)l3, (int)l4);
        }
    }

    protected synchronized void _drawPlot(Graphics graphics, boolean bl) {
        super._drawPlot(graphics, bl);
        this._showing = graphics != null;
        for (int i = this._points.size() - 1; i >= 0; --i) {
            Vector vector = (Vector)this._points.elementAt(i);
            for (int j = 0; j < vector.size(); ++j) {
                this._drawPlotPoint(graphics, i, j);
            }
        }
        this._painted = true;
        this.notifyAll();
    }

    protected void _drawPoint(Graphics graphics, int n, long l, long l2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = l2 <= (long)this._lry && l2 >= (long)this._uly && l <= (long)this._lrx && l >= (long)this._ulx;
        if (!bl || bl2) {
            int n2 = (int)l;
            int n3 = (int)l2;
            int n4 = this.dsMarkMap.get(n);
            if (!bl2 && n4 != 3 && this._isConnected(n) && graphics instanceof EPSGraphics) {
                graphics.drawLine(n2 - 6, n3, n2 + 6, n3);
            } else {
                switch (n4) {
                    case 0: {
                        graphics.fillOval(n2 - this._radius, n3 - this._radius, this._diameter, this._diameter);
                        break;
                    }
                    case 1: {
                        graphics.drawLine(n2 - this._radius, n3 - this._radius, n2 + this._radius, n3 + this._radius);
                        graphics.drawLine(n2 + this._radius, n3 - this._radius, n2 - this._radius, n3 + this._radius);
                        break;
                    }
                    case 2: {
                        graphics.drawRect(n2 - this._radius, n3 - this._radius, this._diameter, this._diameter);
                        break;
                    }
                    case 3: {
                        int[] nArray = new int[4];
                        int[] nArray2 = new int[4];
                        nArray[0] = n2;
                        nArray2[0] = n3 - this._radius;
                        nArray[1] = n2 + this._radius;
                        nArray2[1] = n3 + this._radius;
                        nArray[2] = n2 - this._radius;
                        nArray2[2] = n3 + this._radius;
                        nArray[3] = n2;
                        nArray2[3] = n3 - this._radius;
                        graphics.fillPolygon(nArray, nArray2, 4);
                        break;
                    }
                    case 4: {
                        int[] nArray = new int[5];
                        int[] nArray3 = new int[5];
                        nArray[0] = n2;
                        nArray3[0] = n3 - this._radius;
                        nArray[1] = n2 + this._radius;
                        nArray3[1] = n3;
                        nArray[2] = n2;
                        nArray3[2] = n3 + this._radius;
                        nArray[3] = n2 - this._radius;
                        nArray3[3] = n3;
                        nArray[4] = n2;
                        nArray3[4] = n3 - this._radius;
                        graphics.drawPolygon(nArray, nArray3, 5);
                        break;
                    }
                    case 5: {
                        graphics.drawOval(n2 - this._radius, n3 - this._radius, this._diameter, this._diameter);
                        break;
                    }
                    case 6: {
                        graphics.drawLine(n2, n3 - this._radius, n2, n3 + this._radius);
                        graphics.drawLine(n2 - this._radius, n3, n2 + this._radius, n3);
                        break;
                    }
                    case 7: {
                        graphics.fillRect(n2 - this._radius, n3 - this._radius, this._diameter, this._diameter);
                        break;
                    }
                    case 8: {
                        int[] nArray = new int[4];
                        int[] nArray4 = new int[4];
                        nArray[0] = n2;
                        nArray4[0] = n3 - this._radius;
                        nArray[1] = n2 + this._radius;
                        nArray4[1] = n3 + this._radius;
                        nArray[2] = n2 - this._radius;
                        nArray4[2] = n3 + this._radius;
                        nArray[3] = n2;
                        nArray4[3] = n3 - this._radius;
                        graphics.drawPolygon(nArray, nArray4, 4);
                        break;
                    }
                    case 9: {
                        int[] nArray = new int[5];
                        int[] nArray5 = new int[5];
                        nArray[0] = n2;
                        nArray5[0] = n3 - this._radius;
                        nArray[1] = n2 + this._radius;
                        nArray5[1] = n3;
                        nArray[2] = n2;
                        nArray5[2] = n3 + this._radius;
                        nArray[3] = n2 - this._radius;
                        nArray5[3] = n3;
                        nArray[4] = n2;
                        nArray5[4] = n3 - this._radius;
                        graphics.fillPolygon(nArray, nArray5, 5);
                    }
                }
            }
        }
    }

    protected boolean _parseLine(String string) {
        boolean bl = false;
        if (this._isConnected(this._currentdataset)) {
            bl = true;
        }
        if (super._parseLine(string)) {
            return true;
        }
        String string2 = new String(string.toLowerCase());
        if (string2.startsWith("marks:")) {
            String string3 = string.substring(6).trim();
            if (this._sawfirstdataset) {
                this.setMarksStyle(string3, this._currentdataset);
            } else {
                this.setMarksStyle(string3);
            }
            return true;
        }
        if (string2.startsWith("numsets:")) {
            return true;
        }
        if (string2.startsWith("reusedatasets:")) {
            if (string2.indexOf("off", 16) >= 0) {
                this.setReuseDatasets(false);
            } else {
                this.setReuseDatasets(true);
            }
            return true;
        }
        if (string2.startsWith("dataset:")) {
            String string4;
            if (this._reusedatasets && string2.length() > 0) {
                string4 = string.substring(8).trim();
                this._currentdataset = -1;
                for (int i = 0; i <= this._maxdataset; ++i) {
                    if (this.getLegend(i).compareTo(string4) != 0) continue;
                    this._currentdataset = i;
                }
                if (this._currentdataset != -1) {
                    return true;
                }
                this._currentdataset = this._maxdataset;
            }
            this._firstinset = true;
            this._sawfirstdataset = true;
            ++this._currentdataset;
            if (string2.length() > 0 && (string4 = string.substring(8).trim()) != null && string4.length() > 0) {
                this.addLegend(this._currentdataset, string4);
            }
            this._maxdataset = this._currentdataset;
            return true;
        }
        if (string2.startsWith("lines:")) {
            if (string2.indexOf("off", 6) >= 0) {
                this.setConnected(false);
            } else {
                this.setConnected(true);
            }
            return true;
        }
        if (string2.startsWith("impulses:")) {
            if (this._sawfirstdataset) {
                if (string2.indexOf("off", 9) >= 0) {
                    this.setImpulses(false, this._currentdataset);
                } else {
                    this.setImpulses(true, this._currentdataset);
                }
            } else if (string2.indexOf("off", 9) >= 0) {
                this.setImpulses(false);
            } else {
                this.setImpulses(true);
            }
            return true;
        }
        if (string2.startsWith("bars:")) {
            if (string2.indexOf("off", 5) >= 0) {
                this.setBars(false);
            } else {
                String string5;
                this.setBars(true);
                int n = string.indexOf(",", 5);
                String string6 = null;
                if (n > 0) {
                    string5 = string.substring(5, n).trim();
                    string6 = string.substring(n + 1).trim();
                } else {
                    string5 = string.substring(5).trim();
                }
                try {
                    Double d = new Double(string5);
                    double d2 = this._baroffset;
                    if (string6 != null) {
                        d2 = new Double(string6);
                    }
                    this.setBars(d, d2);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return true;
        }
        if (string.startsWith("move:")) {
            bl = false;
            string = string.substring(5, string.length()).trim();
        } else if (string.startsWith("move")) {
            bl = false;
            string = string.substring(4, string.length()).trim();
        } else if (string.startsWith("draw:")) {
            string = string.substring(5, string.length()).trim();
        } else if (string.startsWith("draw")) {
            string = string.substring(4, string.length()).trim();
        }
        string = string.trim();
        int n = string.indexOf(",");
        if (n == -1) {
            n = string.indexOf(" ");
        }
        if (n == -1) {
            n = string.indexOf("\t");
        }
        if (n > 0) {
            String string7 = string.substring(0, n).trim();
            String string8 = string.substring(n + 1).trim();
            int n2 = string8.indexOf(",");
            if (n2 == -1) {
                n2 = string8.indexOf(" ");
            }
            if (n2 == -1) {
                n2 = string8.indexOf("\t");
            }
            if (n2 > 0) {
                string = string8.substring(n2 + 1).trim();
                string8 = string8.substring(0, n2).trim();
            }
            try {
                Double d = new Double(string7);
                Double d3 = new Double(string8);
                if (n2 > 0) {
                    int n3 = string.indexOf(",");
                    if (n3 == -1) {
                        n3 = string.indexOf(" ");
                    }
                    if (n3 == -1) {
                        n2 = string.indexOf("\t");
                    }
                    if (n3 > 0) {
                        String string9 = string.substring(0, n3).trim();
                        String string10 = string.substring(n3 + 1).trim();
                        Double d4 = new Double(string9);
                        Double d5 = new Double(string10);
                        bl = this._addLegendIfNecessary(bl);
                        this.addPointWithErrorBars(this._currentdataset, d, d3, d4, d5, bl);
                        return true;
                    }
                    bl = this._addLegendIfNecessary(bl);
                    this.addPoint(this._currentdataset, d, d3, bl);
                    return true;
                }
                bl = this._addLegendIfNecessary(bl);
                this.addPoint(this._currentdataset, d, d3, bl);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void _write(PrintWriter printWriter) {
        super._write(printWriter);
        if (this._reusedatasets) {
            printWriter.println("<reuseDatasets/>");
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this._connected) {
            stringBuffer.append(" connected=\"no\"");
        }
        switch (this._marks) {
            case 1: {
                stringBuffer.append(" marks=\"points\"");
                break;
            }
            case 2: {
                stringBuffer.append(" marks=\"dots\"");
                break;
            }
            case 3: {
                stringBuffer.append(" marks=\"various\"");
            }
        }
        if (this._impulses) {
            stringBuffer.append(" stems=\"yes\"");
        }
        if (stringBuffer.length() > 0) {
            printWriter.println("<default" + stringBuffer.toString() + "/>");
        }
        if (this._bars) {
            printWriter.println("<barGraph width=\"" + this._barwidth + "\" offset=\"" + this._baroffset + "\"/>");
        }
        for (int i = 0; i < this._points.size(); ++i) {
            String string;
            StringBuffer stringBuffer2 = new StringBuffer();
            Format format = (Format)this._formats.elementAt(i);
            if (!format.connectedUseDefault) {
                if (this._isConnected(i)) {
                    stringBuffer2.append(" connected=\"yes\"");
                } else {
                    stringBuffer2.append(" connected=\"no\"");
                }
            }
            if (!format.impulsesUseDefault) {
                if (format.impulses) {
                    stringBuffer2.append(" stems=\"yes\"");
                } else {
                    printWriter.println(" stems=\"no\"");
                }
            }
            if (!format.marksUseDefault) {
                switch (format.marks) {
                    case 0: {
                        stringBuffer2.append(" marks=\"none\"");
                    }
                    case 1: {
                        stringBuffer2.append(" marks=\"points\"");
                    }
                    case 2: {
                        stringBuffer2.append(" marks=\"dots\"");
                    }
                    case 3: {
                        stringBuffer2.append(" marks=\"various\"");
                    }
                }
            }
            if ((string = this.getLegend(i)) != null) {
                stringBuffer2.append(" name=\"" + this.getLegend(i) + "\"");
            }
            printWriter.println("<dataset" + stringBuffer2.toString() + ">");
            Vector vector = (Vector)this._points.elementAt(i);
            for (int j = 0; j < vector.size(); ++j) {
                PlotPoint plotPoint = (PlotPoint)vector.elementAt(j);
                if (!plotPoint.connected) {
                    printWriter.print("<m ");
                } else {
                    printWriter.print("<p ");
                }
                printWriter.print("x=\"" + plotPoint.x + "\" y=\"" + plotPoint.y + "\"");
                if (plotPoint.errorBar) {
                    printWriter.print(" lowErrorBar=\"" + plotPoint.yLowEB + "\" highErrorBar=\"" + plotPoint.yHighEB + "\"");
                }
                printWriter.println("/>");
            }
            printWriter.println("</dataset>");
        }
    }

    protected void _writeOldSyntax(PrintWriter printWriter) {
        super._write(printWriter);
        if (this._reusedatasets) {
            printWriter.println("ReuseDatasets: on");
        }
        if (!this._connected) {
            printWriter.println("Lines: off");
        }
        if (this._bars) {
            printWriter.println("Bars: " + this._barwidth + ", " + this._baroffset);
        }
        if (this._impulses) {
            printWriter.println("Impulses: on");
        }
        switch (this._marks) {
            case 1: {
                printWriter.println("Marks: points");
            }
            case 2: {
                printWriter.println("Marks: dots");
            }
            case 3: {
                printWriter.println("Marks: various");
            }
        }
        for (int i = 0; i < this._points.size(); ++i) {
            String string = this.getLegend(i);
            if (string != null) {
                printWriter.println("DataSet: " + this.getLegend(i));
            } else {
                printWriter.println("DataSet:");
            }
            Format format = (Format)this._formats.elementAt(i);
            if (!format.impulsesUseDefault) {
                if (format.impulses) {
                    printWriter.println("Impulses: on");
                } else {
                    printWriter.println("Impulses: off");
                }
            }
            if (!format.marksUseDefault) {
                switch (format.marks) {
                    case 0: {
                        printWriter.println("Marks: none");
                    }
                    case 1: {
                        printWriter.println("Marks: points");
                    }
                    case 2: {
                        printWriter.println("Marks: dots");
                    }
                    case 3: {
                        printWriter.println("Marks: various");
                    }
                }
            }
            Vector vector = (Vector)this._points.elementAt(i);
            for (int j = 0; j < vector.size(); ++j) {
                PlotPoint plotPoint = (PlotPoint)vector.elementAt(j);
                if (!plotPoint.connected) {
                    printWriter.print("move: ");
                }
                if (plotPoint.errorBar) {
                    printWriter.println(plotPoint.x + ", " + plotPoint.y + ", " + plotPoint.yLowEB + ", " + plotPoint.yHighEB);
                    continue;
                }
                printWriter.println(plotPoint.x + ", " + plotPoint.y);
            }
        }
    }

    private boolean _addLegendIfNecessary(boolean bl) {
        if (!(this._sawfirstdataset && this._currentdataset >= 0 || this._reusedatasets)) {
            this._sawfirstdataset = true;
            ++this._currentdataset;
        }
        if (!this._sawfirstdataset && this.getLegend(this._currentdataset) == null) {
            this._firstinset = true;
            this._sawfirstdataset = true;
            this.addLegend(this._currentdataset, new String("Set " + this._currentdataset));
        }
        if (this._firstinset && !this._reusedatasets) {
            bl = false;
            this._firstinset = false;
        }
        return bl;
    }

    private synchronized void _addPoint(int n, double d, double d2, double d3, double d4, boolean bl, boolean bl2) {
        Graphics graphics;
        Vector vector;
        int n2;
        this._checkDatasetIndex(n);
        if (this._wrap && this._xRangeGiven) {
            double d5 = this._xhighgiven - this._xlowgiven;
            if (d < this._xlowgiven) {
                d += d5 * Math.floor(1.0 + (this._xlowgiven - d) / d5);
            } else if (d > this._xhighgiven && (d -= d5 * Math.floor(1.0 + (d - this._xhighgiven) / d5)) == this._xlowgiven) {
                d = this._xhighgiven;
            }
        }
        if (d < this._xBottom) {
            this._xBottom = d;
        }
        if (d > this._xTop) {
            this._xTop = d;
            if (this._bars) {
                this._xTop += (double)(this._points.size() - 2) * this._baroffset + this._barwidth;
            }
        }
        if (d2 < this._yBottom) {
            this._yBottom = d2;
        }
        if (d2 > this._yTop) {
            this._yTop = d2;
        }
        PlotPoint plotPoint = new PlotPoint();
        plotPoint.x = d;
        plotPoint.y = d2;
        boolean bl3 = plotPoint.connected = bl && this._isConnected(n);
        if (bl2) {
            if (d3 < this._yBottom) {
                this._yBottom = d3;
            }
            if (d3 > this._yTop) {
                this._yTop = d3;
            }
            if (d4 < this._yBottom) {
                this._yBottom = d4;
            }
            if (d4 > this._yTop) {
                this._yTop = d4;
            }
            plotPoint.yLowEB = d3;
            plotPoint.yHighEB = d4;
            plotPoint.errorBar = true;
        }
        if ((n2 = (vector = (Vector)this._points.elementAt(n)).size()) == 0) {
            plotPoint.connected = false;
        } else if (this._wrap && this._xRangeGiven) {
            graphics = (PlotPoint)vector.elementAt(n2 - 1);
            if (((PlotPoint)graphics).x > d) {
                plotPoint.connected = false;
            }
        }
        vector.addElement(plotPoint);
        if (this._pointsPersistence > 0 && n2 > this._pointsPersistence) {
            this.erasePoint(n, 0);
        }
        if ((graphics = this.getGraphics()) != null && this._showing && this.drawOnPlotPoint) {
            this._drawPlotPoint(graphics, n, vector.size() - 1);
        }
        if (this._wrap && this._xRangeGiven && d == this._xhighgiven) {
            this._addPoint(n, this._xlowgiven, d2, d3, d4, false, bl2);
        }
    }

    private synchronized void _drawPlotPoint(Graphics graphics, int n, int n2) {
        if (this._pointsPersistence > 0) {
            graphics.setXORMode(this._background);
        }
        if (this._usecolor) {
            graphics.setColor((Color)this.dsColorMap.get(n));
        } else {
            graphics.setColor(this._foreground);
        }
        Vector vector = (Vector)this._points.elementAt(n);
        PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
        long l = (long)this._lry - (long)((plotPoint.y - this._yMin) * this._yscale);
        long l2 = (long)this._ulx + (long)((plotPoint.x - this._xMin) * this._xscale);
        long l3 = (Long)this._prevx.elementAt(n);
        long l4 = (Long)this._prevy.elementAt(n);
        if (plotPoint.connected) {
            this._drawLine(graphics, n, l2, l, l3, l4, true);
        }
        this._prevx.setElementAt(new Long(l2), n);
        this._prevy.setElementAt(new Long(l), n);
        Format format = (Format)this._formats.elementAt(n);
        if (format.impulsesUseDefault) {
            if (this._impulses) {
                this._drawImpulse(graphics, l2, l, true);
            }
        } else if (format.impulses) {
            this._drawImpulse(graphics, l2, l, true);
        }
        int n3 = this._marks;
        if (!format.marksUseDefault) {
            n3 = format.marks;
        }
        if (n3 != 0) {
            this._drawPoint(graphics, n, l2, l, true);
        }
        if (this._bars) {
            this._drawBar(graphics, n, l2, l, true);
        }
        if (plotPoint.errorBar) {
            this._drawErrorBar(graphics, n, l2, (long)this._lry - (long)((plotPoint.yLowEB - this._yMin) * this._yscale), (long)this._lry - (long)((plotPoint.yHighEB - this._yMin) * this._yscale), true);
        }
        graphics.setColor(this._foreground);
        if (this._pointsPersistence > 0) {
            graphics.setPaintMode();
        }
    }

    private synchronized void _erasePoint(Graphics graphics, int n, int n2) {
        int n3;
        Format format;
        if (this._pointsPersistence > 0) {
            graphics.setXORMode(this._background);
        }
        if (this._usecolor) {
            int n4 = n % _colors.length;
            graphics.setColor(_colors[n4]);
        } else {
            graphics.setColor(this._foreground);
        }
        Vector vector = (Vector)this._points.elementAt(n);
        PlotPoint plotPoint = (PlotPoint)vector.elementAt(n2);
        long l = (long)this._lry - (long)((plotPoint.y - this._yMin) * this._yscale);
        long l2 = (long)this._ulx + (long)((plotPoint.x - this._xMin) * this._xscale);
        if (n2 < vector.size() - 1) {
            format = (PlotPoint)vector.elementAt(n2 + 1);
            n3 = this._ulx + (int)((((PlotPoint)format).x - this._xMin) * this._xscale);
            int n5 = this._lry - (int)((((PlotPoint)format).y - this._yMin) * this._yscale);
            if (((PlotPoint)format).connected) {
                this._drawLine(graphics, n, n3, n5, l2, l, true);
            }
            ((PlotPoint)format).connected = false;
        }
        format = (Format)this._formats.elementAt(n);
        if (format.impulsesUseDefault) {
            if (this._impulses) {
                this._drawImpulse(graphics, l2, l, true);
            }
        } else if (format.impulses) {
            this._drawImpulse(graphics, l2, l, true);
        }
        n3 = this._marks;
        if (!format.marksUseDefault) {
            n3 = format.marks;
        }
        if (n3 != 0) {
            this._drawPoint(graphics, n, l2, l, true);
        }
        if (this._bars) {
            this._drawBar(graphics, n, l2, l, true);
        }
        if (plotPoint.errorBar) {
            this._drawErrorBar(graphics, n, l2, (long)this._lry - (long)((plotPoint.yLowEB - this._yMin) * this._yscale), (long)this._lry - (long)((plotPoint.yHighEB - this._yMin) * this._yscale), true);
        }
        graphics.setColor(this._foreground);
        if (this._pointsPersistence > 0) {
            graphics.setPaintMode();
        }
    }

    private boolean _isConnected(int n) {
        if (n < 0) {
            return this._connected;
        }
        this._checkDatasetIndex(n);
        Format format = (Format)this._formats.elementAt(n);
        if (format.connectedUseDefault) {
            return this._connected;
        }
        return format.connected;
    }

    public synchronized void clearPoints() {
        for (int i = 0; i < this._points.size(); ++i) {
            Vector vector = (Vector)this._points.get(i);
            vector.clear();
        }
    }

    public void setDrawOnAddPoint(boolean bl) {
        this.drawOnPlotPoint = bl;
    }

    private class Format {
        public boolean connected;
        public boolean connectedUseDefault = true;
        public boolean impulses;
        public boolean impulsesUseDefault = true;
        public int marks;
        public boolean marksUseDefault = true;

        private Format() {
        }
    }
}

