/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloConstraint;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntSetVar;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcIntSetVar;
import ilog.solver.IlcIterator;
import ilog.solver.IlcPPropagator;
import ilog.solver.IlcSolver;
import ilog.solver.kh;
import ilog.solver.ys;

class yd
extends IlcConstraint {
    protected IlcIntSetVar _var1;
    protected IlcIntSetVar _var2;
    protected IlcIntSetVar _var3;

    yd(IloIntSetVar iloIntSetVar, IloIntSetVar iloIntSetVar2, IloIntSetVar iloIntSetVar3) {
        this._var1 = (IlcIntSetVar)iloIntSetVar;
        this._var2 = (IlcIntSetVar)iloIntSetVar2;
        this._var3 = (IlcIntSetVar)iloIntSetVar3;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        return new ib((kh)this._var1.getExtracted(ilcSolver), (kh)this._var2.getExtracted(ilcSolver), (kh)this._var3.getExtracted(ilcSolver));
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("symDiff(");
        stringBuffer.append(this._var1);
        stringBuffer.append(", ");
        stringBuffer.append(this._var2);
        stringBuffer.append(", ");
        stringBuffer.append(this._var3);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        IloConstraint iloConstraint = iloCPModeler.symDiff((IloIntSetVar)iloCopyManager.getCopy(this._var1), (IloIntSetVar)iloCopyManager.getCopy(this._var2), (IloIntSetVar)iloCopyManager.getCopy(this._var3));
        iloConstraint.setName(this.getName());
        return iloConstraint;
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        this._var1.needCopy(check);
        this._var2.needCopy(check);
        this._var3.needCopy(check);
    }

    static final class ib
    extends IlcPPropagator {
        final kh uc;
        final kh vc;
        final kh wc;

        ib(kh kh2, kh kh3, kh kh4) {
            this.uc = kh2;
            this.vc = kh3;
            this.wc = kh4;
        }

        public void post() {
            IlcSolver ilcSolver = this.uc.getSolver();
            ilcSolver.add(new bt(this.uc.getCardinality(), this.vc.getCardinality(), this.wc.getCardinality()));
            this.uc.whenDomain(new ji(this.vc, this.wc, this.uc));
            this.vc.whenDomain(new ji(this.wc, this.uc, this.vc));
            this.wc.whenDomain(new ji(this.uc, this.vc, this.wc));
        }

        private void bb(kh kh2, kh kh3, kh kh4) {
            IlcIterator ilcIterator = kh4.getDomainPossibleIterator();
            while (ilcIterator.hasNext()) {
                boolean bl2;
                int n2 = ilcIterator.nextValue();
                boolean bl3 = kh2.isDomainPossible(n2);
                boolean bl4 = kh3.isDomainPossible(n2);
                boolean bl5 = bl3 ? kh2.isDomainRequired(n2) : false;
                boolean bl6 = bl2 = bl4 ? kh3.isDomainRequired(n2) : false;
                if (!bl3 && !bl4 || bl5 && bl2) {
                    kh4.removeDomainPossible(n2);
                    continue;
                }
                if ((bl3 || !bl2) && (!bl5 || bl4)) continue;
                kh4.addDomainRequired(n2);
            }
        }

        public void propagate() {
            this.bb(this.uc, this.vc, this.wc);
            this.bb(this.vc, this.wc, this.uc);
            this.bb(this.uc, this.wc, this.vc);
        }

        private boolean ab(kh kh2, kh kh3, kh kh4) {
            IlcIterator ilcIterator = kh4.getDomainRequiredIterator();
            while (ilcIterator.hasNext()) {
                boolean bl2;
                int n2 = ilcIterator.nextValue();
                boolean bl3 = kh2.isDomainPossible(n2);
                boolean bl4 = kh3.isDomainPossible(n2);
                boolean bl5 = bl3 ? kh2.isDomainRequired(n2) : false;
                boolean bl6 = bl2 = bl4 ? kh3.isDomainRequired(n2) : false;
                if ((bl3 || bl4) && (!bl5 || !bl2)) continue;
                return true;
            }
            return false;
        }

        public boolean isViolated() {
            return this.ab(this.uc, this.vc, this.wc) || this.ab(this.uc, this.wc, this.vc) || this.ab(this.vc, this.wc, this.uc);
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("symDiff(");
            stringBuffer.append(this.uc);
            stringBuffer.append(", ");
            stringBuffer.append(this.vc);
            stringBuffer.append(", ");
            stringBuffer.append(this.wc);
            stringBuffer.append(")");
            return stringBuffer.toString();
        }

        static final class ji
        extends IlcDemon {
            kh vr;
            kh wr;
            kh xr;

            ji(kh kh2, kh kh3, kh kh4) {
                this.vr = kh2;
                this.wr = kh3;
                this.xr = kh4;
            }

            public void propagate() {
                int n2;
                kh kh2 = this.vr;
                kh kh3 = this.wr;
                kh kh4 = this.xr;
                IlcIterator ilcIterator = kh4.getDeltaRequiredIterator();
                while (ilcIterator.hasNext()) {
                    n2 = ilcIterator.nextValue();
                    if (!kh2.isDomainPossible(n2)) {
                        kh3.addDomainRequired(n2);
                    } else if (kh2.isDomainRequired(n2)) {
                        kh3.removeDomainPossible(n2);
                    }
                    if (!kh3.isDomainPossible(n2)) {
                        kh2.addDomainRequired(n2);
                        continue;
                    }
                    if (!kh3.isDomainRequired(n2)) continue;
                    kh2.removeDomainPossible(n2);
                }
                ilcIterator = kh4.getDeltaPossibleIterator();
                while (ilcIterator.hasNext()) {
                    n2 = ilcIterator.nextValue();
                    if (!kh2.isDomainPossible(n2)) {
                        kh3.removeDomainPossible(n2);
                    } else if (kh2.isDomainRequired(n2)) {
                        kh3.addDomainRequired(n2);
                    }
                    if (!kh3.isDomainPossible(n2)) {
                        kh2.removeDomainPossible(n2);
                        continue;
                    }
                    if (!kh3.isDomainRequired(n2)) continue;
                    kh2.addDomainRequired(n2);
                }
            }
        }
    }

    static final class bt
    extends IlcPPropagator {
        final ys enb;
        final ys fnb;
        final ys gnb;

        bt(ys ys2, ys ys3, ys ys4) {
            this.enb = ys2;
            this.fnb = ys3;
            this.gnb = ys4;
        }

        public void post() {
            this.enb.whenRange(this);
            this.fnb.whenRange(this);
            this.gnb.whenRange(this);
        }

        public void propagate() {
            int n2 = this.enb.getDomainMax();
            int n3 = this.fnb.getDomainMax();
            int n4 = this.gnb.getDomainMax();
            int n5 = this.enb.getDomainMin();
            int n6 = this.fnb.getDomainMin();
            int n7 = this.gnb.getDomainMin();
            this.enb.setDomainRange(Math.max(n7 - n3, n6 - n4), n3 + n4);
            this.fnb.setDomainRange(Math.max(n5 - n4, n6 - n4), n2 + n4);
            this.gnb.setDomainRange(Math.max(n5 - n3, n6 - n2), n2 + n3);
        }

        public synchronized String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.enb);
            stringBuffer.append(" <= ");
            stringBuffer.append(this.fnb);
            stringBuffer.append(" + ");
            stringBuffer.append(this.gnb);
            return stringBuffer.toString();
        }
    }
}

