/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.solver.IlcSolverRuntimeError;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class IlcNum {
    private int epb;
    private int fpb;
    private int gpb;
    private int hpb;
    private int ipb;

    IlcNum(int n2, int n3, int n4) {
        this.setPrecision(n2, n3, n4);
    }

    public void setPrecision(int n2, int n3, int n4) {
        if (n2 <= 0) {
            throw new IlcSolverRuntimeError.hbb("Cannot set zero or negative Relative Precision.");
        }
        if (15 < n2 + n4) {
            throw new IlcSolverRuntimeError.hbb("relPrecision + guard_digits is too high.");
        }
        if (n3 < -291) {
            throw new IlcSolverRuntimeError.hbb("Too small negative Absolute Precision.");
        }
        if (307 < n3 + n4) {
            throw new IlcSolverRuntimeError.hbb("absPrecision + guard_digits is too high.");
        }
        if (n4 < 1) {
            throw new IlcSolverRuntimeError.hbb("Cannot have zero or negative Guard.");
        }
        this.gpb = IlcNum.bitPrecision(n2 + n4);
        this.epb = IlcNum.bitPrecision(n2);
        this.ipb = n2 + 1;
        this.fpb = IlcNum.bitPrecision(n3);
        this.hpb = IlcNum.bitPrecision(n3 + n4);
    }

    public int getRelativePrecision() {
        return IlcNum.digitPrecision(this.epb);
    }

    public int getAbsolutePrecision() {
        return IlcNum.digitPrecision(this.fpb);
    }

    public int getGuardDigits() {
        return IlcNum.digitPrecision(this.gpb) - IlcNum.digitPrecision(this.epb);
    }

    public static final double roundUp(double d2) {
        if (d2 == 0.0) {
            return Double.longBitsToDouble(1L);
        }
        if (d2 < 0.0) {
            return Double.longBitsToDouble(Double.doubleToLongBits(d2) - 1L);
        }
        if (!Double.isInfinite(d2)) {
            return Double.longBitsToDouble(Double.doubleToLongBits(d2) + 1L);
        }
        return d2;
    }

    public static final double roundDown(double d2) {
        if (d2 == 0.0) {
            return -Double.longBitsToDouble(1L);
        }
        if (d2 > 0.0) {
            return Double.longBitsToDouble(Double.doubleToLongBits(d2) - 1L);
        }
        if (!Double.isInfinite(d2)) {
            return Double.longBitsToDouble(Double.doubleToLongBits(d2) + 1L);
        }
        return d2;
    }

    public static final double roundUp(double d2, long l2) {
        if (d2 == 0.0) {
            return Double.longBitsToDouble(l2);
        }
        if (d2 < 0.0) {
            long l3 = Double.doubleToLongBits(d2) - l2;
            if (l3 >>> 63 == 1L) {
                return Double.longBitsToDouble(l3);
            }
            return -Double.longBitsToDouble((l3 ^ 0xFFFFFFFFFFFFFFFFL) + 1L);
        }
        long l4 = Double.doubleToLongBits(d2) + l2;
        if (l4 < 0x7FF0000000000000L) {
            return Double.longBitsToDouble(l4);
        }
        return Double.POSITIVE_INFINITY;
    }

    public static final double roundDown(double d2, long l2) {
        if (d2 == 0.0) {
            return -Double.longBitsToDouble(l2);
        }
        if (d2 > 0.0) {
            long l3 = Double.doubleToLongBits(d2) - l2;
            if (l3 >>> 63 == 1L) {
                return -Double.longBitsToDouble((l3 ^ 0xFFFFFFFFFFFFFFFFL) + 1L);
            }
            return Double.longBitsToDouble(l3);
        }
        long l4 = Double.doubleToLongBits(d2) + l2;
        if ((l4 ^ Long.MIN_VALUE) < 0x7FF0000000000000L) {
            return Double.longBitsToDouble(l4);
        }
        return Double.NEGATIVE_INFINITY;
    }

    public final synchronized String toString_roundDown(double d2) {
        if (d2 >= 0.0) {
            return this.toString_rounded("", Math.abs(d2), 3);
        }
        return this.toString_rounded("-", Math.abs(d2), 2);
    }

    public final synchronized String toString_roundUp(double d2) {
        if (d2 >= 0.0) {
            return this.toString_rounded("", Math.abs(d2), 2);
        }
        return this.toString_rounded("-", Math.abs(d2), 3);
    }

    public final synchronized String toString_rounded(String string, double d2, int n2) {
        Object object;
        Object object2;
        int n3 = this.ipb;
        if (Double.isInfinite(d2)) {
            return string + Double.toString(d2);
        }
        if (Double.isNaN(d2)) {
            return Double.toString(d2);
        }
        if (d2 == 0.0) {
            String string2 = "0.";
            int n4 = 0;
            while (n4 < n3 - 1) {
                string2 = string2 + "0";
                ++n4;
            }
            return string2 + "e0";
        }
        BigDecimal bigDecimal = new BigDecimal(Math.abs(d2));
        int n5 = bigDecimal.unscaledValue().toString().length();
        int n6 = bigDecimal.scale() + (n3 - n5);
        if (n6 >= 0) {
            if ((bigDecimal = bigDecimal.setScale(n6, n2)).unscaledValue().toString().length() == n3 + 1) {
                bigDecimal = bigDecimal.setScale(n6 - 1, n2);
            }
        } else {
            object2 = new BigInteger("10");
            bigDecimal = bigDecimal.setScale(0, n2);
            object = new BigDecimal(((BigInteger)object2).pow(-n6));
            bigDecimal = bigDecimal.divide((BigDecimal)object, n2).multiply((BigDecimal)object);
        }
        object2 = bigDecimal.unscaledValue().toString();
        object = Integer.toString(-bigDecimal.scale() + ((String)object2).length() - 1);
        return string + ((String)object2).substring(0, 1) + "." + ((String)object2).substring(1, n3) + "e" + (String)object;
    }

    public static final int bitPrecision(int n2) {
        return (int)Math.ceil(Math.log(10.0) / Math.log(2.0) * (double)n2) + 1;
    }

    public static final int digitPrecision(int n2) {
        int[] nArray = new int[]{1, 5, 8, 11, 15, 18, 21, 25, 28, 31, 35, 38, 41, 45, 48, 51};
        int n3 = 15;
        while (n3 >= 0) {
            if (nArray[n3] <= n2) {
                return n3;
            }
            --n3;
        }
        throw new IlcSolverRuntimeError.hbb("Unknown bit precision.");
    }

    public final double boundNextUp(double d2) {
        return IlcNum.castUp(IlcNum.roundUp(d2), this.epb, this.fpb);
    }

    public final double boundNextDown(double d2) {
        return IlcNum.castDown(IlcNum.roundDown(d2), this.epb, this.fpb);
    }

    public final double propagationNextUp(double d2) {
        return IlcNum.castUp(IlcNum.roundUp(d2), this.gpb, this.hpb);
    }

    public final double propagationNextDown(double d2) {
        return IlcNum.castDown(IlcNum.roundDown(d2), this.gpb, this.hpb);
    }

    public final double boundCastUp(double d2) {
        return IlcNum.castUp(d2, this.epb, this.fpb);
    }

    public final double boundCastDown(double d2) {
        return IlcNum.castDown(d2, this.epb, this.fpb);
    }

    public final double propagationCastUp(double d2) {
        return IlcNum.castUp(d2, this.gpb, this.hpb);
    }

    public final double propagationCastDown(double d2) {
        return IlcNum.castDown(d2, this.gpb, this.hpb);
    }

    public final boolean isBound(double d2, double d3) {
        return IlcNum.castUp(IlcNum.roundUp(d2), this.epb, this.fpb) >= IlcNum.castDown(IlcNum.roundDown(d3), this.epb, this.fpb);
    }

    public static final double castUp(double d2, int n2, int n3) {
        double d3 = Double.longBitsToDouble(1023L + (long)(n2 - n3) << 52);
        if (Math.abs(d2) > d3) {
            return IlcNum.castUpRel(d2, n2);
        }
        return IlcNum.castUpAbs(d2, n3);
    }

    public static final double castDown(double d2, int n2, int n3) {
        double d3 = Double.longBitsToDouble(1023L + (long)(n2 - n3) << 52);
        if (Math.abs(d2) > d3) {
            return IlcNum.castDownRel(d2, n2);
        }
        return IlcNum.castDownAbs(d2, n3);
    }

    public static final double castUpRel(double d2, int n2) {
        long l2;
        int n3 = 52 - n2;
        long l3 = Double.doubleToLongBits(d2);
        if (l3 == (l2 = l3 & -1L << n3) || d2 < 0.0) {
            return Double.longBitsToDouble(l2);
        }
        if (d2 < Double.longBitsToDouble(0x7FEFFFFFFFFFFFFFL & -1L << n3)) {
            return Double.longBitsToDouble(l2 + (1L << n3));
        }
        return Double.longBitsToDouble(0x7FF0000000000000L);
    }

    public static final double castDownRel(double d2, int n2) {
        long l2;
        int n3 = 52 - n2;
        long l3 = Double.doubleToLongBits(d2);
        if (l3 == (l2 = l3 & -1L << n3) || 0.0 < d2) {
            return Double.longBitsToDouble(l2);
        }
        if (-Double.longBitsToDouble(0x7FEFFFFFFFFFFFFFL & -1L << n3) < d2) {
            return Double.longBitsToDouble(l2 + (1L << n3));
        }
        return -Double.longBitsToDouble(0x7FF0000000000000L);
    }

    public static final double castUpAbs(double d2, int n2) {
        double d3 = Double.longBitsToDouble(1023L - (long)n2 << 52);
        double d4 = d2 / d3;
        if (Double.isInfinite(d4)) {
            return d2;
        }
        return d3 * Math.ceil(d4);
    }

    public static final double castDownAbs(double d2, int n2) {
        double d3 = Double.longBitsToDouble(1023L - (long)n2 << 52);
        double d4 = d2 / d3;
        if (Double.isInfinite(d4)) {
            return d2;
        }
        return d3 * Math.floor(d4);
    }
}

