/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloException;
import ilog.concert.IloIntSet;
import ilog.concert.IloIntSetVar;
import ilog.concert.IloStorable;
import ilog.solver.IlcConstraint;
import ilog.solver.IlcDemon;
import ilog.solver.IlcGoal;
import ilog.solver.IlcInstantiable;
import ilog.solver.IlcIntCollectionVarInterface;
import ilog.solver.IlcIntExpr;
import ilog.solver.IlcIntSet;
import ilog.solver.IlcIntSetExpr;
import ilog.solver.IlcIterator;
import ilog.solver.IlcSolver;
import ilog.solver.IlcSolverRuntimeError;
import ilog.solver.im;
import ilog.solver.kh;
import ilog.solver.xh;
import ilog.solver.xn;
import ilog.solver.yg;
import ilog.solver.yn;

public class IlcIntSetVar
extends IlcIntSetExpr
implements IloIntSetVar,
IlcIntCollectionVarInterface,
IlcInstantiable,
IloStorable {
    protected String _name = null;
    protected IlcIntSet _possibleSet = null;
    protected IlcIntSet _requiredSet = null;
    protected IlcIntExpr _cardinality = null;
    private im so;

    IlcIntExpr og(IlcSolver ilcSolver) {
        if (this._cardinality == null) {
            this._cardinality = new yn(this);
            ((yn)this._cardinality).resetExtracted(ilcSolver);
        }
        return this._cardinality;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    IlcIntSetVar(IloIntSet iloIntSet, String string) {
        this._possibleSet = ((IlcIntSet)iloIntSet).makeCopy();
        this._name = string;
    }

    IlcIntSetVar(IloIntSet iloIntSet) {
        this(iloIntSet, (String)null);
    }

    IlcIntSetVar(IloIntSet iloIntSet, IloIntSet iloIntSet2, String string) {
        if (iloIntSet != null) {
            this._possibleSet = ((IlcIntSet)iloIntSet).makeCopy();
        }
        if (iloIntSet2 != null) {
            this._requiredSet = ((IlcIntSet)iloIntSet2).makeCopy();
        }
        this._name = string;
    }

    IlcIntSetVar(IloIntSet iloIntSet, IloIntSet iloIntSet2) {
        this(iloIntSet, iloIntSet2, null);
    }

    public IloIntSet getPossibleSet() {
        return this._possibleSet;
    }

    public IloIntSet getRequiredSet() {
        return this._requiredSet;
    }

    public void addRequired(int n2) {
        if (this._requiredSet == null) {
            this._requiredSet = new IlcIntSet(new int[]{n2});
        } else {
            this._requiredSet.add(n2);
        }
    }

    public void removeRequired(int n2) {
        if (this._requiredSet != null) {
            this._requiredSet.remove(n2);
        }
    }

    public void removePossible(int n2) {
        this._possibleSet.remove(n2);
    }

    public void addPossible(int n2) {
        this._possibleSet.add(n2);
    }

    public int getPossibleSize() {
        if (this._possibleSet == null) {
            return 0;
        }
        return this._possibleSet.getSize();
    }

    public int getRequiredSize() {
        if (this._requiredSet == null) {
            return 0;
        }
        return this._requiredSet.getSize();
    }

    public void setPossibleSet(IloIntSet iloIntSet) {
        this._possibleSet = ((IlcIntSet)iloIntSet).makeCopy();
    }

    public void setRequiredSet(IloIntSet iloIntSet) {
        this._requiredSet = ((IlcIntSet)iloIntSet).makeCopy();
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        ilcSolver.addVar(this);
        xh xh2 = (xh)this._possibleSet.getExtracted(ilcSolver);
        if (this._requiredSet != null) {
            xh xh3 = (xh)this._requiredSet.getExtracted(ilcSolver);
            return new kh(ilcSolver, xh2, xh3);
        }
        kh kh2 = new kh(ilcSolver, xh2);
        kh2._name = this._name;
        return kh2;
    }

    public int chooseValue() {
        return ((kh)this.so).chooseValue();
    }

    public final Object getExtracted(IlcSolver ilcSolver) throws IlcSolverRuntimeError.Extraction {
        if (this.so instanceof yg) {
            ilcSolver.registerExtracted(this);
            try {
                this.so = (im)this.extract(ilcSolver);
            }
            catch (IloException iloException) {
                throw new IlcSolverRuntimeError.Extraction(iloException.getMessage(), iloException);
            }
        }
        return this.so;
    }

    public void resetExtracted(IlcSolver ilcSolver) {
        this.so = new yg(this, ilcSolver);
    }

    public synchronized String toString() {
        if (!(this.so instanceof yg)) {
            return this.so.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this._name != null) {
            stringBuffer.append(this._name);
        }
        stringBuffer.append(" InitPossibleSet : ");
        stringBuffer.append(this._possibleSet);
        stringBuffer.append(" InitRequiredSet : ");
        stringBuffer.append(this._requiredSet);
        return stringBuffer.toString();
    }

    public boolean isBound() {
        return this.so.isBound();
    }

    public IlcSolver getSolver() {
        return this.so.getSolver();
    }

    public IlcIterator getDomainPossibleIterator() {
        return this.so.getDomainPossibleIterator();
    }

    public IlcIterator getDomainRequiredIterator() {
        return this.so.getDomainRequiredIterator();
    }

    public IlcIterator getDeltaPossibleIterator() {
        return this.so.getDeltaPossibleIterator();
    }

    public IlcIterator getDeltaRequiredIterator() {
        return this.so.getDeltaRequiredIterator();
    }

    public void addDomainRequired(int n2) {
        this.so.addDomainRequired(n2);
    }

    public void removeDomainPossible(int n2) {
        this.so.removeDomainPossible(n2);
    }

    public boolean isDomainPossible(int n2) {
        return this.so.isDomainPossible(n2);
    }

    public boolean isDomainRequired(int n2) {
        return this.so.isDomainRequired(n2);
    }

    public void whenValue(IlcDemon ilcDemon) {
        this.so.whenValue(ilcDemon);
    }

    public void whenRange(IlcDemon ilcDemon) {
        this.so.whenRange(ilcDemon);
    }

    public void whenDomain(IlcDemon ilcDemon) {
        this.so.whenDomain(ilcDemon);
    }

    public void whenValue(IlcConstraint ilcConstraint) {
        this.so.whenValue(ilcConstraint.getPropagator(this.getSolver()));
    }

    public void whenRange(IlcConstraint ilcConstraint) {
        this.so.whenRange(ilcConstraint.getPropagator(this.getSolver()));
    }

    public void whenDomain(IlcConstraint ilcConstraint) {
        this.so.whenDomain(ilcConstraint.getPropagator(this.getSolver()));
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloIntSet iloIntSet = null;
        if (this._possibleSet != null) {
            iloIntSet = (IloIntSet)iloCopyManager.getCopy(this._possibleSet);
        }
        IloIntSet iloIntSet2 = null;
        if (this._requiredSet != null) {
            iloIntSet2 = (IloIntSet)iloCopyManager.getCopy(this._requiredSet);
        }
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        return iloCPModeler.intSetVar(iloIntSet, iloIntSet2, this._name);
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        if (check instanceof IloCopyManager.ExistGroundTerm) {
            throw check;
        }
        if (this._possibleSet != null) {
            this._possibleSet.needCopy(check);
        }
        if (this._requiredSet != null) {
            this._requiredSet.needCopy(check);
        }
    }

    public IlcGoal initDefaultGoal(IlcSolver ilcSolver) {
        return new xn(this);
    }
}

