/*
 * Decompiled with CFR 0.152.
 */
package ilog.solver;

import ilog.concert.IloCPModeler;
import ilog.concert.IloCopyManager;
import ilog.concert.IloCopyable;
import ilog.concert.IloDecConst;
import ilog.concert.IloException;
import ilog.solver.IlcDec;
import ilog.solver.IlcDecExpr;
import ilog.solver.IlcSolver;
import ilog.solver.iv;
import ilog.solver.nu;

public final class IlcDecConst
extends IlcDecExpr
implements IloDecConst {
    protected int _decPrecision;
    protected double _lb;
    protected double _ub;

    public final int getScale() {
        return this._decPrecision;
    }

    public IlcDecConst(String string) {
        this._decPrecision = IlcDec.getValuePrecision(string);
        this._lb = IlcDec.getValueLB(string);
        this._ub = IlcDec.getValueUB(string);
    }

    public IlcDecConst(String string, int n2) {
        this._decPrecision = n2;
        this._lb = IlcDec.getValueLB(string, n2);
        this._ub = IlcDec.getValueUB(string, n2);
    }

    public IlcDecConst(long l2, int n2) {
        this._decPrecision = n2;
        this._lb = IlcDec.getValueLB(l2, this._decPrecision);
        this._ub = IlcDec.getValueUB(l2, this._decPrecision);
    }

    public IlcDecConst(double d2, double d3, int n2) throws IloException {
        this._decPrecision = n2;
        this._lb = IlcDec.castUp(d2, this._decPrecision);
        this._ub = IlcDec.castDown(d3, this._decPrecision);
        if (this._lb > this._ub) {
            throw new IloException("Declaring invalid decimal constant.");
        }
    }

    public double getLB() {
        return this._lb;
    }

    public double getUB() {
        return this._ub;
    }

    public Object extract(IlcSolver ilcSolver) throws IloException {
        iv iv2 = new iv(ilcSolver, this._lb, this._ub, this._decPrecision);
        return iv2;
    }

    public synchronized String toString() {
        if (!(this._extracted instanceof nu)) {
            return this._extracted.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(IlcDec.getValueString(this._lb, this._ub, this._decPrecision));
        return stringBuffer.toString();
    }

    public IloCopyable makeCopy(IloCopyManager iloCopyManager) throws IloException {
        IloCPModeler iloCPModeler = (IloCPModeler)iloCopyManager.getModeler();
        return iloCPModeler.decConst(IlcDec.getValueString(this._lb, this._ub, this._decPrecision), this._decPrecision);
    }

    public void needCopy(IloCopyManager.Check check) throws IloCopyManager.Check {
        if (check instanceof IloCopyManager.ExistGroundTerm) {
            throw check;
        }
    }
}

