#include <stdio.h>
#include <stdlib.h>
#include "baby.h"

int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <filename>\n", argv[0]);
        return 1;
    }

    const char *filename = argv[1];  
    FILE *file = fopen(filename, "rb");  

    if (file == NULL) {
        perror("Failed to open file");
        return 1;
    }

    fseek(file, 0, SEEK_END);            
    long file_size = ftell(file);        
    fseek(file, 0, SEEK_SET);            

    char *buffer = (char *)malloc(file_size);
    if (buffer == NULL) {
        perror("Memory allocation failed");
        fclose(file);
        return 1;
    }

    size_t bytes_read = fread(buffer, 1, file_size, file);
    if (bytes_read != file_size) {
        perror("Error reading file");
        free(buffer);
        fclose(file);
        return 1;
    }

    something(buffer);

    free(buffer);
    fclose(file);

    return 0;
}
