# Intro to libfuzzer

Link to the slides: https://docs.google.com/presentation/d/1H-KCHDYY4g0Y3fgkgDnEg9k_yjolUIMGvnj1huzC1N4/edit?usp=sharing

To practice and get an understanding of how libfuzzer works we provide you with two toy projects. For each program you should write a libfuzzer based fuzzing harness, fuzz the target and visualize the coverage.

## Baby

There are three targets in baby1.h, baby2.h and baby3.h. For each `something` function, implement a fuzzing harness, fuzz until you find the crash and then reproduce the crash with your harness.

## Y0l0png

A png parsing library with the goal is to implement the fuzzing harness for the following four targets:

- the load_png function fuzzing the content of the png file
- the load_png function fuzzing the png fiilename
- the store_png function without palette
- the store_png function with palette

After fuzzing for a bit, visualize the coverage of all your fuzzing runs. Are there regions that are not covered yet? Think about why these are not covered and update/add new harnesses to cover these areas.


