from .facteurs_certitude import fc_ou
from moteur_avec_variables_fc.regle_avec_variables_fc import RegleAvecVariables_FC

class BaseConnaissances_FC:
    """ Une base de connaissances destinée à contenir les faits et les règles\
        d'un système de chaînage avec facteurs de certitude.
    """

    def __init__(self):
        """ Construit une base de connaissances. """

        self.faits = {}
        self.regles = []

    def ajoute_un_fait(self, fait):
        """ Ajoute un fait dans la base de connaissances.

            Un fait est un tuple composé du fait proprement dit, c'est-à-dire\
            une proposition sans variable, et optionnellement d'un scalaire\
            représentant son facteur de certitude.

            :param fait: un fait.
        """

        print('à compléter')

    def ajoute_faits(self, faits):
        """ Ajoute une liste de faits dans la base de connaissances.

            :param list faits: une liste de faits.
        """

        for fait in faits:
            self.ajoute_un_fait(fait)

    def ajoute_une_regle(self, description):
        """ Ajoute une règle dans la base de connaissances étant donné sa\
            description.

            Une règle est décrite par une liste (ou un tuple) de deux ou trois\
            éléments: une liste de conditions, une conclusion et un facteur de\
            certitude optionnel.

            Les conditions et la conclusion doivent être des propositions.

            :param description: une description de règle.
        """

        print('à compléter')

    def ajoute_regles(self, descriptions):
        """ Ajoute des règles dans la base de connaissance.

            L'argument est une liste de descriptions, chacune composée d'une\
            liste de conditions, d'une conséquence et optionnellement d'un\
            facteur de certitude.

            :param list descriptions: une liste de descriptions de règles.
        """

        for description in descriptions:
            self.ajoute_une_regle(description)