from moteur_sans_variables.chainage import Chainage
from moteur_avec_variables.filtre import Filtre

class ChainageAvantAvecVariables_FC(Chainage):
    """ Un moteur d'inférence à chaînage avant avec variables. """

    def __init__(self, connaissances, methode=None):
        """
            :param methode: ``Filtre`` ou ``Unificateur``, détermine le type de\
            pattern match à appliquer. ``Filtre`` par défaut.
        """

        Chainage.__init__(self, connaissances)

        if methode is None:
            self.methode = Filtre()
        else:
            self.methode = methode

    def instancie_conclusion(self, regle, envs_et_fcs):
        """ Instancie la conclusion d'une règle pour tous les environnements.

            :param regle: la règle dont la conclusion doit être instanciée.
            :param list envs_et_fcs: une liste de paires d'environnements et de\
            facteurs de certitude servant à instancier la conclusion de la règle.
            :return: une liste de propositions correspondant aux différentes\
            instanciations de la conclusion.
        """

        print('à compléter')

    def chaine(self):
        """ Effectue le chaînage avant sur les faits et les règles contenus\
            dans la base de connaissances.
        """

        print('à compléter')