from sys import argv, exit
from moteur_avec_variables_fc.regle_avec_variables_fc import RegleAvecVariables_FC
from moteur_avec_variables_fc.connaissance_fc import BaseConnaissances_FC
from moteur_avec_variables.unificateur import Unificateur
from moteur_avec_variables.filtre import Filtre
from moteur_avec_variables_fc.chainage_avant_avec_variables_fc import ChainageAvantAvecVariables_FC

regles = [
    ([('placentaire', '?x')], ('mammifère', '?x')),
    ([('marsupial', '?x')], ('mammifère', '?x')),
    ([('monotrème', '?x')], ('mammifère', '?x')),
    ([('placentaire-1', '?x')], ('placentaire', '?x')),
    ([('genre-placentaire', '?x')], ('placentaire', '?x')),
    ([('a-des-poils', '?x'), ('a-des-bébés-formes', '?x'), 
      ('température-stable', '?x')], 
     ('placentaire-1', '?x'), 9.0/10.0),
    ([('a-des-poils', '?x'), ('a-des-bébés-foetaux', '?x'), 
      ('température-stable', '?x')], 
     ('marsupial', '?x'), 95.0/100.0),
    ([('a-des-oeufs', '?x'), ('a-des-poils', '?x'), 
      ('température-stable', '?x')], 
     ('monotrème', '?x')),
    ([('singe', '?x')], ('genre-placentaire', '?x')),
    ([('primate', '?x')], ('singe', '?x')),
    ([('lémurien', '?x')], ('singe', '?x')),
    ([('chimpanzé', '?x')], ('primate', '?x')),
    ([('gorille', '?x')], ('primate', '?x')),
    ([('canidé', '?x')], ('genre-placentaire', '?x')),
    ([('chien', '?x')], ('canidé', '?x')),
    ([('loup', '?x')], ('canidé', '?x')),
    ([('lycaon', '?x')], ('canidé', '?x')),
    ([('félin', '?x')], ('genre-placentaire', '?x')),
    ([('chat', '?x')], ('félin', '?x')),
    ([('lion', '?x')], ('félin', '?x')),
    ([('tigre', '?x')], ('félin', '?x')),
    ([('tigre-du-bengale', '?x')], ('tigre', '?x')),
    ([('tigre-de-l-himalaya', '?x')], ('tigre', '?x')),
    ]

if len(argv) < 2 or argv[1].lower() not in ('a', 'b'):
    print('On attend au moins un arguments: A ou B')
    exit(1)

if argv[1].lower() == 'a':
    faits_initiaux = [
        (('a-des-poils', 'blaireau'),),
        (('a-des-bébés-formes', 'blaireau'),),
        (('température-stable', 'blaireau'),),
        (('a-des-poils', 'écureuil'),),
        (('a-des-bébés-formes', 'écureuil'),),
        (('température-stable', 'écureuil'),),
        (('chimpanzé', 'cheetah'),),
        (('gorille', 'bozo'),),
        (('singe', 'babouin'),),
        (('singe', 'paresseux'),),
        (('chien', 'bill'),),
        (('loup', 'loup-1'),),
        (('lycaon', 'lycaon-1'),),
        (('chat', 'mistigri'),),
        (('lion', 'minet'),),
        (('tigre-du-bengale', 'tigre-du-bengale-1'),),
        (('a-des-poils', 'kangourou'),),
        (('a-des-bébés-foetaux', 'kangourou'),),
        (('température-stable', 'kangourou'),),
        (('a-des-oeufs', 'ornythorinque'),),
        (('a-des-oeufs', 'nouveau-spécimen'), 5.0/10.0),
        (('a-des-poils', 'ornythorinque'),),
        (('température-stable', 'nouveau-spécimen'), 9.0/10.0),
        (('température-stable', 'ornythorinque'),),
    ]
elif argv[1].lower() == 'b':
    faits_initiaux = [
        (('a-des-oeufs', 'nouveau-spécimen'), 5.0/10.0),
        (('température-stable', 'nouveau-spécimen'), 9.0/10.0),
        (('a-des-poils', 'nouveau-spécimen'), 9.0/10.0),
        (('a-des-poils', 'écureuil'),),
        (('a-des-bébé-formes', 'écureuil'),),
        (('température-stable', 'écureuil'),),
        (('a-des-poils', 'un-spécimen-qui-ressemble-à-un-écureuil'), 0.9),
        (('a-des-bébé-formes', 'un-spécimen-qui-ressemble-à-un-écureuil'), 0.7),
        (('température-stable', 'un-spécimen-qui-ressemble-à-un-écureuil'), 0.8),
    ]

bc = BaseConnaissances_FC()
bc.ajoute_faits(faits_initiaux)
bc.ajoute_regles(regles)

moteur = ChainageAvantAvecVariables_FC(connaissances=bc, methode=Filtre())
moteur.chaine()

moteur.affiche_solutions()

if len(argv) > 2 and argv[2].lower() == 'trace':
    moteur.affiche_trace()