from moteur_planification.operateur import Operateur
from moteur_planification.planification import Planification

def format_g(acteur):
    """ Retourne une string représentant un acteur à gauche. """

    return 'g({})'.format(acteur)
    
def format_d(acteur):
    """ Retourne une string représentant un acteur à droite. """

    return 'd({})'.format(acteur)
    
def format_dg(bateau, pilote):
    """ Retourne une string représentant une traversée de droite à gauche. """

    return 'dg({}, {})'.format(bateau, pilote)
    
def format_gd(bateau, pilote, passager):
    """ Retourne une string représentant une traversée de gauche à droite. """

    return 'gd({}, {}, {})'.format(bateau, pilote, passager)


bateaux = ['B']
missionnaires = ['M1', 'M2']
cannibales = ['C1', 'C2']

acteurs = bateaux + missionnaires + cannibales

# Ajoute les propositions pour la position des acteurs.
propositions = []
for acteur in acteurs:
    propositions.append(format_g(acteur))
    propositions.append(format_d(acteur))

# Ajoute les opérateurs de déplacement.
operateurs = []
for bateau in bateaux:
    for pilote in missionnaires:
        # Déplacements du bateau sans passagers (droite à gauche).
        operateurs.append(Operateur(
            format_dg(bateau, pilote),
            [format_d(bateau), format_d(pilote)],
            [format_g(bateau), format_g(pilote)])
            )

        for passager in missionnaires + cannibales:
            # Déplacements du bateau avec passagers (gauche à droite).
            if passager != pilote:
                operateurs.append(Operateur(
                    format_gd(bateau, pilote, passager),
                    [format_g(bateau), format_g(pilote), format_g(passager)],
                    [format_d(bateau), format_d(pilote), format_d(passager)])
                    )

# Ajoute les mutex de proposition (un acteur ne peut pas être sur les deux rives 
# simultanément).
mutex_propositions = []
for acteur in acteurs:
    mutex_propositions.append((format_g(acteur), format_d(acteur)))

# Ajoute les mutex d'opérateurs.
mutex_operateurs = []
for i in range(len(operateurs)):
    for j in range(i+1, len(operateurs)):
        for acteur in acteurs:

            if ((format_d(acteur) in operateurs[i].precond or 
                 format_g(acteur) in operateurs[i].precond)
                and
                (format_d(acteur) in operateurs[j].precond or 
                 format_g(acteur) in operateurs[j].precond)):

                mutex_operateurs.append((operateurs[i], operateurs[j]))
                break

# Ajoute les contraintes initiales (tous les acteurs à gauche).
depart = []
for acteur in acteurs:
    depart.append((format_g(acteur), True))

# Ajoute les contraintes finales (but: tous les acteurs à droite).
but = []
for acteur in acteurs:
    but.append((format_d(acteur), True))

# Transforme le problème de planification en PSC.
plan = Planification(propositions, operateurs, 
                     mutex_propositions, mutex_operateurs, 
                     depart, but, 
                     nb_etats=5)
plan.resoudre()

plan.affice_solutions()