from .cluster import Cluster

class ClusterMean(Cluster):
    """ Représentation d'un cluster utilisé dans l'algorithme du\
        k-means.
    """

    def __init__(self, donnees, nom):
        """ Initialise le cluster avec un nom et une liste de données.

            :param list donnees: les données du cluster.
            :param str nom: le nom du cluster.
        """

        Cluster.__init__(self, donnees, nom)
        self.noyau = self.donnees[0] if len(self.donnees) > 0 else None

    def centre(self, dist_f):
        """ Recentre le noyau du cluster en fonction des données qu'il contient.

            :param dist_f: la fonction de distance entre deux données.
        """
        if len(self.donnees) == 0:
            return

        sommes_distances = []
        for el in self.donnees:
            # Calcule la somme des distances au carré entre chaque donnée et
            # le reste des données du cluster.
            somme_distances = sum([dist_f(el, el1)**2 for el1 in self.donnees])
            # Ajoute un tuple avec le format (somme des distances au carrée, donnée).
            sommes_distances.append((somme_distances, el))

        # Choisi comme nouveau noyau la donnée qui minimise la somme des 
        # distances au carré.
        self.noyau = min(sommes_distances, key=lambda x: x[0])[1]

    def vide(self, garde_noyau=False):
        """ Vide la liste des données du cluster avec l'option de garder le\
            noyau. 
        """ 

        if garde_noyau:
            self.donnees = [self.noyau]
        else:
            self.donnees = []
            self.noyau = None

    def __repr__(self):
        """ Représentation d'un cluster sous forme de string. """

        rep = 'Cluster {}: \n'.format(self.nom)
        for donnee in self.donnees:
            indent = '--->' if donnee == self.noyau else ' '*4
            rep += '{}{}\n'.format(indent, donnee)
        return rep