from sys import argv, exit
from moteurs_clustering.clustering_kmeans import ClusteringKMeans
from moteurs_clustering.clustering_hierarchique import ClusteringHierarchique

def distance(donnee1, donnee2):
    """ Calcule la distance entre deux données en comptant le nombre\
        d'attributs non identiques.

        :param donnee1: la première donnée.
        :param donnee2: la seconde donnée.
    """

    if len(donnee1) != len(donnee2):
        raise Exception('Les deux données doivent avoir le même nombre d\'attributs.')

    return sum(attrib1 != attrib2 for attrib1, attrib2 in zip(donnee1, donnee2))

def est_entier_positif(s):
    " Teste si une string représente un entier positif. "
    
    try: 
        return int(s) > 0
    except ValueError:
        return False

profits = [
    ('down', 'old', 'no', 'software'),
    ('down', 'midlife', 'yes', 'software'),
    ('up', 'midlife', 'no', 'hardware'),
    ('down', 'old', 'no', 'hardware'),
    ('up', 'new', 'no', 'hardware'),
    ('up', 'new', 'no', 'software'),
    ('up', 'midlife', 'no', 'software'),
    ('up', 'new', 'yes', 'software'),
    ('down', 'midlife', 'yes', 'hardware'),
    ('down', 'old', 'yes', 'software'),
]


maladies = [
    ('angine-érythémateuse', 'élevée', 'gonflées', 'oui', 'oui', 'non', 'non', 
     'non', 'normale', 'normales', 'normaux'),
    ('angine-pultacée', 'élevée', 'points-blancs', 'oui', 'oui', 'non', 'non', 
     'non', 'normale', 'normales', 'normaux'),
    ('angine-diphtérique', 'légère', 'enduit-blanc', 'oui', 'oui', 'non', 'non', 
     'non', 'normale', 'normales', 'normaux'),
    ('appendicite', 'légère', 'normales', 'non', 'non', 'oui', 'non', 
     'non', 'normale', 'normales', 'normaux'),
    ('bronchite', 'légère', 'normales', 'oui', 'non', 'non', 'oui', 
     'oui', 'gênée', 'normales', 'normaux'),
    ('coqueluche', 'légère', 'normales', 'non', 'oui', 'non', 'oui', 
     'oui', 'gênée', 'normales', 'normaux'),
    ('pneumonie', 'élevée', 'normales', 'non', 'non', 'non', 'oui', 
     'non', 'rapide', 'rouges', 'normaux'),
    ('rougeole', 'légère', 'normales', 'non', 'oui', 'non', 'oui', 
     'oui', 'normale', 'normales', 'larmoyants'),
    ('rougeole', 'légère', 'normales', 'non', 'oui', 'non', 'oui', 
     'oui', 'normale', 'taches-rouges', 'larmoyants'),
    ('rubéole', 'légère', 'normales', 'oui', 'non', 'non', 'non', 
     'non', 'normale', 'taches-rouges', 'normaux'),
    ('rubéole', 'non', 'normales', 'oui', 'non', 'non', 'non', 
     'non', 'normale', 'taches-rouges', 'normaux'),
    ('rubéole', 'non', 'normales', 'oui', 'non', 'non', 'non', 
     'non', 'normale', 'normales', 'normaux'),
]

if len(argv) < 4:
    print('On attend trois arguments: ' +
          'type des exemples ("profits", "maladies"), ' +
          'nombre de clusters (pour le clustering k-means), '
          'type de lien ("single", "complete", pour le clustering hiérarchique)')
    exit(1)

if argv[1].lower() == 'profits':
    donnees = profits
elif argv[1].lower() == 'maladies':
    donnees = maladies
else:
     print('Type des exemples accepté : profits ou maladies')
     exit(1)

if not est_entier_positif(argv[2]):
    print('Nombre de clusters accepté : entier positif')
    exit(1)
    
k = int(argv[2])

if argv[3].lower() not in ('single', 'complete'):
    print('Type de lien accepté : single ou complete')
    exit(1)

type_lien = argv[3]

clustering = ClusteringKMeans(k, distance)
clustering.itere(donnees)

print('Clustering k-means:')
clustering.affiche_clusters()

clustering = ClusteringHierarchique(type_lien, distance)
clustering.itere(donnees)

print('Clustering hiérarchique:')
clustering.affiche_clusters()