from moteur_psc_heuristique.variable_avec_label import VariableAvecLabel

class Etat:
    """ Un état du plan."""

    def __init__(self, no_etat, propositions, operateurs, etat_prec=None):
        """
            :param no_etat: numéro de l'état dans le plan.
            :param list propositions: liste des propositions de planification.
            :param list operateurs: liste des opérateurs applicables dans le plan.
            :param etat_prec: l'état précédent.
        """

        self.no_etat = no_etat
        self.etat_prec = etat_prec

        self.operateurs = { op.nom: op for op in operateurs }

        self.vars_initiales = {}
        self.vars_finales = {}

        self.construire_vars_operateurs(operateurs)
        self.construire_vars_propositions(propositions)

    def construire_vars_operateurs(self, ops):
        """ Construit les variables de l'état représentant l'utilisation des\
            opérateurs.
        """

        self.vars_operateurs = {}

        for op in ops:
            var_nom = '{} état {}'.format(op.nom, self.no_etat)
            self.vars_operateurs[op.nom] = VariableAvecLabel(var_nom, 
                                                             [True, False])

    def construire_vars_propositions(self, props):
        """ Construit les variables de l'état représentant les propositions.

            Les variables initiales sont les variables finales de l'état\
            précédent sauf lorsqu'il n'en existe pas.
        """
        if self.no_etat > 0:
            self.vars_initiales = self.etat_prec.vars_finales

        for prop in props:
            var_nom = '{} état {}'.format(prop, self.no_etat + 1)
            self.vars_finales[prop] = VariableAvecLabel(var_nom, 
                                                        [True, False])
            if self.no_etat == 0:
                var_nom = '{} état 0'.format(prop)
                self.vars_initiales[prop] = VariableAvecLabel(var_nom, 
                                                              [True, False])

    def variables(self):
        """ La liste des variables de l'état (variables initiales, finales et\
            variables d'opérateurs).

            :return: une liste de variables.
        """

        return (list(self.vars_initiales.values()) +
                list(self.vars_finales.values()) +
                list(self.vars_operateurs.values()))