
class PSC:
    def __init__(self, variables, contraintes):
        """ 
            :param list variables: les variables du problème.
            :param list contraintes: les contraintes du problème.
        """

        self.variables = variables
        self.contraintes = contraintes

        self.iterations = 0
        self.solutions = []

    def consistance_noeuds(self):
        """ Applique la consistance des noeuds sur les contraintes unaires du\
            problème.

            L'algorithme consiste à enlever des domaines de définition toutes\
            les valeurs qui violent les contraintes unaires.
        """
        for contrainte in self.contraintes:
            if contrainte.dimension() == 1:
                # Nous créons un nouveau domaine en ne gardant que les 
                # valeurs valides.
                # Le plus simple est d'utiliser la `list comprehension' avec 
                # une condition.
                contrainte.variables[0].domaine = [var for var in contrainte.variables[0].domaine if contrainte.est_valide(var)]

    def consistance_arcs(self):
        """ Applique la consistance d'arcs sur les contraintes binaires du\
            problème.
        """
        refaire = False
        for contrainte in self.contraintes:
            if contrainte.dimension() == 2 and contrainte.reviser():
                refaire = True

        if refaire:
            self.consistance_arcs()

    def consistance_avec_vars_precedentes(self, k):
        """ Vérifie si toutes les contraintes concernant les variables déjà\
            instanciées sont satisfaites.
        """
        for contrainte in self.contraintes:
            # Si la variables courante est concernée.
            if self.variables[k] in contrainte.variables:
                for i in range(k):
                    # Si n'importe laquelle des variables précédentes est concernée.
                    if self.variables[i] in contrainte.variables:
                        if contrainte.est_valide(self.variables[k], self.variables[k].val):
                            break
                        else:
                            return False
        # Toutes les contraintes sont valides.
        return True

    def backtracking(self, k=0, une_seule_solution=False):
        """ Algorithme de Backtracking simple.
            
            Tente d'assigner une valeur à chaque variable. Lors de chaque\
            assignation, vérifie que toutes les contraintes des variables\
            instanciées sont satisfaites. Sinon, revient en arrière pour essayer\
            une autre valeur.
            
            :param k: la profondeur de la recherche.
            :param une_seule_solution: indique à l'algorithme s'il faut\
            s'arrêter après avoir trouvé la première solution.
        """
        if len(self.solutions) == 1 and une_seule_solution:
            return

        self.iterations += 1
        # On est parvenu à une solution.
        if k >= len(self.variables):
            sol = {}
            for var in self.variables:
                sol[var.nom] = var.val
            if len(self.solutions) == 0 or not une_seule_solution:
                self.solutions.append(sol)
        else:
            var = self.variables[k]
            for val in var.domaine:
                var.val = val
                if self.consistance_avec_vars_precedentes(k):
                    # On continue l'algorithme sur la variable k+1.
                    self.backtracking(k=k+1, une_seule_solution=une_seule_solution)
            var.val = None

    def affiche_solutions(self):
        """ Méthode pour afficher les solutions découvertes par l'algorithme."""

        print('Recherche terminée en {} itérations'.format(self.iterations))

        if len(self.solutions) == 0:
            print('Aucune solution trouvée')
            return

        for sol in self.solutions:
            print('Solution')
            print('========')
            for (nom, var) in sorted(sol.items()):
                print('\tVariable {}: {}'.format(nom, var))