from moteur_psc.variable import Variable
from moteur_psc.contrainte import ContrainteUnaire, ContrainteBinaire
from moteur_psc.psc import PSC

variables = [
             Variable('a', [2, 3]),
             Variable('b', list(range(12))),
             Variable('c', list(range(3))),
             Variable('d', list(range(3))),
             Variable('e', list(range(12))),
             ]

contraintes = [
    ContrainteUnaire(variables[1], lambda x: x < 4),
    ContrainteBinaire(variables[0], variables[1], lambda x, y: x != y),
    ContrainteBinaire(variables[1], variables[2], lambda x, y: x != y),
    ContrainteBinaire(variables[1], variables[3], lambda x, y: x != y),
    ContrainteBinaire(variables[1], variables[4], lambda x, y: x != y),
    ContrainteBinaire(variables[2], variables[3], lambda x, y: x != y),
    ContrainteBinaire(variables[2], variables[4], lambda x, y: x != y),
    ContrainteBinaire(variables[3], variables[4], lambda x, y: x != y),
    ContrainteBinaire(variables[4], variables[0], lambda x, y: x < y),
]

psc = PSC(variables, contraintes)

psc.consistance_noeuds()
psc.consistance_arcs()
psc.backtracking(0, False)

psc.affiche_solutions()