from math import sqrt
from unittest import TestCase
from moteurs_recherche.ville import Ville

class TestVille(TestCase):

    def test_distance(self):
        v1 = Ville(0, 0, "1")
        v2 = Ville(0, 1, "2")
        v3 = Ville(1, 0, "3")
        v4 = Ville(1, 1, "4")

        self.assertEqual(v1.distance(v2), 1)
        self.assertEqual(v1.distance(v3), 1)
        self.assertEqual(v1.distance(v4), sqrt(2))

    def test_eq(self):
        v1 = Ville(1, 2, "blah")
        v2 = Ville(1, 2, "blah")
        v3 = Ville(1, 2, "lah")
        v4 = Ville(1, 3, "blah")
        v5 = Ville(2, 2, "blah")
        v6 = Ville(2, 3, "lah")

        self.assertEqual(v1, v2)
        self.assertFalse(v1 == v3)
        self.assertFalse(v1 == v4)
        self.assertFalse(v1 == v5)
        self.assertFalse(v1 == v6)