from unittest import TestCase
from moteurs_recherche.ville import Ville
from moteurs_recherche.espace import Espace

class TestEspace(TestCase):

    def setUp(self):

        self.elements = {
            'a': Ville(0, 0, 'a'),
            'b': Ville(0, 1, 'b'),
            'c': Ville(1, 0, 'c'),
            'd': Ville(-1, 0, 'd'),
            'e': Ville(0, -1, 'e'),
        }

        self.espace = Espace([self.elements['a'], self.elements['b'], 
                              self.elements['c'], self.elements['d'], 
                              self.elements['e']],
                [(self.elements['a'], self.elements['b']), 
                 (self.elements['a'], self.elements['c']), 
                 (self.elements['a'], self.elements['d'])])

    def test_voisins(self):
        self.assertEqual(self.espace.trouve_voisins(self.elements['a']), 
                         [self.elements['b'], self.elements['c'], self.elements['d']])
