from unittest import TestCase
from moteurs_recherche.ville import Ville
from moteurs_recherche.espace import Espace
from moteurs_recherche.noeud import Noeud
from moteurs_recherche.recherche import Recherche
from moteurs_recherche.astar import RechercheAStar

class TestAStar(TestCase):

    def setUp(self):
        self.elements = {
            'a': Ville(0, 0, 'a'),
            'b': Ville(0, 2, 'b'),
            'c': Ville(2, 2, 'c'),
            'd': Ville(3, 4, 'd'),
            'e': Ville(4, 2, 'e'),
            'f': Ville(4, 4, 'f'),
        }

        self.espace = Espace([self.elements['a'], self.elements['b'], 
                              self.elements['c'], self.elements['d'], 
                              self.elements['e'], self.elements['f']],
                [(self.elements['a'], self.elements['b']),
                 (self.elements['a'], self.elements['c']),
                 (self.elements['b'], self.elements['d']),
                 (self.elements['d'], self.elements['f']),
                 (self.elements['c'], self.elements['d']),
                 (self.elements['c'], self.elements['e']),
                 (self.elements['e'], self.elements['f'])])

    def test_ajoute_successeurs(self):
        astar = RechercheAStar(self.espace)
        astar.h = lambda e: e.distance(self.elements['f'])

        a = Noeud(self.elements['a'])
        a.cout = 0
        a.cout_f = astar.h(self.elements['a'])

        queue = [a]
        
        for i in range(3):
            successeurs = astar.trouve_successeurs(queue.pop(0))
            queue = astar.ajoute_successeurs(queue, successeurs)
            print(queue)
        
        self.assertAlmostEqual(queue[0].cout_f, 6.064495, places=4)

        self.assertEqual(queue, sorted(queue, key=lambda n: n.cout_f))

    def test_astar(self):
        astar = RechercheAStar(self.espace)
        chemin = astar.recherche(self.elements['a'], self.elements['f'])
        self.assertEqual(chemin, [self.elements['a'], self.elements['c'],
                                  self.elements['d'], self.elements['f']])
