from math import sqrt
from .element import Element

class Ville(Element):
    """ Un élément représentant une ville. 
    """

    def __init__(self, x, y, nom=''):
        """
            :param x: coordonnée en x de la ville.
            :param y: coordonnée en y de la ville.
            :param str nom: nom de la ville.
        """

        Element.__init__(self, nom)
        self.x = x
        self.y = y

    def distance(self, ville):
        """ Distance euclidienne entre la ville courante et la ville ``ville``. """
        return sqrt((self.x-ville.x)**2 + (self.y-ville.y)**2)

    def __eq__(self, autre):
        if not isinstance(autre, Ville):
            return False
        return self.x == autre.x and self.y == autre.y and self.nom == autre.nom

    def __hash__(self):
        return hash(str(self))

    def __repr__(self):
        return '{}({}, {})'.format(self.nom, self.x, self.y)