from math import sqrt

class Noeud:
    """ Noeud généré de façon dynamique par un algorithme de recherche,\
        encapsulant un élément de l'espace de recherche. 
    """

    def __init__(self, element, parent=None, cout=0, cout_f=0):
        """
            :param Element element: l'élément encapsulé.
            :param Noeud parent: le noeud parent du noeud courant, c'est-à-dire\
            le noeud qui a conduit à la découverte du noeud courant au cours de la\
            recherche.
            :param cout: coût du noeud courant (utile uniquement pour A\*).
            :param cout_f: coût heuristique du noeud courant (utile uniquement\
            pour A\*).
        """
        self.element = element
        self.parent = parent
        self.cout = cout
        self.cout_f = cout_f

    def __repr__(self):
        rep = '<{}, {}, {}>'.format(self.element, 
                                   round(self.cout), 
                                   round(self.cout_f))
        return rep